
/* snd2aiff.c
 *
 * This file is part of fizmo.
 *
 * Copyright (c) 2009 Christoph Ender.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


#include <stdlib.h>
#include <stdio.h>
#include <inttypes.h>
#include <math.h>

int main(int argc, char *argv[])
{
  FILE *in, *out;
  int src_len;
  char repeats_to_play;
  char base_note;
  int frequency;
  int data_length;
  double *samples;
  int input;
  unsigned short v;
  int i;
  unsigned long filesize;
  double minimum,maximum,scale,middle;
  double result;
  int e;
  unsigned long int m;
  int n;

  if (argc != 3)
  {
    printf("\nSyntax: snd2aiff <src> <dest>\n\n");
    exit(1);
  }

  in = fopen(argv[1], "r");
  src_len = ((int)fgetc(in) << 8) | fgetc(in);
  repeats_to_play = (int)fgetc(in);
  base_note = (int)fgetc(in);
  frequency = ((int)fgetc(in) << 8) | fgetc(in);
  fseek(in, 2, SEEK_CUR);
  data_length = ((int)fgetc(in) << 8) | fgetc(in);

  printf("len:%d, repeats:%d, basenote:%d, freq:%d, datlen:%d\n",
      src_len, repeats_to_play, base_note, frequency, data_length);

  samples = malloc(data_length * sizeof(double));
  for (i=0; i<data_length; i++)
  {
    input = (unsigned int)fgetc(in);
    samples[i] = (double)input;
  }
  fclose(in);

  out = fopen(argv[2], "wb");

  filesize = 46 + 2 * data_length;
  fprintf(out,"FORM");
  fputc((filesize & 0xff000000) >> 24, out);
  fputc((filesize & 0xff0000) >> 16, out);
  fputc((filesize & 0xff00) >> 8, out);
  fputc((filesize & 0xff), out);
  fprintf(out,"AIFF");

  fprintf(out,"COMM");
  // Chunksize always 18
  fputc(0,out);
  fputc(0,out);
  fputc(0,out);
  fputc(18,out);

  // 1 Channel
  fputc(0,out);
  fputc(1,out);

  // Number of samples
  fputc((data_length & 0xff000000) >> 24, out);
  fputc((data_length & 0xff0000) >> 16, out);
  fputc((data_length & 0xff00) >> 8, out);
  fputc((data_length & 0xff), out);

  // Samplesize = 16
  fputc(0,out);
  fputc(16,out);

  result = frexp (frequency , &n);
  e = (((int)n-2) & 0x3fff) | 0x4000;
  fputc((e >> 8), out);
  fputc((e & 0xff), out);

  m = (long int)(result * 0x1000000);
  fputc((m & 0x00ff0000) >> 16,out);
  fputc((m & 0x0000ff00) >> 8,out);
  fputc((m & 0x000000ff),out);
  fputc(0,out);
  fputc(0,out);
  fputc(0,out);
  fputc(0,out);
  fputc(0,out);

  /* Write the sound data chunk */
  fprintf(out,"SSND");
  // Size of sample data
  fputc(((2*data_length+8) & 0xff000000) >> 24, out);
  fputc(((2*data_length+8) & 0xff0000) >> 16, out);
  fputc(((2*data_length+8) & 0xff00) >> 8, out);
  fputc(((2*data_length+8) & 0xff), out);

  // Offset
  fputc(0,out);
  fputc(0,out);
  fputc(0,out);
  fputc(0,out);

  // Block
  fputc(0,out);
  fputc(0,out);
  fputc(0,out);
  fputc(0,out);

  /* Find the range */
  minimum = samples[0];
  maximum = minimum;
  for (i=1; i<data_length; i++)
  {
    if (samples[i] > maximum)
      maximum = samples[i];
    if (samples[i] < minimum)
      minimum = samples[i];
  }

  if (minimum >= maximum)
  {
    minimum -= 1;
    maximum += 1;
  }

  middle = (minimum + maximum) / 2;
  minimum -= middle;
  maximum -= middle;
  if (abs(minimum) > abs(maximum))
    maximum = abs(minimum);
  scale = 32760 / (maximum);

  printf("scale:%lf\n", scale);

  /* Write the data */
  for (i=0;i<data_length;i++) {
    v = (unsigned short)(scale * (samples[i] - middle));
    fputc((v & 0xff00) >> 8,out);
    fputc((v & 0x00ff),out);
  }

  fclose(out);

  return 0;
}

