// This file is part of fityk program. Copyright (C) Marcin Wojdyr
// $Id: wx_IO.cpp,v 1.27 2006/08/08 23:19:29 wojdyr Exp $


// wxwindows headers, see wxwindows samples for description
#include <wx/wxprec.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

#include "common.h"
#include "ui.h"
#include "wx_plot.h"
#include "wx_gui.h"
#include "wx_pane.h"
#include "logic.h"
#include "cmd.h"

using namespace std;

void UserInterface::showMessage (OutputStyle style, const string& s)
{
    frame->output_text(style, s + "\n");
}

void UserInterface::doDrawPlot(bool now)
{
        frame->refresh_plots(true, now);
}

void UserInterface::wait (float seconds) 
{  
    wxMilliSleep(iround(seconds*1e3)); 
}

Commands::Status UserInterface::execCommand(const string& s)
{
    //FIXME should I limit number of displayed lines?
    //const int max_lines_in_output_win = 1000;
    //don't output plot command - it is generated by every zoom in/out etc.
    bool output = strncmp(s.c_str(), "plot", 4) != 0;
    if (output)
        frame->output_text(os_input, "=-> " + s + "\n");
    else
        frame->set_status_text(s);
    wxBusyCursor wait;
    Commands::Status r;
    try {
        r = parse_and_execute(s);
    }
    catch(ExitRequestedException) {
        frame->Close(true);
    }
    frame->after_cmd_updates();
    return r;
}


