// This file is part of fityk program. Copyright (C) Marcin Wojdyr

// wxwindows headers, see wxwindows samples for description
#include <wx/wxprec.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

#include "common.h"
RCSID ("$Id: wx_IO.cpp,v 1.8 2004/06/30 10:06:11 wojdyr Exp $")

#include "ui.h"
#include "wx_plot.h"
#include "wx_gui.h"
#include "wx_pane.h"
#include "other.h"

using namespace std;

void UserInterface::showMessage (OutputStyle style, const string& s)
{
    frame->output_text(style, s + "\n");
}

void UserInterface::doDrawPlot(bool now, const std::vector<fp>& a)
{
        if (now || AL->was_changed())
            clear_buffered_sum();
        params4plot = a;
        frame->refresh_plots(now);
}


void UserInterface::wait (float seconds) 
{  
    wxUsleep (static_cast<int>(seconds*1e3)); //wxUsleep takes mili-seconds
}

void UserInterface::execCommand(const string& s)
{
    //FIXME should I limit number of displayed lines?
    //const int max_lines_in_output_win = 1000;
    string prompted_s = "=-> " + s;
    //don't output o.plot command - it is generated by every zoom in/out etc.
    bool output = strncmp(s.c_str(), "o.plot", 6) != 0;
    if (output)
        frame->output_text(os_input, prompted_s + "\n");
    else
        frame->SetStatusText(s.c_str());
    wxBusyCursor wait;
    bool r = parser(s);
    if (!r)
        close();
}

void UserInterface::close()
{
        frame->Close(true);
}

