/*
 * Miscellaneous string-handling related utility-functions
 * Programmed and designed by Matti 'ccr' Hamalainen
 * (C) Copyright 2002-2003 Tecnic Software productions (TNSP)
 *
 * Please read file 'COPYING' for information on license and distribution.
 */
#ifndef TH_UTIL_H
#define TH_UTIL_H

#if ((!defined(FALSE)) && (!defined(TRUE)) && (!defined(BOOL)))
typedef enum { FALSE=0, TRUE=1 } BOOL;
#endif

#ifndef BOOL
#ifdef bool
#define BOOL bool
#else
#define BOOL int
#endif
#endif

/*
 * Macros
 */
#define th_isalnum(c)	(isalnum((int)(unsigned char) c)||(c=='')||(c=='')||(c=='')||(c=='')||(c=='')||(c==''))
#define th_isalpha(c)	(isalpha((int)(unsigned char) c)||(c=='')||(c=='')||(c=='')||(c=='')||(c=='')||(c==''))
#define th_isascii(c)	isascii((int)(unsigned char) c)
#define th_isblank(c)	isblank((int)(unsigned char) c)
#define th_iscntrl(c)	iscntrl((int)(unsigned char) c)
#define th_isdigit(c)	isdigit((int)(unsigned char) c)
#define th_isgraph(c)	isgraph((int)(unsigned char) c)
#define th_islower(c)	(islower((int)(unsigned char) c)||(c=='')||(c=='')||(c==''))
#define th_isprint(c)	isprint((int)(unsigned char) c)
#define th_ispunct(c)	ispunct((int)(unsigned char) c)
#define th_isspace(c)	isspace((int)(unsigned char) c)
#define th_isupper(c)	(isupper((int)(unsigned char) c)||(c=='')||(c=='')||(c==''))
#define th_isxdigit(c)	isxdigit((int)(unsigned char) c)

#define th_tolower(c)	tolower((int)(unsigned char) c)
#define th_toupper(c)	toupper((int)(unsigned char) c)

#define th_isspecial(q)	(((q >= 0x5b) && (q <= 0x60)) || ((q >= 0x7b) && (q <= 0x7d)))

/*
 * Functions
 */
int th_strcalloc(char **, const char *);
int th_strcat(char **, const char *);
int th_strcpy(char **, const char *);
char *th_strdup(const char *);

void th_findnext(char *, int *);
void th_findsep(char *, int *, char);
void th_findseporspace(char *, int *, char);

BOOL th_strmatch(char *, char *);
BOOL th_strcasematch(char *, char *);

#endif /* TH_UTIL_H */
