/*
 * Test suite for th_str*match() functions
 */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "th_util.h"

typedef struct {
	char *testStr;
	BOOL testResult;
} t_test;

char	*testStr1 = "foo.foo.bar..bar.baz";

t_test testList1[] = {
	{ "*.baz",	TRUE },
	{ "*b*.BAZ",	TRUE },
	{ "*b*.baz",	TRUE },
	{ "*A*",	TRUE },
	{ "f*",		TRUE },
	{ "f*z",	TRUE },
	{ "*",		TRUE },
	{ "?*",		TRUE },
	{ "*?",		TRUE },
	{ "*a?",	TRUE },
	{ "*z?",	FALSE },
	{ "*az",	TRUE },
	{ "*ar?",	FALSE },
	{ "*bar*",	TRUE },
	{ "*b?r*",	TRUE },
	{ "*.baz*",	TRUE },
	{ "*foo*foo*bar*", TRUE },
	{ "*foo*bar.baz", TRUE },
	{ "f*z*", 	TRUE },
	{ "*z*", 	TRUE },
	{ "?*z",	TRUE },
};
const int ntestList1 = (sizeof(testList1) / sizeof(t_test));

t_test testList2[] = {
	{ "*.baz",	TRUE },
	{ "*b*.BAZ",	FALSE },
	{ "*b*.baz",	TRUE },
	{ "*Ar*",	FALSE },
};
const int ntestList2 = (sizeof(testList2) / sizeof(t_test));


int nTest = 0, nFailed = 0, nPassed = 0;

void TST(char *str, char *pattern, BOOL testResult)
{
 BOOL iResult = th_strcasematch(str, pattern);

 printf("-------------------------\n");
 printf("TEST #%i: [\"%s\" -- \"%s\"], RESULT: %s\n",
 	nTest++,
 	str,
 	pattern,
	(testResult == iResult) ? "PASSED" : "FAILED"
	);

 if (iResult == testResult)
 	nPassed++;
 	else
 	nFailed++;
}


void doTestList(t_test testList[], int ntestList, char *testStr)
{
 int i;
 BOOL iResult;

 for (i = 0; i < ntestList; i++)
	{
	printf("-------------------------\n");
	printf("TEST #%i: [\"%s\" -- \"%s\"]\n",
		nTest,
	 	testStr,
	 	testList[i].testStr);


	iResult = th_strcasematch(testStr, testList[i].testStr);

	printf("TEST #%i RESULT: %s\n",
		nTest++,
		(testList[i].testResult == iResult) ? "PASSED" : "FAILED"
		);

	if (testList[i].testResult == iResult)
		nPassed++;
		else
		nFailed++;
	}
}


int main(void)
{
 doTestList(testList1, ntestList1, testStr1);

 TST("cras",	"*cras*",	TRUE);
 TST("cras",	"*cras",	TRUE);
 TST("cras",	"cras*",	TRUE);
 TST("cras",	"cras",		TRUE);
 TST(" cras",	"cras",		FALSE);
 TST("cras",	" cras",	FALSE);
 TST(" cras",	" cras ",	FALSE);
 TST(" cras ",	" cras",	FALSE);

 TST("cras_",	"*cras*",	TRUE);
 TST("cra",	"*cras*",	FALSE);
 TST("cras",	"cra*",		TRUE);
 TST("cras",	"*r*",		TRUE);
 TST("cras",	"*ra*",		TRUE);
 TST("cras",	"c*s",		TRUE);
 TST("cras",	"c*a",		FALSE);
 TST("cras",	"*a?",		TRUE);
 TST("cras",	"*r?*",		TRUE);
 TST("cras",	"*r??*",	TRUE);
 TST("cras",	"**",		TRUE);
 TST("cras",	"*_*",		FALSE);
 TST("cras_",	"*_*",		TRUE);
 TST("cras_",	"*_",		TRUE);
 
 printf("Tests passed: %i, failed: %i\n", nPassed, nFailed);

 return (nFailed > 0) ? -1 : 0;
}
