/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * fische-3.1
 * Copyright (C) Marcel Ebmer 2009 <marcel@26elf.at>
 * 
 * fische-3.1 is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * fische-3.1 is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef ANALYST_H
#define ANALYST_H
#include <vector>

class RingBuffer;
class Configuration;

class Analyst
{
	public:
		Analyst(RingBuffer*, Configuration*);
		~Analyst();
		int analyse();
		double bpm()
		{
			return __bpm;
		};
		
	private:
		enum {WAITING, MAYBEWAITING, BEAT};
		RingBuffer* __ringbuffer;
		Configuration* __config;
		double __dB, __ma30, __ma3, __sd, __bima, __bisd;
		int __slices;
		int __state;
		int32_t __frame;
		int32_t __lastbeat;
		double __bpm;
		std::vector<int32_t> __beathistory;
		double level(int16_t*);
		double guessBpm();
};

#endif // ANALYST_H
