/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * fische-3.0
 * Copyright (C) Marcel Ebmer 2009 <marcel@26elf.at>
 * 
 * fische-3.0 is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * fische-3.0 is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef WAVEPAINTER_H
#define WAVEPAINTER_H

class SdlScreen;
class VectorField;
class RingBuffer;

class WavePainter
{
	public:
		WavePainter(SdlScreen*, VectorField*, RingBuffer*);
		~WavePainter();
		void change();
		void paint();
		void changeColor();
		void changeShape();

	private:
		void line(int, int, int, int, uint32_t);
		int xCenter, yCenter;
		int height;
		int width;
		int x0, y0;
		SdlScreen* sdlscreen;
		RingBuffer* ringbuffer;
		int shape;
		int shapes;
		uint32_t color1;
		uint32_t color2;
};

int iround(double);

#endif // WAVEPAINTER_H
