/* -------------------------------------------------------------

   FireFlier KDE dock icon

   (C) 2002 Martin Maurer and Peter Maurer
   License: GPL

   this file is based on KTeaTime (Mathias Hoelzer Kluepfel)

 ------------------------------------------------------------- */


#include <stdlib.h>

#include <qcheckbox.h>
#include <qdialog.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qmenudata.h>
#include <qpainter.h>
#include <qpopupmenu.h>
#include <qpushbutton.h>
#include <qtooltip.h>
#include <qfile.h>
#include <qthread.h>
#include <iostream>
#include <qcursor.h>

#include <kconfig.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kmessagebox.h>
//#include <knotifyclient.h>
#include <kwin.h>
#include <knuminput.h>
#include <kseparator.h>

#include "traywidget.h"
#include <kdialogbase.h>

#include "UT_running.xpm"
#include "UT_not_running.xpm"


traywidget::traywidget()
    : KSystemTray()
{
  setBackgroundMode(X11ParentRelative);
  QString n;
  unsigned int num;

  menu = new QPopupMenu();
  menu->setCheckable(true);

  menu->insertItem(SmallIcon("1rightarrow"), i18n("&Hide/Show"), this, SLOT(start()));
  menu->insertSeparator();
  menu->insertItem(SmallIcon("exit"), i18n("Quit"), kapp, SLOT(quit()));

  UT_runningPixmap = new QPixmap(UT_running);
  UT_not_runningPixmap = new QPixmap(UT_not_running);

  setToolTip(i18n("FireFlier Client"));
  start();
}


void toggleMainWidget()
{
	if (kapp)
	{
		QWidget *wdg=kapp->mainWidget();
		if (wdg)
		{
			if (wdg->isHidden())
                wdg->show();
			else
                wdg->hide();
		}
	}
}

traywidget::~traywidget()
{
    delete menu;
    delete(UT_runningPixmap);
    delete(UT_not_runningPixmap);
}

void traywidget::setPacketPending(bool b)
{
	pending=b;
    repaint();
}

void traywidget::mousePressEvent(QMouseEvent *event)
{
  if (event->button() == 1)
  {
      toggleMainWidget();
  }
  else
    menu->popup(QCursor::pos());
}


void traywidget::paintEvent(QPaintEvent *)
{
  QPixmap *pm;

  if (pending)
    pm = UT_runningPixmap;
  else
      pm=UT_not_runningPixmap;

  QPainter p(this);
  int x = 1 + (12 - pm->width()/2);
  int y = 1 + (12 - pm->height()/2);
  p.drawPixmap(x , y, *pm);
  p.end();
}


void traywidget::start()
{
    toggleMainWidget();
}

void traywidget::setToolTip(const QString &text)
{
    if (lasttip == text)
        return;
    lasttip = text;
    QToolTip::remove(this);
    QToolTip::add(this, text);
}
