/* -------------------------------------------
     This file was created with csUtility.java 

    Unicode mapping table generated from java mapping and UnicodeData.txt

#
#    Name:     Cp869 to Unicode table
#    Unicode version: Java 1.3
#
#    Format: Three tab-separated columns
#        Column #1 is the Cp869 code (in hex)
#        Column #2 is the Unicode (in hex as 0xXXXX)
#        Column #3 is the Unicode name (follows a comment sign, '#')
#
#    The entries are in Cp869 order
#
0x00	0x0000	#NULL
0x01	0x0001	#START OF HEADING
0x02	0x0002	#START OF TEXT
0x03	0x0003	#END OF TEXT
0x04	0x0004	#END OF TRANSMISSION
0x05	0x0005	#ENQUIRY
0x06	0x0006	#ACKNOWLEDGE
0x07	0x0007	#BELL
0x08	0x0008	#BACKSPACE
0x09	0x0009	#CHARACTER TABULATION
0x0a	0x000a	#LINE FEED (LF)
0x0b	0x000b	#LINE TABULATION
0x0c	0x000c	#FORM FEED (FF)
0x0d	0x000d	#CARRIAGE RETURN (CR)
0x0e	0x000e	#SHIFT OUT
0x0f	0x000f	#SHIFT IN
0x10	0x0010	#DATA LINK ESCAPE
0x11	0x0011	#DEVICE CONTROL ONE
0x12	0x0012	#DEVICE CONTROL TWO
0x13	0x0013	#DEVICE CONTROL THREE
0x14	0x0014	#DEVICE CONTROL FOUR
0x15	0x0015	#NEGATIVE ACKNOWLEDGE
0x16	0x0016	#SYNCHRONOUS IDLE
0x17	0x0017	#END OF TRANSMISSION BLOCK
0x18	0x0018	#CANCEL
0x19	0x0019	#END OF MEDIUM
0x1a	0x001a	#SUBSTITUTE
0x1b	0x001b	#ESCAPE
0x1c	0x001c	#INFORMATION SEPARATOR FOUR
0x1d	0x001d	#INFORMATION SEPARATOR THREE
0x1e	0x001e	#INFORMATION SEPARATOR TWO
0x1f	0x001f	#INFORMATION SEPARATOR ONE
0x20	0x0020	#SPACE
0x21	0x0021	#EXCLAMATION MARK
0x22	0x0022	#QUOTATION MARK
0x23	0x0023	#NUMBER SIGN
0x24	0x0024	#DOLLAR SIGN
0x25	0x0025	#PERCENT SIGN
0x26	0x0026	#AMPERSAND
0x27	0x0027	#APOSTROPHE
0x28	0x0028	#LEFT PARENTHESIS
0x29	0x0029	#RIGHT PARENTHESIS
0x2a	0x002a	#ASTERISK
0x2b	0x002b	#PLUS SIGN
0x2c	0x002c	#COMMA
0x2d	0x002d	#HYPHEN-MINUS
0x2e	0x002e	#FULL STOP
0x2f	0x002f	#SOLIDUS
0x30	0x0030	#DIGIT ZERO
0x31	0x0031	#DIGIT ONE
0x32	0x0032	#DIGIT TWO
0x33	0x0033	#DIGIT THREE
0x34	0x0034	#DIGIT FOUR
0x35	0x0035	#DIGIT FIVE
0x36	0x0036	#DIGIT SIX
0x37	0x0037	#DIGIT SEVEN
0x38	0x0038	#DIGIT EIGHT
0x39	0x0039	#DIGIT NINE
0x3a	0x003a	#COLON
0x3b	0x003b	#SEMICOLON
0x3c	0x003c	#LESS-THAN SIGN
0x3d	0x003d	#EQUALS SIGN
0x3e	0x003e	#GREATER-THAN SIGN
0x3f	0x003f	#QUESTION MARK
0x40	0x0040	#COMMERCIAL AT
0x41	0x0041	#LATIN CAPITAL LETTER A
0x42	0x0042	#LATIN CAPITAL LETTER B
0x43	0x0043	#LATIN CAPITAL LETTER C
0x44	0x0044	#LATIN CAPITAL LETTER D
0x45	0x0045	#LATIN CAPITAL LETTER E
0x46	0x0046	#LATIN CAPITAL LETTER F
0x47	0x0047	#LATIN CAPITAL LETTER G
0x48	0x0048	#LATIN CAPITAL LETTER H
0x49	0x0049	#LATIN CAPITAL LETTER I
0x4a	0x004a	#LATIN CAPITAL LETTER J
0x4b	0x004b	#LATIN CAPITAL LETTER K
0x4c	0x004c	#LATIN CAPITAL LETTER L
0x4d	0x004d	#LATIN CAPITAL LETTER M
0x4e	0x004e	#LATIN CAPITAL LETTER N
0x4f	0x004f	#LATIN CAPITAL LETTER O
0x50	0x0050	#LATIN CAPITAL LETTER P
0x51	0x0051	#LATIN CAPITAL LETTER Q
0x52	0x0052	#LATIN CAPITAL LETTER R
0x53	0x0053	#LATIN CAPITAL LETTER S
0x54	0x0054	#LATIN CAPITAL LETTER T
0x55	0x0055	#LATIN CAPITAL LETTER U
0x56	0x0056	#LATIN CAPITAL LETTER V
0x57	0x0057	#LATIN CAPITAL LETTER W
0x58	0x0058	#LATIN CAPITAL LETTER X
0x59	0x0059	#LATIN CAPITAL LETTER Y
0x5a	0x005a	#LATIN CAPITAL LETTER Z
0x5b	0x005b	#LEFT SQUARE BRACKET
0x5c	0x005c	#REVERSE SOLIDUS
0x5d	0x005d	#RIGHT SQUARE BRACKET
0x5e	0x005e	#CIRCUMFLEX ACCENT
0x5f	0x005f	#LOW LINE
0x60	0x0060	#GRAVE ACCENT
0x61	0x0061	#LATIN SMALL LETTER A
0x62	0x0062	#LATIN SMALL LETTER B
0x63	0x0063	#LATIN SMALL LETTER C
0x64	0x0064	#LATIN SMALL LETTER D
0x65	0x0065	#LATIN SMALL LETTER E
0x66	0x0066	#LATIN SMALL LETTER F
0x67	0x0067	#LATIN SMALL LETTER G
0x68	0x0068	#LATIN SMALL LETTER H
0x69	0x0069	#LATIN SMALL LETTER I
0x6a	0x006a	#LATIN SMALL LETTER J
0x6b	0x006b	#LATIN SMALL LETTER K
0x6c	0x006c	#LATIN SMALL LETTER L
0x6d	0x006d	#LATIN SMALL LETTER M
0x6e	0x006e	#LATIN SMALL LETTER N
0x6f	0x006f	#LATIN SMALL LETTER O
0x70	0x0070	#LATIN SMALL LETTER P
0x71	0x0071	#LATIN SMALL LETTER Q
0x72	0x0072	#LATIN SMALL LETTER R
0x73	0x0073	#LATIN SMALL LETTER S
0x74	0x0074	#LATIN SMALL LETTER T
0x75	0x0075	#LATIN SMALL LETTER U
0x76	0x0076	#LATIN SMALL LETTER V
0x77	0x0077	#LATIN SMALL LETTER W
0x78	0x0078	#LATIN SMALL LETTER X
0x79	0x0079	#LATIN SMALL LETTER Y
0x7a	0x007a	#LATIN SMALL LETTER Z
0x7b	0x007b	#LEFT CURLY BRACKET
0x7c	0x007c	#VERTICAL LINE
0x7d	0x007d	#RIGHT CURLY BRACKET
0x7e	0x007e	#TILDE
0x7f	0x007f	#DELETE
0x80	     	#UNDEFINED
0x81	     	#UNDEFINED
0x82	     	#UNDEFINED
0x83	     	#UNDEFINED
0x84	     	#UNDEFINED
0x85	     	#UNDEFINED
0x86	0x0386	#GREEK CAPITAL LETTER ALPHA WITH TONOS
0x87	     	#UNDEFINED
0x88	0x00b7	#MIDDLE DOT
0x89	0x00ac	#NOT SIGN
0x8a	0x00a6	#BROKEN BAR
0x8b	0x2018	#LEFT SINGLE QUOTATION MARK
0x8c	0x2019	#RIGHT SINGLE QUOTATION MARK
0x8d	0x0388	#GREEK CAPITAL LETTER EPSILON WITH TONOS
0x8e	0x2015	#HORIZONTAL BAR
0x8f	0x0389	#GREEK CAPITAL LETTER ETA WITH TONOS
0x90	0x038a	#GREEK CAPITAL LETTER IOTA WITH TONOS
0x91	0x03aa	#GREEK CAPITAL LETTER IOTA WITH DIALYTIKA
0x92	0x038c	#GREEK CAPITAL LETTER OMICRON WITH TONOS
0x93	     	#UNDEFINED
0x94	     	#UNDEFINED
0x95	0x038e	#GREEK CAPITAL LETTER UPSILON WITH TONOS
0x96	0x03ab	#GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA
0x97	0x00a9	#COPYRIGHT SIGN
0x98	0x038f	#GREEK CAPITAL LETTER OMEGA WITH TONOS
0x99	0x00b2	#SUPERSCRIPT TWO
0x9a	0x00b3	#SUPERSCRIPT THREE
0x9b	0x03ac	#GREEK SMALL LETTER ALPHA WITH TONOS
0x9c	0x00a3	#POUND SIGN
0x9d	0x03ad	#GREEK SMALL LETTER EPSILON WITH TONOS
0x9e	0x03ae	#GREEK SMALL LETTER ETA WITH TONOS
0x9f	0x03af	#GREEK SMALL LETTER IOTA WITH TONOS
0xa0	0x03ca	#GREEK SMALL LETTER IOTA WITH DIALYTIKA
0xa1	0x0390	#GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS
0xa2	0x03cc	#GREEK SMALL LETTER OMICRON WITH TONOS
0xa3	0x03cd	#GREEK SMALL LETTER UPSILON WITH TONOS
0xa4	0x0391	#GREEK CAPITAL LETTER ALPHA
0xa5	0x0392	#GREEK CAPITAL LETTER BETA
0xa6	0x0393	#GREEK CAPITAL LETTER GAMMA
0xa7	0x0394	#GREEK CAPITAL LETTER DELTA
0xa8	0x0395	#GREEK CAPITAL LETTER EPSILON
0xa9	0x0396	#GREEK CAPITAL LETTER ZETA
0xaa	0x0397	#GREEK CAPITAL LETTER ETA
0xab	0x00bd	#VULGAR FRACTION ONE HALF
0xac	0x0398	#GREEK CAPITAL LETTER THETA
0xad	0x0399	#GREEK CAPITAL LETTER IOTA
0xae	0x00ab	#LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
0xaf	0x00bb	#RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
0xb0	0x2591	#LIGHT SHADE
0xb1	0x2592	#MEDIUM SHADE
0xb2	0x2593	#DARK SHADE
0xb3	0x2502	#BOX DRAWINGS LIGHT VERTICAL
0xb4	0x2524	#BOX DRAWINGS LIGHT VERTICAL AND LEFT
0xb5	0x039a	#GREEK CAPITAL LETTER KAPPA
0xb6	0x039b	#GREEK CAPITAL LETTER LAMDA
0xb7	0x039c	#GREEK CAPITAL LETTER MU
0xb8	0x039d	#GREEK CAPITAL LETTER NU
0xb9	0x2563	#BOX DRAWINGS DOUBLE VERTICAL AND LEFT
0xba	0x2551	#BOX DRAWINGS DOUBLE VERTICAL
0xbb	0x2557	#BOX DRAWINGS DOUBLE DOWN AND LEFT
0xbc	0x255d	#BOX DRAWINGS DOUBLE UP AND LEFT
0xbd	0x039e	#GREEK CAPITAL LETTER XI
0xbe	0x039f	#GREEK CAPITAL LETTER OMICRON
0xbf	0x2510	#BOX DRAWINGS LIGHT DOWN AND LEFT
0xc0	0x2514	#BOX DRAWINGS LIGHT UP AND RIGHT
0xc1	0x2534	#BOX DRAWINGS LIGHT UP AND HORIZONTAL
0xc2	0x252c	#BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
0xc3	0x251c	#BOX DRAWINGS LIGHT VERTICAL AND RIGHT
0xc4	0x2500	#BOX DRAWINGS LIGHT HORIZONTAL
0xc5	0x253c	#BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
0xc6	0x03a0	#GREEK CAPITAL LETTER PI
0xc7	0x03a1	#GREEK CAPITAL LETTER RHO
0xc8	0x255a	#BOX DRAWINGS DOUBLE UP AND RIGHT
0xc9	0x2554	#BOX DRAWINGS DOUBLE DOWN AND RIGHT
0xca	0x2569	#BOX DRAWINGS DOUBLE UP AND HORIZONTAL
0xcb	0x2566	#BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL
0xcc	0x2560	#BOX DRAWINGS DOUBLE VERTICAL AND RIGHT
0xcd	0x2550	#BOX DRAWINGS DOUBLE HORIZONTAL
0xce	0x256c	#BOX DRAWINGS DOUBLE VERTICAL AND HORIZONTAL
0xcf	0x03a3	#GREEK CAPITAL LETTER SIGMA
0xd0	0x03a4	#GREEK CAPITAL LETTER TAU
0xd1	0x03a5	#GREEK CAPITAL LETTER UPSILON
0xd2	0x03a6	#GREEK CAPITAL LETTER PHI
0xd3	0x03a7	#GREEK CAPITAL LETTER CHI
0xd4	0x03a8	#GREEK CAPITAL LETTER PSI
0xd5	0x03a9	#GREEK CAPITAL LETTER OMEGA
0xd6	0x03b1	#GREEK SMALL LETTER ALPHA
0xd7	0x03b2	#GREEK SMALL LETTER BETA
0xd8	0x03b3	#GREEK SMALL LETTER GAMMA
0xd9	0x2518	#BOX DRAWINGS LIGHT UP AND LEFT
0xda	0x250c	#BOX DRAWINGS LIGHT DOWN AND RIGHT
0xdb	0x2588	#FULL BLOCK
0xdc	0x2584	#LOWER HALF BLOCK
0xdd	0x03b4	#GREEK SMALL LETTER DELTA
0xde	0x03b5	#GREEK SMALL LETTER EPSILON
0xdf	0x2580	#UPPER HALF BLOCK
0xe0	0x03b6	#GREEK SMALL LETTER ZETA
0xe1	0x03b7	#GREEK SMALL LETTER ETA
0xe2	0x03b8	#GREEK SMALL LETTER THETA
0xe3	0x03b9	#GREEK SMALL LETTER IOTA
0xe4	0x03ba	#GREEK SMALL LETTER KAPPA
0xe5	0x03bb	#GREEK SMALL LETTER LAMDA
0xe6	0x03bc	#GREEK SMALL LETTER MU
0xe7	0x03bd	#GREEK SMALL LETTER NU
0xe8	0x03be	#GREEK SMALL LETTER XI
0xe9	0x03bf	#GREEK SMALL LETTER OMICRON
0xea	0x03c0	#GREEK SMALL LETTER PI
0xeb	0x03c1	#GREEK SMALL LETTER RHO
0xec	0x03c3	#GREEK SMALL LETTER SIGMA
0xed	0x03c2	#GREEK SMALL LETTER FINAL SIGMA
0xee	0x03c4	#GREEK SMALL LETTER TAU
0xef	0x0384	#GREEK TONOS
0xf0	0x00ad	#SOFT HYPHEN
0xf1	0x00b1	#PLUS-MINUS SIGN
0xf2	0x03c5	#GREEK SMALL LETTER UPSILON
0xf3	0x03c6	#GREEK SMALL LETTER PHI
0xf4	0x03c7	#GREEK SMALL LETTER CHI
0xf5	0x00a7	#SECTION SIGN
0xf6	0x03c8	#GREEK SMALL LETTER PSI
0xf7	0x0385	#GREEK DIALYTIKA TONOS
0xf8	0x00b0	#DEGREE SIGN
0xf9	0x00a8	#DIAERESIS
0xfa	0x03c9	#GREEK SMALL LETTER OMEGA
0xfb	0x03cb	#GREEK SMALL LETTER UPSILON WITH DIALYTIKA
0xfc	0x03b0	#GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS
0xfd	0x03ce	#GREEK SMALL LETTER OMEGA WITH TONOS
0xfe	0x25a0	#BLACK SQUARE
0xff	0x00a0	#NO-BREAK SPACE


 * The contents of this file are subject to the Interbase Public
 * License Version 1.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy
 * of the License at http://www.Inprise.com/IPL.html
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code was created by Inprise Corporation
 * and its predecessors. Portions created by Inprise Corporation are
 * Copyright (C) Inprise Corporation.
 *
 * All Rights Reserved.
 * Contributor(s): Blas Rodriguez Somoza.
   -------------------------------------------- */
static const int CANT_MAP_CHARACTER = 0;

static const USHORT to_unicode_map[256] = {
/* 00 */  0x0000 /*                                          NULL */,
/* 01 */  0x0001 /*                              START OF HEADING */,
/* 02 */  0x0002 /*                                 START OF TEXT */,
/* 03 */  0x0003 /*                                   END OF TEXT */,
/* 04 */  0x0004 /*                           END OF TRANSMISSION */,
/* 05 */  0x0005 /*                                       ENQUIRY */,
/* 06 */  0x0006 /*                                   ACKNOWLEDGE */,
/* 07 */  0x0007 /*                                          BELL */,
/* 08 */  0x0008 /*                                     BACKSPACE */,
/* 09 */  0x0009 /*                          CHARACTER TABULATION */,
/* 0A */  0x000A /*                                LINE FEED (LF) */,
/* 0B */  0x000B /*                               LINE TABULATION */,
/* 0C */  0x000C /*                                FORM FEED (FF) */,
/* 0D */  0x000D /*                          CARRIAGE RETURN (CR) */,
/* 0E */  0x000E /*                                     SHIFT OUT */,
/* 0F */  0x000F /*                                      SHIFT IN */,
/* 10 */  0x0010 /*                              DATA LINK ESCAPE */,
/* 11 */  0x0011 /*                            DEVICE CONTROL ONE */,
/* 12 */  0x0012 /*                            DEVICE CONTROL TWO */,
/* 13 */  0x0013 /*                          DEVICE CONTROL THREE */,
/* 14 */  0x0014 /*                           DEVICE CONTROL FOUR */,
/* 15 */  0x0015 /*                          NEGATIVE ACKNOWLEDGE */,
/* 16 */  0x0016 /*                              SYNCHRONOUS IDLE */,
/* 17 */  0x0017 /*                     END OF TRANSMISSION BLOCK */,
/* 18 */  0x0018 /*                                        CANCEL */,
/* 19 */  0x0019 /*                                 END OF MEDIUM */,
/* 1A */  0x001A /*                                    SUBSTITUTE */,
/* 1B */  0x001B /*                                        ESCAPE */,
/* 1C */  0x001C /*                    INFORMATION SEPARATOR FOUR */,
/* 1D */  0x001D /*                   INFORMATION SEPARATOR THREE */,
/* 1E */  0x001E /*                     INFORMATION SEPARATOR TWO */,
/* 1F */  0x001F /*                     INFORMATION SEPARATOR ONE */,
/* 20 */  0x0020 /*                                         SPACE */,
/* 21 */  0x0021 /*                              EXCLAMATION MARK */,
/* 22 */  0x0022 /*                                QUOTATION MARK */,
/* 23 */  0x0023 /*                                   NUMBER SIGN */,
/* 24 */  0x0024 /*                                   DOLLAR SIGN */,
/* 25 */  0x0025 /*                                  PERCENT SIGN */,
/* 26 */  0x0026 /*                                     AMPERSAND */,
/* 27 */  0x0027 /*                                    APOSTROPHE */,
/* 28 */  0x0028 /*                              LEFT PARENTHESIS */,
/* 29 */  0x0029 /*                             RIGHT PARENTHESIS */,
/* 2A */  0x002A /*                                      ASTERISK */,
/* 2B */  0x002B /*                                     PLUS SIGN */,
/* 2C */  0x002C /*                                         COMMA */,
/* 2D */  0x002D /*                                  HYPHEN-MINUS */,
/* 2E */  0x002E /*                                     FULL STOP */,
/* 2F */  0x002F /*                                       SOLIDUS */,
/* 30 */  0x0030 /*                                    DIGIT ZERO */,
/* 31 */  0x0031 /*                                     DIGIT ONE */,
/* 32 */  0x0032 /*                                     DIGIT TWO */,
/* 33 */  0x0033 /*                                   DIGIT THREE */,
/* 34 */  0x0034 /*                                    DIGIT FOUR */,
/* 35 */  0x0035 /*                                    DIGIT FIVE */,
/* 36 */  0x0036 /*                                     DIGIT SIX */,
/* 37 */  0x0037 /*                                   DIGIT SEVEN */,
/* 38 */  0x0038 /*                                   DIGIT EIGHT */,
/* 39 */  0x0039 /*                                    DIGIT NINE */,
/* 3A */  0x003A /*                                         COLON */,
/* 3B */  0x003B /*                                     SEMICOLON */,
/* 3C */  0x003C /*                                LESS-THAN SIGN */,
/* 3D */  0x003D /*                                   EQUALS SIGN */,
/* 3E */  0x003E /*                             GREATER-THAN SIGN */,
/* 3F */  0x003F /*                                 QUESTION MARK */,
/* 40 */  0x0040 /*                                 COMMERCIAL AT */,
/* 41 */  0x0041 /*                        LATIN CAPITAL LETTER A */,
/* 42 */  0x0042 /*                        LATIN CAPITAL LETTER B */,
/* 43 */  0x0043 /*                        LATIN CAPITAL LETTER C */,
/* 44 */  0x0044 /*                        LATIN CAPITAL LETTER D */,
/* 45 */  0x0045 /*                        LATIN CAPITAL LETTER E */,
/* 46 */  0x0046 /*                        LATIN CAPITAL LETTER F */,
/* 47 */  0x0047 /*                        LATIN CAPITAL LETTER G */,
/* 48 */  0x0048 /*                        LATIN CAPITAL LETTER H */,
/* 49 */  0x0049 /*                        LATIN CAPITAL LETTER I */,
/* 4A */  0x004A /*                        LATIN CAPITAL LETTER J */,
/* 4B */  0x004B /*                        LATIN CAPITAL LETTER K */,
/* 4C */  0x004C /*                        LATIN CAPITAL LETTER L */,
/* 4D */  0x004D /*                        LATIN CAPITAL LETTER M */,
/* 4E */  0x004E /*                        LATIN CAPITAL LETTER N */,
/* 4F */  0x004F /*                        LATIN CAPITAL LETTER O */,
/* 50 */  0x0050 /*                        LATIN CAPITAL LETTER P */,
/* 51 */  0x0051 /*                        LATIN CAPITAL LETTER Q */,
/* 52 */  0x0052 /*                        LATIN CAPITAL LETTER R */,
/* 53 */  0x0053 /*                        LATIN CAPITAL LETTER S */,
/* 54 */  0x0054 /*                        LATIN CAPITAL LETTER T */,
/* 55 */  0x0055 /*                        LATIN CAPITAL LETTER U */,
/* 56 */  0x0056 /*                        LATIN CAPITAL LETTER V */,
/* 57 */  0x0057 /*                        LATIN CAPITAL LETTER W */,
/* 58 */  0x0058 /*                        LATIN CAPITAL LETTER X */,
/* 59 */  0x0059 /*                        LATIN CAPITAL LETTER Y */,
/* 5A */  0x005A /*                        LATIN CAPITAL LETTER Z */,
/* 5B */  0x005B /*                           LEFT SQUARE BRACKET */,
/* 5C */  0x005C /*                               REVERSE SOLIDUS */,
/* 5D */  0x005D /*                          RIGHT SQUARE BRACKET */,
/* 5E */  0x005E /*                             CIRCUMFLEX ACCENT */,
/* 5F */  0x005F /*                                      LOW LINE */,
/* 60 */  0x0060 /*                                  GRAVE ACCENT */,
/* 61 */  0x0061 /*                          LATIN SMALL LETTER A */,
/* 62 */  0x0062 /*                          LATIN SMALL LETTER B */,
/* 63 */  0x0063 /*                          LATIN SMALL LETTER C */,
/* 64 */  0x0064 /*                          LATIN SMALL LETTER D */,
/* 65 */  0x0065 /*                          LATIN SMALL LETTER E */,
/* 66 */  0x0066 /*                          LATIN SMALL LETTER F */,
/* 67 */  0x0067 /*                          LATIN SMALL LETTER G */,
/* 68 */  0x0068 /*                          LATIN SMALL LETTER H */,
/* 69 */  0x0069 /*                          LATIN SMALL LETTER I */,
/* 6A */  0x006A /*                          LATIN SMALL LETTER J */,
/* 6B */  0x006B /*                          LATIN SMALL LETTER K */,
/* 6C */  0x006C /*                          LATIN SMALL LETTER L */,
/* 6D */  0x006D /*                          LATIN SMALL LETTER M */,
/* 6E */  0x006E /*                          LATIN SMALL LETTER N */,
/* 6F */  0x006F /*                          LATIN SMALL LETTER O */,
/* 70 */  0x0070 /*                          LATIN SMALL LETTER P */,
/* 71 */  0x0071 /*                          LATIN SMALL LETTER Q */,
/* 72 */  0x0072 /*                          LATIN SMALL LETTER R */,
/* 73 */  0x0073 /*                          LATIN SMALL LETTER S */,
/* 74 */  0x0074 /*                          LATIN SMALL LETTER T */,
/* 75 */  0x0075 /*                          LATIN SMALL LETTER U */,
/* 76 */  0x0076 /*                          LATIN SMALL LETTER V */,
/* 77 */  0x0077 /*                          LATIN SMALL LETTER W */,
/* 78 */  0x0078 /*                          LATIN SMALL LETTER X */,
/* 79 */  0x0079 /*                          LATIN SMALL LETTER Y */,
/* 7A */  0x007A /*                          LATIN SMALL LETTER Z */,
/* 7B */  0x007B /*                            LEFT CURLY BRACKET */,
/* 7C */  0x007C /*                                 VERTICAL LINE */,
/* 7D */  0x007D /*                           RIGHT CURLY BRACKET */,
/* 7E */  0x007E /*                                         TILDE */,
/* 7F */  0x007F /*                                        DELETE */,
/* 80 */     CANT_MAP_CHARACTER   ,
/* 81 */     CANT_MAP_CHARACTER   ,
/* 82 */     CANT_MAP_CHARACTER   ,
/* 83 */     CANT_MAP_CHARACTER   ,
/* 84 */     CANT_MAP_CHARACTER   ,
/* 85 */     CANT_MAP_CHARACTER   ,
/* 86 */  0x0386 /*         GREEK CAPITAL LETTER ALPHA WITH TONOS */,
/* 87 */     CANT_MAP_CHARACTER   ,
/* 88 */  0x00B7 /*                                    MIDDLE DOT */,
/* 89 */  0x00AC /*                                      NOT SIGN */,
/* 8A */  0x00A6 /*                                    BROKEN BAR */,
/* 8B */  0x2018 /*                    LEFT SINGLE QUOTATION MARK */,
/* 8C */  0x2019 /*                   RIGHT SINGLE QUOTATION MARK */,
/* 8D */  0x0388 /*       GREEK CAPITAL LETTER EPSILON WITH TONOS */,
/* 8E */  0x2015 /*                                HORIZONTAL BAR */,
/* 8F */  0x0389 /*           GREEK CAPITAL LETTER ETA WITH TONOS */,
/* 90 */  0x038A /*          GREEK CAPITAL LETTER IOTA WITH TONOS */,
/* 91 */  0x03AA /*      GREEK CAPITAL LETTER IOTA WITH DIALYTIKA */,
/* 92 */  0x038C /*       GREEK CAPITAL LETTER OMICRON WITH TONOS */,
/* 93 */     CANT_MAP_CHARACTER   ,
/* 94 */     CANT_MAP_CHARACTER   ,
/* 95 */  0x038E /*       GREEK CAPITAL LETTER UPSILON WITH TONOS */,
/* 96 */  0x03AB /*   GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA */,
/* 97 */  0x00A9 /*                                COPYRIGHT SIGN */,
/* 98 */  0x038F /*         GREEK CAPITAL LETTER OMEGA WITH TONOS */,
/* 99 */  0x00B2 /*                               SUPERSCRIPT TWO */,
/* 9A */  0x00B3 /*                             SUPERSCRIPT THREE */,
/* 9B */  0x03AC /*           GREEK SMALL LETTER ALPHA WITH TONOS */,
/* 9C */  0x00A3 /*                                    POUND SIGN */,
/* 9D */  0x03AD /*         GREEK SMALL LETTER EPSILON WITH TONOS */,
/* 9E */  0x03AE /*             GREEK SMALL LETTER ETA WITH TONOS */,
/* 9F */  0x03AF /*            GREEK SMALL LETTER IOTA WITH TONOS */,
/* A0 */  0x03CA /*        GREEK SMALL LETTER IOTA WITH DIALYTIKA */,
/* A1 */  0x0390 /* GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS */,
/* A2 */  0x03CC /*         GREEK SMALL LETTER OMICRON WITH TONOS */,
/* A3 */  0x03CD /*         GREEK SMALL LETTER UPSILON WITH TONOS */,
/* A4 */  0x0391 /*                    GREEK CAPITAL LETTER ALPHA */,
/* A5 */  0x0392 /*                     GREEK CAPITAL LETTER BETA */,
/* A6 */  0x0393 /*                    GREEK CAPITAL LETTER GAMMA */,
/* A7 */  0x0394 /*                    GREEK CAPITAL LETTER DELTA */,
/* A8 */  0x0395 /*                  GREEK CAPITAL LETTER EPSILON */,
/* A9 */  0x0396 /*                     GREEK CAPITAL LETTER ZETA */,
/* AA */  0x0397 /*                      GREEK CAPITAL LETTER ETA */,
/* AB */  0x00BD /*                      VULGAR FRACTION ONE HALF */,
/* AC */  0x0398 /*                    GREEK CAPITAL LETTER THETA */,
/* AD */  0x0399 /*                     GREEK CAPITAL LETTER IOTA */,
/* AE */  0x00AB /*     LEFT-POINTING DOUBLE ANGLE QUOTATION MARK */,
/* AF */  0x00BB /*    RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK */,
/* B0 */  0x2591 /*                                   LIGHT SHADE */,
/* B1 */  0x2592 /*                                  MEDIUM SHADE */,
/* B2 */  0x2593 /*                                    DARK SHADE */,
/* B3 */  0x2502 /*                   BOX DRAWINGS LIGHT VERTICAL */,
/* B4 */  0x2524 /*          BOX DRAWINGS LIGHT VERTICAL AND LEFT */,
/* B5 */  0x039A /*                    GREEK CAPITAL LETTER KAPPA */,
/* B6 */  0x039B /*                    GREEK CAPITAL LETTER LAMDA */,
/* B7 */  0x039C /*                       GREEK CAPITAL LETTER MU */,
/* B8 */  0x039D /*                       GREEK CAPITAL LETTER NU */,
/* B9 */  0x2563 /*         BOX DRAWINGS DOUBLE VERTICAL AND LEFT */,
/* BA */  0x2551 /*                  BOX DRAWINGS DOUBLE VERTICAL */,
/* BB */  0x2557 /*             BOX DRAWINGS DOUBLE DOWN AND LEFT */,
/* BC */  0x255D /*               BOX DRAWINGS DOUBLE UP AND LEFT */,
/* BD */  0x039E /*                       GREEK CAPITAL LETTER XI */,
/* BE */  0x039F /*                  GREEK CAPITAL LETTER OMICRON */,
/* BF */  0x2510 /*              BOX DRAWINGS LIGHT DOWN AND LEFT */,
/* C0 */  0x2514 /*               BOX DRAWINGS LIGHT UP AND RIGHT */,
/* C1 */  0x2534 /*          BOX DRAWINGS LIGHT UP AND HORIZONTAL */,
/* C2 */  0x252C /*        BOX DRAWINGS LIGHT DOWN AND HORIZONTAL */,
/* C3 */  0x251C /*         BOX DRAWINGS LIGHT VERTICAL AND RIGHT */,
/* C4 */  0x2500 /*                 BOX DRAWINGS LIGHT HORIZONTAL */,
/* C5 */  0x253C /*    BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL */,
/* C6 */  0x03A0 /*                       GREEK CAPITAL LETTER PI */,
/* C7 */  0x03A1 /*                      GREEK CAPITAL LETTER RHO */,
/* C8 */  0x255A /*              BOX DRAWINGS DOUBLE UP AND RIGHT */,
/* C9 */  0x2554 /*            BOX DRAWINGS DOUBLE DOWN AND RIGHT */,
/* CA */  0x2569 /*         BOX DRAWINGS DOUBLE UP AND HORIZONTAL */,
/* CB */  0x2566 /*       BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL */,
/* CC */  0x2560 /*        BOX DRAWINGS DOUBLE VERTICAL AND RIGHT */,
/* CD */  0x2550 /*                BOX DRAWINGS DOUBLE HORIZONTAL */,
/* CE */  0x256C /*   BOX DRAWINGS DOUBLE VERTICAL AND HORIZONTAL */,
/* CF */  0x03A3 /*                    GREEK CAPITAL LETTER SIGMA */,
/* D0 */  0x03A4 /*                      GREEK CAPITAL LETTER TAU */,
/* D1 */  0x03A5 /*                  GREEK CAPITAL LETTER UPSILON */,
/* D2 */  0x03A6 /*                      GREEK CAPITAL LETTER PHI */,
/* D3 */  0x03A7 /*                      GREEK CAPITAL LETTER CHI */,
/* D4 */  0x03A8 /*                      GREEK CAPITAL LETTER PSI */,
/* D5 */  0x03A9 /*                    GREEK CAPITAL LETTER OMEGA */,
/* D6 */  0x03B1 /*                      GREEK SMALL LETTER ALPHA */,
/* D7 */  0x03B2 /*                       GREEK SMALL LETTER BETA */,
/* D8 */  0x03B3 /*                      GREEK SMALL LETTER GAMMA */,
/* D9 */  0x2518 /*                BOX DRAWINGS LIGHT UP AND LEFT */,
/* DA */  0x250C /*             BOX DRAWINGS LIGHT DOWN AND RIGHT */,
/* DB */  0x2588 /*                                    FULL BLOCK */,
/* DC */  0x2584 /*                              LOWER HALF BLOCK */,
/* DD */  0x03B4 /*                      GREEK SMALL LETTER DELTA */,
/* DE */  0x03B5 /*                    GREEK SMALL LETTER EPSILON */,
/* DF */  0x2580 /*                              UPPER HALF BLOCK */,
/* E0 */  0x03B6 /*                       GREEK SMALL LETTER ZETA */,
/* E1 */  0x03B7 /*                        GREEK SMALL LETTER ETA */,
/* E2 */  0x03B8 /*                      GREEK SMALL LETTER THETA */,
/* E3 */  0x03B9 /*                       GREEK SMALL LETTER IOTA */,
/* E4 */  0x03BA /*                      GREEK SMALL LETTER KAPPA */,
/* E5 */  0x03BB /*                      GREEK SMALL LETTER LAMDA */,
/* E6 */  0x03BC /*                         GREEK SMALL LETTER MU */,
/* E7 */  0x03BD /*                         GREEK SMALL LETTER NU */,
/* E8 */  0x03BE /*                         GREEK SMALL LETTER XI */,
/* E9 */  0x03BF /*                    GREEK SMALL LETTER OMICRON */,
/* EA */  0x03C0 /*                         GREEK SMALL LETTER PI */,
/* EB */  0x03C1 /*                        GREEK SMALL LETTER RHO */,
/* EC */  0x03C3 /*                      GREEK SMALL LETTER SIGMA */,
/* ED */  0x03C2 /*                GREEK SMALL LETTER FINAL SIGMA */,
/* EE */  0x03C4 /*                        GREEK SMALL LETTER TAU */,
/* EF */  0x0384 /*                                   GREEK TONOS */,
/* F0 */  0x00AD /*                                   SOFT HYPHEN */,
/* F1 */  0x00B1 /*                               PLUS-MINUS SIGN */,
/* F2 */  0x03C5 /*                    GREEK SMALL LETTER UPSILON */,
/* F3 */  0x03C6 /*                        GREEK SMALL LETTER PHI */,
/* F4 */  0x03C7 /*                        GREEK SMALL LETTER CHI */,
/* F5 */  0x00A7 /*                                  SECTION SIGN */,
/* F6 */  0x03C8 /*                        GREEK SMALL LETTER PSI */,
/* F7 */  0x0385 /*                         GREEK DIALYTIKA TONOS */,
/* F8 */  0x00B0 /*                                   DEGREE SIGN */,
/* F9 */  0x00A8 /*                                     DIAERESIS */,
/* FA */  0x03C9 /*                      GREEK SMALL LETTER OMEGA */,
/* FB */  0x03CB /*     GREEK SMALL LETTER UPSILON WITH DIALYTIKA */,
/* FC */  0x03B0 /* GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS */,
/* FD */  0x03CE /*           GREEK SMALL LETTER OMEGA WITH TONOS */,
/* FE */  0x25A0 /*                                  BLACK SQUARE */,
/* FF */  0x00A0 /*                                NO-BREAK SPACE */,
};


static const UCHAR from_unicode_mapping_array[] = {
/* U+XX00 */	CANT_MAP_CHARACTER,	/* 0 */
/* U+XX01 */	CANT_MAP_CHARACTER,	/* 1 */
/* U+XX02 */	CANT_MAP_CHARACTER,	/* 2 */
/* U+XX03 */	CANT_MAP_CHARACTER,	/* 3 */
/* U+XX04 */	CANT_MAP_CHARACTER,	/* 4 */
/* U+XX05 */	CANT_MAP_CHARACTER,	/* 5 */
/* U+XX06 */	CANT_MAP_CHARACTER,	/* 6 */
/* U+XX07 */	CANT_MAP_CHARACTER,	/* 7 */
/* U+XX08 */	CANT_MAP_CHARACTER,	/* 8 */
/* U+XX09 */	CANT_MAP_CHARACTER,	/* 9 */
/* U+XX0A */	CANT_MAP_CHARACTER,	/* 10 */
/* U+XX0B */	CANT_MAP_CHARACTER,	/* 11 */
/* U+XX0C */	CANT_MAP_CHARACTER,	/* 12 */
/* U+XX0D */	CANT_MAP_CHARACTER,	/* 13 */
/* U+XX0E */	CANT_MAP_CHARACTER,	/* 14 */
/* U+XX0F */	CANT_MAP_CHARACTER,	/* 15 */
/* U+XX10 */	CANT_MAP_CHARACTER,	/* 16 */
/* U+XX11 */	CANT_MAP_CHARACTER,	/* 17 */
/* U+XX12 */	CANT_MAP_CHARACTER,	/* 18 */
/* U+XX13 */	CANT_MAP_CHARACTER,	/* 19 */
/* U+XX14 */	CANT_MAP_CHARACTER,	/* 20 */
/* U+XX15 */	CANT_MAP_CHARACTER,	/* 21 */
/* U+XX16 */	CANT_MAP_CHARACTER,	/* 22 */
/* U+XX17 */	CANT_MAP_CHARACTER,	/* 23 */
/* U+XX18 */	CANT_MAP_CHARACTER,	/* 24 */
/* U+XX19 */	CANT_MAP_CHARACTER,	/* 25 */
/* U+XX1A */	CANT_MAP_CHARACTER,	/* 26 */
/* U+XX1B */	CANT_MAP_CHARACTER,	/* 27 */
/* U+XX1C */	CANT_MAP_CHARACTER,	/* 28 */
/* U+XX1D */	CANT_MAP_CHARACTER,	/* 29 */
/* U+XX1E */	CANT_MAP_CHARACTER,	/* 30 */
/* U+XX1F */	CANT_MAP_CHARACTER,	/* 31 */
/* U+XX20 */	CANT_MAP_CHARACTER,	/* 32 */
/* U+XX21 */	CANT_MAP_CHARACTER,	/* 33 */
/* U+XX22 */	CANT_MAP_CHARACTER,	/* 34 */
/* U+XX23 */	CANT_MAP_CHARACTER,	/* 35 */
/* U+XX24 */	CANT_MAP_CHARACTER,	/* 36 */
/* U+XX25 */	CANT_MAP_CHARACTER,	/* 37 */
/* U+XX26 */	CANT_MAP_CHARACTER,	/* 38 */
/* U+XX27 */	CANT_MAP_CHARACTER,	/* 39 */
/* U+XX28 */	CANT_MAP_CHARACTER,	/* 40 */
/* U+XX29 */	CANT_MAP_CHARACTER,	/* 41 */
/* U+XX2A */	CANT_MAP_CHARACTER,	/* 42 */
/* U+XX2B */	CANT_MAP_CHARACTER,	/* 43 */
/* U+XX2C */	CANT_MAP_CHARACTER,	/* 44 */
/* U+XX2D */	CANT_MAP_CHARACTER,	/* 45 */
/* U+XX2E */	CANT_MAP_CHARACTER,	/* 46 */
/* U+XX2F */	CANT_MAP_CHARACTER,	/* 47 */
/* U+XX30 */	CANT_MAP_CHARACTER,	/* 48 */
/* U+XX31 */	CANT_MAP_CHARACTER,	/* 49 */
/* U+XX32 */	CANT_MAP_CHARACTER,	/* 50 */
/* U+XX33 */	CANT_MAP_CHARACTER,	/* 51 */
/* U+XX34 */	CANT_MAP_CHARACTER,	/* 52 */
/* U+XX35 */	CANT_MAP_CHARACTER,	/* 53 */
/* U+XX36 */	CANT_MAP_CHARACTER,	/* 54 */
/* U+XX37 */	CANT_MAP_CHARACTER,	/* 55 */
/* U+XX38 */	CANT_MAP_CHARACTER,	/* 56 */
/* U+XX39 */	CANT_MAP_CHARACTER,	/* 57 */
/* U+XX3A */	CANT_MAP_CHARACTER,	/* 58 */
/* U+XX3B */	CANT_MAP_CHARACTER,	/* 59 */
/* U+XX3C */	CANT_MAP_CHARACTER,	/* 60 */
/* U+XX3D */	CANT_MAP_CHARACTER,	/* 61 */
/* U+XX3E */	CANT_MAP_CHARACTER,	/* 62 */
/* U+XX3F */	CANT_MAP_CHARACTER,	/* 63 */
/* U+XX40 */	CANT_MAP_CHARACTER,	/* 64 */
/* U+XX41 */	CANT_MAP_CHARACTER,	/* 65 */
/* U+XX42 */	CANT_MAP_CHARACTER,	/* 66 */
/* U+XX43 */	CANT_MAP_CHARACTER,	/* 67 */
/* U+XX44 */	CANT_MAP_CHARACTER,	/* 68 */
/* U+XX45 */	CANT_MAP_CHARACTER,	/* 69 */
/* U+XX46 */	CANT_MAP_CHARACTER,	/* 70 */
/* U+XX47 */	CANT_MAP_CHARACTER,	/* 71 */
/* U+XX48 */	CANT_MAP_CHARACTER,	/* 72 */
/* U+XX49 */	CANT_MAP_CHARACTER,	/* 73 */
/* U+XX4A */	CANT_MAP_CHARACTER,	/* 74 */
/* U+XX4B */	CANT_MAP_CHARACTER,	/* 75 */
/* U+XX4C */	CANT_MAP_CHARACTER,	/* 76 */
/* U+XX4D */	CANT_MAP_CHARACTER,	/* 77 */
/* U+XX4E */	CANT_MAP_CHARACTER,	/* 78 */
/* U+XX4F */	CANT_MAP_CHARACTER,	/* 79 */
/* U+XX50 */	CANT_MAP_CHARACTER,	/* 80 */
/* U+XX51 */	CANT_MAP_CHARACTER,	/* 81 */
/* U+XX52 */	CANT_MAP_CHARACTER,	/* 82 */
/* U+XX53 */	CANT_MAP_CHARACTER,	/* 83 */
/* U+XX54 */	CANT_MAP_CHARACTER,	/* 84 */
/* U+XX55 */	CANT_MAP_CHARACTER,	/* 85 */
/* U+XX56 */	CANT_MAP_CHARACTER,	/* 86 */
/* U+XX57 */	CANT_MAP_CHARACTER,	/* 87 */
/* U+XX58 */	CANT_MAP_CHARACTER,	/* 88 */
/* U+XX59 */	CANT_MAP_CHARACTER,	/* 89 */
/* U+XX5A */	CANT_MAP_CHARACTER,	/* 90 */
/* U+XX5B */	CANT_MAP_CHARACTER,	/* 91 */
/* U+XX5C */	CANT_MAP_CHARACTER,	/* 92 */
/* U+XX5D */	CANT_MAP_CHARACTER,	/* 93 */
/* U+XX5E */	CANT_MAP_CHARACTER,	/* 94 */
/* U+XX5F */	CANT_MAP_CHARACTER,	/* 95 */
/* U+XX60 */	CANT_MAP_CHARACTER,	/* 96 */
/* U+XX61 */	CANT_MAP_CHARACTER,	/* 97 */
/* U+XX62 */	CANT_MAP_CHARACTER,	/* 98 */
/* U+XX63 */	CANT_MAP_CHARACTER,	/* 99 */
/* U+XX64 */	CANT_MAP_CHARACTER,	/* 100 */
/* U+XX65 */	CANT_MAP_CHARACTER,	/* 101 */
/* U+XX66 */	CANT_MAP_CHARACTER,	/* 102 */
/* U+XX67 */	CANT_MAP_CHARACTER,	/* 103 */
/* U+XX68 */	CANT_MAP_CHARACTER,	/* 104 */
/* U+XX69 */	CANT_MAP_CHARACTER,	/* 105 */
/* U+XX6A */	CANT_MAP_CHARACTER,	/* 106 */
/* U+XX6B */	CANT_MAP_CHARACTER,	/* 107 */
/* U+XX6C */	CANT_MAP_CHARACTER,	/* 108 */
/* U+XX6D */	CANT_MAP_CHARACTER,	/* 109 */
/* U+XX6E */	CANT_MAP_CHARACTER,	/* 110 */
/* U+XX6F */	CANT_MAP_CHARACTER,	/* 111 */
/* U+XX70 */	CANT_MAP_CHARACTER,	/* 112 */
/* U+XX71 */	CANT_MAP_CHARACTER,	/* 113 */
/* U+XX72 */	CANT_MAP_CHARACTER,	/* 114 */
/* U+XX73 */	CANT_MAP_CHARACTER,	/* 115 */
/* U+XX74 */	CANT_MAP_CHARACTER,	/* 116 */
/* U+XX75 */	CANT_MAP_CHARACTER,	/* 117 */
/* U+XX76 */	CANT_MAP_CHARACTER,	/* 118 */
/* U+XX77 */	CANT_MAP_CHARACTER,	/* 119 */
/* U+XX78 */	CANT_MAP_CHARACTER,	/* 120 */
/* U+XX79 */	CANT_MAP_CHARACTER,	/* 121 */
/* U+XX7A */	CANT_MAP_CHARACTER,	/* 122 */
/* U+XX7B */	CANT_MAP_CHARACTER,	/* 123 */
/* U+XX7C */	CANT_MAP_CHARACTER,	/* 124 */
/* U+XX7D */	CANT_MAP_CHARACTER,	/* 125 */
/* U+XX7E */	CANT_MAP_CHARACTER,	/* 126 */
/* U+XX7F */	CANT_MAP_CHARACTER,	/* 127 */
/* U+XX80 */	CANT_MAP_CHARACTER,	/* 128 */
/* U+XX81 */	CANT_MAP_CHARACTER,	/* 129 */
/* U+XX82 */	CANT_MAP_CHARACTER,	/* 130 */
/* U+XX83 */	CANT_MAP_CHARACTER,	/* 131 */
/* U+XX84 */	CANT_MAP_CHARACTER,	/* 132 */
/* U+XX85 */	CANT_MAP_CHARACTER,	/* 133 */
/* U+XX86 */	CANT_MAP_CHARACTER,	/* 134 */
/* U+XX87 */	CANT_MAP_CHARACTER,	/* 135 */
/* U+XX88 */	CANT_MAP_CHARACTER,	/* 136 */
/* U+XX89 */	CANT_MAP_CHARACTER,	/* 137 */
/* U+XX8A */	CANT_MAP_CHARACTER,	/* 138 */
/* U+XX8B */	CANT_MAP_CHARACTER,	/* 139 */
/* U+XX8C */	CANT_MAP_CHARACTER,	/* 140 */
/* U+XX8D */	CANT_MAP_CHARACTER,	/* 141 */
/* U+XX8E */	CANT_MAP_CHARACTER,	/* 142 */
/* U+XX8F */	CANT_MAP_CHARACTER,	/* 143 */
/* U+XX90 */	CANT_MAP_CHARACTER,	/* 144 */
/* U+XX91 */	CANT_MAP_CHARACTER,	/* 145 */
/* U+XX92 */	CANT_MAP_CHARACTER,	/* 146 */
/* U+XX93 */	CANT_MAP_CHARACTER,	/* 147 */
/* U+XX94 */	CANT_MAP_CHARACTER,	/* 148 */
/* U+XX95 */	CANT_MAP_CHARACTER,	/* 149 */
/* U+XX96 */	CANT_MAP_CHARACTER,	/* 150 */
/* U+XX97 */	CANT_MAP_CHARACTER,	/* 151 */
/* U+XX98 */	CANT_MAP_CHARACTER,	/* 152 */
/* U+XX99 */	CANT_MAP_CHARACTER,	/* 153 */
/* U+XX9A */	CANT_MAP_CHARACTER,	/* 154 */
/* U+XX9B */	CANT_MAP_CHARACTER,	/* 155 */
/* U+XX9C */	CANT_MAP_CHARACTER,	/* 156 */
/* U+XX9D */	CANT_MAP_CHARACTER,	/* 157 */
/* U+XX9E */	CANT_MAP_CHARACTER,	/* 158 */
/* U+XX9F */	CANT_MAP_CHARACTER,	/* 159 */
/* U+XXA0 */	CANT_MAP_CHARACTER,	/* 160 */
/* U+XXA1 */	CANT_MAP_CHARACTER,	/* 161 */
/* U+XXA2 */	CANT_MAP_CHARACTER,	/* 162 */
/* U+XXA3 */	CANT_MAP_CHARACTER,	/* 163 */
/* U+XXA4 */	CANT_MAP_CHARACTER,	/* 164 */
/* U+XXA5 */	CANT_MAP_CHARACTER,	/* 165 */
/* U+XXA6 */	CANT_MAP_CHARACTER,	/* 166 */
/* U+XXA7 */	CANT_MAP_CHARACTER,	/* 167 */
/* U+XXA8 */	CANT_MAP_CHARACTER,	/* 168 */
/* U+XXA9 */	CANT_MAP_CHARACTER,	/* 169 */
/* U+XXAA */	CANT_MAP_CHARACTER,	/* 170 */
/* U+XXAB */	CANT_MAP_CHARACTER,	/* 171 */
/* U+XXAC */	CANT_MAP_CHARACTER,	/* 172 */
/* U+XXAD */	CANT_MAP_CHARACTER,	/* 173 */
/* U+XXAE */	CANT_MAP_CHARACTER,	/* 174 */
/* U+XXAF */	CANT_MAP_CHARACTER,	/* 175 */
/* U+XXB0 */	CANT_MAP_CHARACTER,	/* 176 */
/* U+XXB1 */	CANT_MAP_CHARACTER,	/* 177 */
/* U+XXB2 */	CANT_MAP_CHARACTER,	/* 178 */
/* U+XXB3 */	CANT_MAP_CHARACTER,	/* 179 */
/* U+XXB4 */	CANT_MAP_CHARACTER,	/* 180 */
/* U+XXB5 */	CANT_MAP_CHARACTER,	/* 181 */
/* U+XXB6 */	CANT_MAP_CHARACTER,	/* 182 */
/* U+XXB7 */	CANT_MAP_CHARACTER,	/* 183 */
/* U+XXB8 */	CANT_MAP_CHARACTER,	/* 184 */
/* U+XXB9 */	CANT_MAP_CHARACTER,	/* 185 */
/* U+XXBA */	CANT_MAP_CHARACTER,	/* 186 */
/* U+XXBB */	CANT_MAP_CHARACTER,	/* 187 */
/* U+XXBC */	CANT_MAP_CHARACTER,	/* 188 */
/* U+XXBD */	CANT_MAP_CHARACTER,	/* 189 */
/* U+XXBE */	CANT_MAP_CHARACTER,	/* 190 */
/* U+XXBF */	CANT_MAP_CHARACTER,	/* 191 */
/* U+XXC0 */	CANT_MAP_CHARACTER,	/* 192 */
/* U+XXC1 */	CANT_MAP_CHARACTER,	/* 193 */
/* U+XXC2 */	CANT_MAP_CHARACTER,	/* 194 */
/* U+XXC3 */	CANT_MAP_CHARACTER,	/* 195 */
/* U+XXC4 */	CANT_MAP_CHARACTER,	/* 196 */
/* U+XXC5 */	CANT_MAP_CHARACTER,	/* 197 */
/* U+XXC6 */	CANT_MAP_CHARACTER,	/* 198 */
/* U+XXC7 */	CANT_MAP_CHARACTER,	/* 199 */
/* U+XXC8 */	CANT_MAP_CHARACTER,	/* 200 */
/* U+XXC9 */	CANT_MAP_CHARACTER,	/* 201 */
/* U+XXCA */	CANT_MAP_CHARACTER,	/* 202 */
/* U+XXCB */	CANT_MAP_CHARACTER,	/* 203 */
/* U+XXCC */	CANT_MAP_CHARACTER,	/* 204 */
/* U+XXCD */	CANT_MAP_CHARACTER,	/* 205 */
/* U+XXCE */	CANT_MAP_CHARACTER,	/* 206 */
/* U+XXCF */	CANT_MAP_CHARACTER,	/* 207 */
/* U+XXD0 */	CANT_MAP_CHARACTER,	/* 208 */
/* U+XXD1 */	CANT_MAP_CHARACTER,	/* 209 */
/* U+XXD2 */	CANT_MAP_CHARACTER,	/* 210 */
/* U+XXD3 */	CANT_MAP_CHARACTER,	/* 211 */
/* U+XXD4 */	CANT_MAP_CHARACTER,	/* 212 */
/* U+XXD5 */	CANT_MAP_CHARACTER,	/* 213 */
/* U+XXD6 */	CANT_MAP_CHARACTER,	/* 214 */
/* U+XXD7 */	CANT_MAP_CHARACTER,	/* 215 */
/* U+XXD8 */	CANT_MAP_CHARACTER,	/* 216 */
/* U+XXD9 */	CANT_MAP_CHARACTER,	/* 217 */
/* U+XXDA */	CANT_MAP_CHARACTER,	/* 218 */
/* U+XXDB */	CANT_MAP_CHARACTER,	/* 219 */
/* U+XXDC */	CANT_MAP_CHARACTER,	/* 220 */
/* U+XXDD */	CANT_MAP_CHARACTER,	/* 221 */
/* U+XXDE */	CANT_MAP_CHARACTER,	/* 222 */
/* U+XXDF */	CANT_MAP_CHARACTER,	/* 223 */
/* U+XXE0 */	CANT_MAP_CHARACTER,	/* 224 */
/* U+XXE1 */	CANT_MAP_CHARACTER,	/* 225 */
/* U+XXE2 */	CANT_MAP_CHARACTER,	/* 226 */
/* U+XXE3 */	CANT_MAP_CHARACTER,	/* 227 */
/* U+XXE4 */	CANT_MAP_CHARACTER,	/* 228 */
/* U+XXE5 */	CANT_MAP_CHARACTER,	/* 229 */
/* U+XXE6 */	CANT_MAP_CHARACTER,	/* 230 */
/* U+XXE7 */	CANT_MAP_CHARACTER,	/* 231 */
/* U+XXE8 */	CANT_MAP_CHARACTER,	/* 232 */
/* U+XXE9 */	CANT_MAP_CHARACTER,	/* 233 */
/* U+XXEA */	CANT_MAP_CHARACTER,	/* 234 */
/* U+XXEB */	CANT_MAP_CHARACTER,	/* 235 */
/* U+XXEC */	CANT_MAP_CHARACTER,	/* 236 */
/* U+XXED */	CANT_MAP_CHARACTER,	/* 237 */
/* U+XXEE */	CANT_MAP_CHARACTER,	/* 238 */
/* U+XXEF */	CANT_MAP_CHARACTER,	/* 239 */
/* U+XXF0 */	CANT_MAP_CHARACTER,	/* 240 */
/* U+XXF1 */	CANT_MAP_CHARACTER,	/* 241 */
/* U+XXF2 */	CANT_MAP_CHARACTER,	/* 242 */
/* U+XXF3 */	CANT_MAP_CHARACTER,	/* 243 */
/* U+XXF4 */	CANT_MAP_CHARACTER,	/* 244 */
/* U+XXF5 */	CANT_MAP_CHARACTER,	/* 245 */
/* U+XXF6 */	CANT_MAP_CHARACTER,	/* 246 */
/* U+XXF7 */	CANT_MAP_CHARACTER,	/* 247 */
/* U+XXF8 */	CANT_MAP_CHARACTER,	/* 248 */
/* U+XXF9 */	CANT_MAP_CHARACTER,	/* 249 */
/* U+XXFA */	CANT_MAP_CHARACTER,	/* 250 */
/* U+XXFB */	CANT_MAP_CHARACTER,	/* 251 */
/* U+XXFC */	CANT_MAP_CHARACTER,	/* 252 */
/* U+XXFD */	CANT_MAP_CHARACTER,	/* 253 */
/* U+XXFE */	CANT_MAP_CHARACTER,	/* 254 */
/* U+XXFF */	CANT_MAP_CHARACTER,	/* 255 */
/* U+0000 */	0x00	/*                                          NULL */,/* 256 */
/* U+0001 */	0x01	/*                              START OF HEADING */,/* 257 */
/* U+0002 */	0x02	/*                                 START OF TEXT */,/* 258 */
/* U+0003 */	0x03	/*                                   END OF TEXT */,/* 259 */
/* U+0004 */	0x04	/*                           END OF TRANSMISSION */,/* 260 */
/* U+0005 */	0x05	/*                                       ENQUIRY */,/* 261 */
/* U+0006 */	0x06	/*                                   ACKNOWLEDGE */,/* 262 */
/* U+0007 */	0x07	/*                                          BELL */,/* 263 */
/* U+0008 */	0x08	/*                                     BACKSPACE */,/* 264 */
/* U+0009 */	0x09	/*                          CHARACTER TABULATION */,/* 265 */
/* U+000A */	0x0A	/*                                LINE FEED (LF) */,/* 266 */
/* U+000B */	0x0B	/*                               LINE TABULATION */,/* 267 */
/* U+000C */	0x0C	/*                                FORM FEED (FF) */,/* 268 */
/* U+000D */	0x0D	/*                          CARRIAGE RETURN (CR) */,/* 269 */
/* U+000E */	0x0E	/*                                     SHIFT OUT */,/* 270 */
/* U+000F */	0x0F	/*                                      SHIFT IN */,/* 271 */
/* U+0010 */	0x10	/*                              DATA LINK ESCAPE */,/* 272 */
/* U+0011 */	0x11	/*                            DEVICE CONTROL ONE */,/* 273 */
/* U+0012 */	0x12	/*                            DEVICE CONTROL TWO */,/* 274 */
/* U+0013 */	0x13	/*                          DEVICE CONTROL THREE */,/* 275 */
/* U+0014 */	0x14	/*                           DEVICE CONTROL FOUR */,/* 276 */
/* U+0015 */	0x15	/*                          NEGATIVE ACKNOWLEDGE */,/* 277 */
/* U+0016 */	0x16	/*                              SYNCHRONOUS IDLE */,/* 278 */
/* U+0017 */	0x17	/*                     END OF TRANSMISSION BLOCK */,/* 279 */
/* U+0018 */	0x18	/*                                        CANCEL */,/* 280 */
/* U+0019 */	0x19	/*                                 END OF MEDIUM */,/* 281 */
/* U+001A */	0x1A	/*                                    SUBSTITUTE */,/* 282 */
/* U+001B */	0x1B	/*                                        ESCAPE */,/* 283 */
/* U+001C */	0x1C	/*                    INFORMATION SEPARATOR FOUR */,/* 284 */
/* U+001D */	0x1D	/*                   INFORMATION SEPARATOR THREE */,/* 285 */
/* U+001E */	0x1E	/*                     INFORMATION SEPARATOR TWO */,/* 286 */
/* U+001F */	0x1F	/*                     INFORMATION SEPARATOR ONE */,/* 287 */
/* U+0020 */	0x20	/*                                         SPACE */,/* 288 */
/* U+0021 */	0x21	/*                              EXCLAMATION MARK */,/* 289 */
/* U+0022 */	0x22	/*                                QUOTATION MARK */,/* 290 */
/* U+0023 */	0x23	/*                                   NUMBER SIGN */,/* 291 */
/* U+0024 */	0x24	/*                                   DOLLAR SIGN */,/* 292 */
/* U+0025 */	0x25	/*                                  PERCENT SIGN */,/* 293 */
/* U+0026 */	0x26	/*                                     AMPERSAND */,/* 294 */
/* U+0027 */	0x27	/*                                    APOSTROPHE */,/* 295 */
/* U+0028 */	0x28	/*                              LEFT PARENTHESIS */,/* 296 */
/* U+0029 */	0x29	/*                             RIGHT PARENTHESIS */,/* 297 */
/* U+002A */	0x2A	/*                                      ASTERISK */,/* 298 */
/* U+002B */	0x2B	/*                                     PLUS SIGN */,/* 299 */
/* U+002C */	0x2C	/*                                         COMMA */,/* 300 */
/* U+002D */	0x2D	/*                                  HYPHEN-MINUS */,/* 301 */
/* U+002E */	0x2E	/*                                     FULL STOP */,/* 302 */
/* U+002F */	0x2F	/*                                       SOLIDUS */,/* 303 */
/* U+0030 */	0x30	/*                                    DIGIT ZERO */,/* 304 */
/* U+0031 */	0x31	/*                                     DIGIT ONE */,/* 305 */
/* U+0032 */	0x32	/*                                     DIGIT TWO */,/* 306 */
/* U+0033 */	0x33	/*                                   DIGIT THREE */,/* 307 */
/* U+0034 */	0x34	/*                                    DIGIT FOUR */,/* 308 */
/* U+0035 */	0x35	/*                                    DIGIT FIVE */,/* 309 */
/* U+0036 */	0x36	/*                                     DIGIT SIX */,/* 310 */
/* U+0037 */	0x37	/*                                   DIGIT SEVEN */,/* 311 */
/* U+0038 */	0x38	/*                                   DIGIT EIGHT */,/* 312 */
/* U+0039 */	0x39	/*                                    DIGIT NINE */,/* 313 */
/* U+003A */	0x3A	/*                                         COLON */,/* 314 */
/* U+003B */	0x3B	/*                                     SEMICOLON */,/* 315 */
/* U+003C */	0x3C	/*                                LESS-THAN SIGN */,/* 316 */
/* U+003D */	0x3D	/*                                   EQUALS SIGN */,/* 317 */
/* U+003E */	0x3E	/*                             GREATER-THAN SIGN */,/* 318 */
/* U+003F */	0x3F	/*                                 QUESTION MARK */,/* 319 */
/* U+0040 */	0x40	/*                                 COMMERCIAL AT */,/* 320 */
/* U+0041 */	0x41	/*                        LATIN CAPITAL LETTER A */,/* 321 */
/* U+0042 */	0x42	/*                        LATIN CAPITAL LETTER B */,/* 322 */
/* U+0043 */	0x43	/*                        LATIN CAPITAL LETTER C */,/* 323 */
/* U+0044 */	0x44	/*                        LATIN CAPITAL LETTER D */,/* 324 */
/* U+0045 */	0x45	/*                        LATIN CAPITAL LETTER E */,/* 325 */
/* U+0046 */	0x46	/*                        LATIN CAPITAL LETTER F */,/* 326 */
/* U+0047 */	0x47	/*                        LATIN CAPITAL LETTER G */,/* 327 */
/* U+0048 */	0x48	/*                        LATIN CAPITAL LETTER H */,/* 328 */
/* U+0049 */	0x49	/*                        LATIN CAPITAL LETTER I */,/* 329 */
/* U+004A */	0x4A	/*                        LATIN CAPITAL LETTER J */,/* 330 */
/* U+004B */	0x4B	/*                        LATIN CAPITAL LETTER K */,/* 331 */
/* U+004C */	0x4C	/*                        LATIN CAPITAL LETTER L */,/* 332 */
/* U+004D */	0x4D	/*                        LATIN CAPITAL LETTER M */,/* 333 */
/* U+004E */	0x4E	/*                        LATIN CAPITAL LETTER N */,/* 334 */
/* U+004F */	0x4F	/*                        LATIN CAPITAL LETTER O */,/* 335 */
/* U+0050 */	0x50	/*                        LATIN CAPITAL LETTER P */,/* 336 */
/* U+0051 */	0x51	/*                        LATIN CAPITAL LETTER Q */,/* 337 */
/* U+0052 */	0x52	/*                        LATIN CAPITAL LETTER R */,/* 338 */
/* U+0053 */	0x53	/*                        LATIN CAPITAL LETTER S */,/* 339 */
/* U+0054 */	0x54	/*                        LATIN CAPITAL LETTER T */,/* 340 */
/* U+0055 */	0x55	/*                        LATIN CAPITAL LETTER U */,/* 341 */
/* U+0056 */	0x56	/*                        LATIN CAPITAL LETTER V */,/* 342 */
/* U+0057 */	0x57	/*                        LATIN CAPITAL LETTER W */,/* 343 */
/* U+0058 */	0x58	/*                        LATIN CAPITAL LETTER X */,/* 344 */
/* U+0059 */	0x59	/*                        LATIN CAPITAL LETTER Y */,/* 345 */
/* U+005A */	0x5A	/*                        LATIN CAPITAL LETTER Z */,/* 346 */
/* U+005B */	0x5B	/*                           LEFT SQUARE BRACKET */,/* 347 */
/* U+005C */	0x5C	/*                               REVERSE SOLIDUS */,/* 348 */
/* U+005D */	0x5D	/*                          RIGHT SQUARE BRACKET */,/* 349 */
/* U+005E */	0x5E	/*                             CIRCUMFLEX ACCENT */,/* 350 */
/* U+005F */	0x5F	/*                                      LOW LINE */,/* 351 */
/* U+0060 */	0x60	/*                                  GRAVE ACCENT */,/* 352 */
/* U+0061 */	0x61	/*                          LATIN SMALL LETTER A */,/* 353 */
/* U+0062 */	0x62	/*                          LATIN SMALL LETTER B */,/* 354 */
/* U+0063 */	0x63	/*                          LATIN SMALL LETTER C */,/* 355 */
/* U+0064 */	0x64	/*                          LATIN SMALL LETTER D */,/* 356 */
/* U+0065 */	0x65	/*                          LATIN SMALL LETTER E */,/* 357 */
/* U+0066 */	0x66	/*                          LATIN SMALL LETTER F */,/* 358 */
/* U+0067 */	0x67	/*                          LATIN SMALL LETTER G */,/* 359 */
/* U+0068 */	0x68	/*                          LATIN SMALL LETTER H */,/* 360 */
/* U+0069 */	0x69	/*                          LATIN SMALL LETTER I */,/* 361 */
/* U+006A */	0x6A	/*                          LATIN SMALL LETTER J */,/* 362 */
/* U+006B */	0x6B	/*                          LATIN SMALL LETTER K */,/* 363 */
/* U+006C */	0x6C	/*                          LATIN SMALL LETTER L */,/* 364 */
/* U+006D */	0x6D	/*                          LATIN SMALL LETTER M */,/* 365 */
/* U+006E */	0x6E	/*                          LATIN SMALL LETTER N */,/* 366 */
/* U+006F */	0x6F	/*                          LATIN SMALL LETTER O */,/* 367 */
/* U+0070 */	0x70	/*                          LATIN SMALL LETTER P */,/* 368 */
/* U+0071 */	0x71	/*                          LATIN SMALL LETTER Q */,/* 369 */
/* U+0072 */	0x72	/*                          LATIN SMALL LETTER R */,/* 370 */
/* U+0073 */	0x73	/*                          LATIN SMALL LETTER S */,/* 371 */
/* U+0074 */	0x74	/*                          LATIN SMALL LETTER T */,/* 372 */
/* U+0075 */	0x75	/*                          LATIN SMALL LETTER U */,/* 373 */
/* U+0076 */	0x76	/*                          LATIN SMALL LETTER V */,/* 374 */
/* U+0077 */	0x77	/*                          LATIN SMALL LETTER W */,/* 375 */
/* U+0078 */	0x78	/*                          LATIN SMALL LETTER X */,/* 376 */
/* U+0079 */	0x79	/*                          LATIN SMALL LETTER Y */,/* 377 */
/* U+007A */	0x7A	/*                          LATIN SMALL LETTER Z */,/* 378 */
/* U+007B */	0x7B	/*                            LEFT CURLY BRACKET */,/* 379 */
/* U+007C */	0x7C	/*                                 VERTICAL LINE */,/* 380 */
/* U+007D */	0x7D	/*                           RIGHT CURLY BRACKET */,/* 381 */
/* U+007E */	0x7E	/*                                         TILDE */,/* 382 */
/* U+007F */	0x7F	/*                                        DELETE */,/* 383 */
/* U+0080 */	CANT_MAP_CHARACTER,	/* 384 */
/* U+0081 */	CANT_MAP_CHARACTER,	/* 385 */
/* U+0082 */	CANT_MAP_CHARACTER,	/* 386 */
/* U+0083 */	CANT_MAP_CHARACTER,	/* 387 */
/* U+0084 */	CANT_MAP_CHARACTER,	/* 388 */
/* U+0085 */	CANT_MAP_CHARACTER,	/* 389 */
/* U+0086 */	CANT_MAP_CHARACTER,	/* 390 */
/* U+0087 */	CANT_MAP_CHARACTER,	/* 391 */
/* U+0088 */	CANT_MAP_CHARACTER,	/* 392 */
/* U+0089 */	CANT_MAP_CHARACTER,	/* 393 */
/* U+008A */	CANT_MAP_CHARACTER,	/* 394 */
/* U+008B */	CANT_MAP_CHARACTER,	/* 395 */
/* U+008C */	CANT_MAP_CHARACTER,	/* 396 */
/* U+008D */	CANT_MAP_CHARACTER,	/* 397 */
/* U+008E */	CANT_MAP_CHARACTER,	/* 398 */
/* U+008F */	CANT_MAP_CHARACTER,	/* 399 */
/* U+0090 */	CANT_MAP_CHARACTER,	/* 400 */
/* U+0091 */	CANT_MAP_CHARACTER,	/* 401 */
/* U+0092 */	CANT_MAP_CHARACTER,	/* 402 */
/* U+0093 */	CANT_MAP_CHARACTER,	/* 403 */
/* U+0094 */	CANT_MAP_CHARACTER,	/* 404 */
/* U+0095 */	CANT_MAP_CHARACTER,	/* 405 */
/* U+0096 */	CANT_MAP_CHARACTER,	/* 406 */
/* U+0097 */	CANT_MAP_CHARACTER,	/* 407 */
/* U+0098 */	CANT_MAP_CHARACTER,	/* 408 */
/* U+0099 */	CANT_MAP_CHARACTER,	/* 409 */
/* U+009A */	CANT_MAP_CHARACTER,	/* 410 */
/* U+009B */	CANT_MAP_CHARACTER,	/* 411 */
/* U+009C */	CANT_MAP_CHARACTER,	/* 412 */
/* U+009D */	CANT_MAP_CHARACTER,	/* 413 */
/* U+009E */	CANT_MAP_CHARACTER,	/* 414 */
/* U+009F */	CANT_MAP_CHARACTER,	/* 415 */
/* U+00A0 */	0xFF	/*                                NO-BREAK SPACE */,/* 416 */
/* U+00A1 */	CANT_MAP_CHARACTER,	/* 417 */
/* U+00A2 */	CANT_MAP_CHARACTER,	/* 418 */
/* U+00A3 */	0x9C	/*                                    POUND SIGN */,/* 419 */
/* U+00A4 */	CANT_MAP_CHARACTER,	/* 420 */
/* U+00A5 */	CANT_MAP_CHARACTER,	/* 421 */
/* U+00A6 */	0x8A	/*                                    BROKEN BAR */,/* 422 */
/* U+00A7 */	0xF5	/*                                  SECTION SIGN */,/* 423 */
/* U+00A8 */	0xF9	/*                                     DIAERESIS */,/* 424 */
/* U+00A9 */	0x97	/*                                COPYRIGHT SIGN */,/* 425 */
/* U+00AA */	CANT_MAP_CHARACTER,	/* 426 */
/* U+00AB */	0xAE	/*     LEFT-POINTING DOUBLE ANGLE QUOTATION MARK */,/* 427 */
/* U+00AC */	0x89	/*                                      NOT SIGN */,/* 428 */
/* U+00AD */	0xF0	/*                                   SOFT HYPHEN */,/* 429 */
/* U+00AE */	CANT_MAP_CHARACTER,	/* 430 */
/* U+00AF */	CANT_MAP_CHARACTER,	/* 431 */
/* U+00B0 */	0xF8	/*                                   DEGREE SIGN */,/* 432 */
/* U+00B1 */	0xF1	/*                               PLUS-MINUS SIGN */,/* 433 */
/* U+00B2 */	0x99	/*                               SUPERSCRIPT TWO */,/* 434 */
/* U+00B3 */	0x9A	/*                             SUPERSCRIPT THREE */,/* 435 */
/* U+00B4 */	CANT_MAP_CHARACTER,	/* 436 */
/* U+00B5 */	CANT_MAP_CHARACTER,	/* 437 */
/* U+00B6 */	CANT_MAP_CHARACTER,	/* 438 */
/* U+00B7 */	0x88	/*                                    MIDDLE DOT */,/* 439 */
/* U+00B8 */	CANT_MAP_CHARACTER,	/* 440 */
/* U+00B9 */	CANT_MAP_CHARACTER,	/* 441 */
/* U+00BA */	CANT_MAP_CHARACTER,	/* 442 */
/* U+00BB */	0xAF	/*    RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK */,/* 443 */
/* U+00BC */	CANT_MAP_CHARACTER,	/* 444 */
/* U+00BD */	0xAB	/*                      VULGAR FRACTION ONE HALF */,/* 445 */
/* U+00BE */	CANT_MAP_CHARACTER,	/* 446 */
/* U+00BF */	CANT_MAP_CHARACTER,	/* 447 */
/* U+00C0 */	CANT_MAP_CHARACTER,	/* 448 */
/* U+00C1 */	CANT_MAP_CHARACTER,	/* 449 */
/* U+00C2 */	CANT_MAP_CHARACTER,	/* 450 */
/* U+00C3 */	CANT_MAP_CHARACTER,	/* 451 */
/* U+00C4 */	CANT_MAP_CHARACTER,	/* 452 */
/* U+00C5 */	CANT_MAP_CHARACTER,	/* 453 */
/* U+00C6 */	CANT_MAP_CHARACTER,	/* 454 */
/* U+00C7 */	CANT_MAP_CHARACTER,	/* 455 */
/* U+00C8 */	CANT_MAP_CHARACTER,	/* 456 */
/* U+00C9 */	CANT_MAP_CHARACTER,	/* 457 */
/* U+00CA */	CANT_MAP_CHARACTER,	/* 458 */
/* U+00CB */	CANT_MAP_CHARACTER,	/* 459 */
/* U+00CC */	CANT_MAP_CHARACTER,	/* 460 */
/* U+00CD */	CANT_MAP_CHARACTER,	/* 461 */
/* U+00CE */	CANT_MAP_CHARACTER,	/* 462 */
/* U+00CF */	CANT_MAP_CHARACTER,	/* 463 */
/* U+00D0 */	CANT_MAP_CHARACTER,	/* 464 */
/* U+00D1 */	CANT_MAP_CHARACTER,	/* 465 */
/* U+00D2 */	CANT_MAP_CHARACTER,	/* 466 */
/* U+00D3 */	CANT_MAP_CHARACTER,	/* 467 */
/* U+00D4 */	CANT_MAP_CHARACTER,	/* 468 */
/* U+00D5 */	CANT_MAP_CHARACTER,	/* 469 */
/* U+00D6 */	CANT_MAP_CHARACTER,	/* 470 */
/* U+00D7 */	CANT_MAP_CHARACTER,	/* 471 */
/* U+00D8 */	CANT_MAP_CHARACTER,	/* 472 */
/* U+00D9 */	CANT_MAP_CHARACTER,	/* 473 */
/* U+00DA */	CANT_MAP_CHARACTER,	/* 474 */
/* U+00DB */	CANT_MAP_CHARACTER,	/* 475 */
/* U+00DC */	CANT_MAP_CHARACTER,	/* 476 */
/* U+00DD */	CANT_MAP_CHARACTER,	/* 477 */
/* U+00DE */	CANT_MAP_CHARACTER,	/* 478 */
/* U+00DF */	CANT_MAP_CHARACTER,	/* 479 */
/* U+00E0 */	CANT_MAP_CHARACTER,	/* 480 */
/* U+00E1 */	CANT_MAP_CHARACTER,	/* 481 */
/* U+00E2 */	CANT_MAP_CHARACTER,	/* 482 */
/* U+00E3 */	CANT_MAP_CHARACTER,	/* 483 */
/* U+00E4 */	CANT_MAP_CHARACTER,	/* 484 */
/* U+00E5 */	CANT_MAP_CHARACTER,	/* 485 */
/* U+00E6 */	CANT_MAP_CHARACTER,	/* 486 */
/* U+00E7 */	CANT_MAP_CHARACTER,	/* 487 */
/* U+00E8 */	CANT_MAP_CHARACTER,	/* 488 */
/* U+00E9 */	CANT_MAP_CHARACTER,	/* 489 */
/* U+00EA */	CANT_MAP_CHARACTER,	/* 490 */
/* U+00EB */	CANT_MAP_CHARACTER,	/* 491 */
/* U+00EC */	CANT_MAP_CHARACTER,	/* 492 */
/* U+00ED */	CANT_MAP_CHARACTER,	/* 493 */
/* U+00EE */	CANT_MAP_CHARACTER,	/* 494 */
/* U+00EF */	CANT_MAP_CHARACTER,	/* 495 */
/* U+00F0 */	CANT_MAP_CHARACTER,	/* 496 */
/* U+00F1 */	CANT_MAP_CHARACTER,	/* 497 */
/* U+00F2 */	CANT_MAP_CHARACTER,	/* 498 */
/* U+00F3 */	CANT_MAP_CHARACTER,	/* 499 */
/* U+00F4 */	CANT_MAP_CHARACTER,	/* 500 */
/* U+00F5 */	CANT_MAP_CHARACTER,	/* 501 */
/* U+00F6 */	CANT_MAP_CHARACTER,	/* 502 */
/* U+00F7 */	CANT_MAP_CHARACTER,	/* 503 */
/* U+00F8 */	CANT_MAP_CHARACTER,	/* 504 */
/* U+00F9 */	CANT_MAP_CHARACTER,	/* 505 */
/* U+00FA */	CANT_MAP_CHARACTER,	/* 506 */
/* U+00FB */	CANT_MAP_CHARACTER,	/* 507 */
/* U+00FC */	CANT_MAP_CHARACTER,	/* 508 */
/* U+00FD */	CANT_MAP_CHARACTER,	/* 509 */
/* U+00FE */	CANT_MAP_CHARACTER,	/* 510 */
/* U+00FF */	CANT_MAP_CHARACTER,	/* 511 */
/* U+0300 */	CANT_MAP_CHARACTER,	/* 512 */
/* U+0301 */	CANT_MAP_CHARACTER,	/* 513 */
/* U+0302 */	CANT_MAP_CHARACTER,	/* 514 */
/* U+0303 */	CANT_MAP_CHARACTER,	/* 515 */
/* U+0304 */	CANT_MAP_CHARACTER,	/* 516 */
/* U+0305 */	CANT_MAP_CHARACTER,	/* 517 */
/* U+0306 */	CANT_MAP_CHARACTER,	/* 518 */
/* U+0307 */	CANT_MAP_CHARACTER,	/* 519 */
/* U+0308 */	CANT_MAP_CHARACTER,	/* 520 */
/* U+0309 */	CANT_MAP_CHARACTER,	/* 521 */
/* U+030A */	CANT_MAP_CHARACTER,	/* 522 */
/* U+030B */	CANT_MAP_CHARACTER,	/* 523 */
/* U+030C */	CANT_MAP_CHARACTER,	/* 524 */
/* U+030D */	CANT_MAP_CHARACTER,	/* 525 */
/* U+030E */	CANT_MAP_CHARACTER,	/* 526 */
/* U+030F */	CANT_MAP_CHARACTER,	/* 527 */
/* U+0310 */	CANT_MAP_CHARACTER,	/* 528 */
/* U+0311 */	CANT_MAP_CHARACTER,	/* 529 */
/* U+0312 */	CANT_MAP_CHARACTER,	/* 530 */
/* U+0313 */	CANT_MAP_CHARACTER,	/* 531 */
/* U+0314 */	CANT_MAP_CHARACTER,	/* 532 */
/* U+0315 */	CANT_MAP_CHARACTER,	/* 533 */
/* U+0316 */	CANT_MAP_CHARACTER,	/* 534 */
/* U+0317 */	CANT_MAP_CHARACTER,	/* 535 */
/* U+0318 */	CANT_MAP_CHARACTER,	/* 536 */
/* U+0319 */	CANT_MAP_CHARACTER,	/* 537 */
/* U+031A */	CANT_MAP_CHARACTER,	/* 538 */
/* U+031B */	CANT_MAP_CHARACTER,	/* 539 */
/* U+031C */	CANT_MAP_CHARACTER,	/* 540 */
/* U+031D */	CANT_MAP_CHARACTER,	/* 541 */
/* U+031E */	CANT_MAP_CHARACTER,	/* 542 */
/* U+031F */	CANT_MAP_CHARACTER,	/* 543 */
/* U+0320 */	CANT_MAP_CHARACTER,	/* 544 */
/* U+0321 */	CANT_MAP_CHARACTER,	/* 545 */
/* U+0322 */	CANT_MAP_CHARACTER,	/* 546 */
/* U+0323 */	CANT_MAP_CHARACTER,	/* 547 */
/* U+0324 */	CANT_MAP_CHARACTER,	/* 548 */
/* U+0325 */	CANT_MAP_CHARACTER,	/* 549 */
/* U+0326 */	CANT_MAP_CHARACTER,	/* 550 */
/* U+0327 */	CANT_MAP_CHARACTER,	/* 551 */
/* U+0328 */	CANT_MAP_CHARACTER,	/* 552 */
/* U+0329 */	CANT_MAP_CHARACTER,	/* 553 */
/* U+032A */	CANT_MAP_CHARACTER,	/* 554 */
/* U+032B */	CANT_MAP_CHARACTER,	/* 555 */
/* U+032C */	CANT_MAP_CHARACTER,	/* 556 */
/* U+032D */	CANT_MAP_CHARACTER,	/* 557 */
/* U+032E */	CANT_MAP_CHARACTER,	/* 558 */
/* U+032F */	CANT_MAP_CHARACTER,	/* 559 */
/* U+0330 */	CANT_MAP_CHARACTER,	/* 560 */
/* U+0331 */	CANT_MAP_CHARACTER,	/* 561 */
/* U+0332 */	CANT_MAP_CHARACTER,	/* 562 */
/* U+0333 */	CANT_MAP_CHARACTER,	/* 563 */
/* U+0334 */	CANT_MAP_CHARACTER,	/* 564 */
/* U+0335 */	CANT_MAP_CHARACTER,	/* 565 */
/* U+0336 */	CANT_MAP_CHARACTER,	/* 566 */
/* U+0337 */	CANT_MAP_CHARACTER,	/* 567 */
/* U+0338 */	CANT_MAP_CHARACTER,	/* 568 */
/* U+0339 */	CANT_MAP_CHARACTER,	/* 569 */
/* U+033A */	CANT_MAP_CHARACTER,	/* 570 */
/* U+033B */	CANT_MAP_CHARACTER,	/* 571 */
/* U+033C */	CANT_MAP_CHARACTER,	/* 572 */
/* U+033D */	CANT_MAP_CHARACTER,	/* 573 */
/* U+033E */	CANT_MAP_CHARACTER,	/* 574 */
/* U+033F */	CANT_MAP_CHARACTER,	/* 575 */
/* U+0340 */	CANT_MAP_CHARACTER,	/* 576 */
/* U+0341 */	CANT_MAP_CHARACTER,	/* 577 */
/* U+0342 */	CANT_MAP_CHARACTER,	/* 578 */
/* U+0343 */	CANT_MAP_CHARACTER,	/* 579 */
/* U+0344 */	CANT_MAP_CHARACTER,	/* 580 */
/* U+0345 */	CANT_MAP_CHARACTER,	/* 581 */
/* U+0346 */	CANT_MAP_CHARACTER,	/* 582 */
/* U+0347 */	CANT_MAP_CHARACTER,	/* 583 */
/* U+0348 */	CANT_MAP_CHARACTER,	/* 584 */
/* U+0349 */	CANT_MAP_CHARACTER,	/* 585 */
/* U+034A */	CANT_MAP_CHARACTER,	/* 586 */
/* U+034B */	CANT_MAP_CHARACTER,	/* 587 */
/* U+034C */	CANT_MAP_CHARACTER,	/* 588 */
/* U+034D */	CANT_MAP_CHARACTER,	/* 589 */
/* U+034E */	CANT_MAP_CHARACTER,	/* 590 */
/* U+034F */	CANT_MAP_CHARACTER,	/* 591 */
/* U+0350 */	CANT_MAP_CHARACTER,	/* 592 */
/* U+0351 */	CANT_MAP_CHARACTER,	/* 593 */
/* U+0352 */	CANT_MAP_CHARACTER,	/* 594 */
/* U+0353 */	CANT_MAP_CHARACTER,	/* 595 */
/* U+0354 */	CANT_MAP_CHARACTER,	/* 596 */
/* U+0355 */	CANT_MAP_CHARACTER,	/* 597 */
/* U+0356 */	CANT_MAP_CHARACTER,	/* 598 */
/* U+0357 */	CANT_MAP_CHARACTER,	/* 599 */
/* U+0358 */	CANT_MAP_CHARACTER,	/* 600 */
/* U+0359 */	CANT_MAP_CHARACTER,	/* 601 */
/* U+035A */	CANT_MAP_CHARACTER,	/* 602 */
/* U+035B */	CANT_MAP_CHARACTER,	/* 603 */
/* U+035C */	CANT_MAP_CHARACTER,	/* 604 */
/* U+035D */	CANT_MAP_CHARACTER,	/* 605 */
/* U+035E */	CANT_MAP_CHARACTER,	/* 606 */
/* U+035F */	CANT_MAP_CHARACTER,	/* 607 */
/* U+0360 */	CANT_MAP_CHARACTER,	/* 608 */
/* U+0361 */	CANT_MAP_CHARACTER,	/* 609 */
/* U+0362 */	CANT_MAP_CHARACTER,	/* 610 */
/* U+0363 */	CANT_MAP_CHARACTER,	/* 611 */
/* U+0364 */	CANT_MAP_CHARACTER,	/* 612 */
/* U+0365 */	CANT_MAP_CHARACTER,	/* 613 */
/* U+0366 */	CANT_MAP_CHARACTER,	/* 614 */
/* U+0367 */	CANT_MAP_CHARACTER,	/* 615 */
/* U+0368 */	CANT_MAP_CHARACTER,	/* 616 */
/* U+0369 */	CANT_MAP_CHARACTER,	/* 617 */
/* U+036A */	CANT_MAP_CHARACTER,	/* 618 */
/* U+036B */	CANT_MAP_CHARACTER,	/* 619 */
/* U+036C */	CANT_MAP_CHARACTER,	/* 620 */
/* U+036D */	CANT_MAP_CHARACTER,	/* 621 */
/* U+036E */	CANT_MAP_CHARACTER,	/* 622 */
/* U+036F */	CANT_MAP_CHARACTER,	/* 623 */
/* U+0370 */	CANT_MAP_CHARACTER,	/* 624 */
/* U+0371 */	CANT_MAP_CHARACTER,	/* 625 */
/* U+0372 */	CANT_MAP_CHARACTER,	/* 626 */
/* U+0373 */	CANT_MAP_CHARACTER,	/* 627 */
/* U+0374 */	CANT_MAP_CHARACTER,	/* 628 */
/* U+0375 */	CANT_MAP_CHARACTER,	/* 629 */
/* U+0376 */	CANT_MAP_CHARACTER,	/* 630 */
/* U+0377 */	CANT_MAP_CHARACTER,	/* 631 */
/* U+0378 */	CANT_MAP_CHARACTER,	/* 632 */
/* U+0379 */	CANT_MAP_CHARACTER,	/* 633 */
/* U+037A */	CANT_MAP_CHARACTER,	/* 634 */
/* U+037B */	CANT_MAP_CHARACTER,	/* 635 */
/* U+037C */	CANT_MAP_CHARACTER,	/* 636 */
/* U+037D */	CANT_MAP_CHARACTER,	/* 637 */
/* U+037E */	CANT_MAP_CHARACTER,	/* 638 */
/* U+037F */	CANT_MAP_CHARACTER,	/* 639 */
/* U+0380 */	CANT_MAP_CHARACTER,	/* 640 */
/* U+0381 */	CANT_MAP_CHARACTER,	/* 641 */
/* U+0382 */	CANT_MAP_CHARACTER,	/* 642 */
/* U+0383 */	CANT_MAP_CHARACTER,	/* 643 */
/* U+0384 */	0xEF	/*                                   GREEK TONOS */,/* 644 */
/* U+0385 */	0xF7	/*                         GREEK DIALYTIKA TONOS */,/* 645 */
/* U+0386 */	0x86	/*         GREEK CAPITAL LETTER ALPHA WITH TONOS */,/* 646 */
/* U+0387 */	CANT_MAP_CHARACTER,	/* 647 */
/* U+0388 */	0x8D	/*       GREEK CAPITAL LETTER EPSILON WITH TONOS */,/* 648 */
/* U+0389 */	0x8F	/*           GREEK CAPITAL LETTER ETA WITH TONOS */,/* 649 */
/* U+038A */	0x90	/*          GREEK CAPITAL LETTER IOTA WITH TONOS */,/* 650 */
/* U+038B */	CANT_MAP_CHARACTER,	/* 651 */
/* U+038C */	0x92	/*       GREEK CAPITAL LETTER OMICRON WITH TONOS */,/* 652 */
/* U+038D */	CANT_MAP_CHARACTER,	/* 653 */
/* U+038E */	0x95	/*       GREEK CAPITAL LETTER UPSILON WITH TONOS */,/* 654 */
/* U+038F */	0x98	/*         GREEK CAPITAL LETTER OMEGA WITH TONOS */,/* 655 */
/* U+0390 */	0xA1	/* GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS */,/* 656 */
/* U+0391 */	0xA4	/*                    GREEK CAPITAL LETTER ALPHA */,/* 657 */
/* U+0392 */	0xA5	/*                     GREEK CAPITAL LETTER BETA */,/* 658 */
/* U+0393 */	0xA6	/*                    GREEK CAPITAL LETTER GAMMA */,/* 659 */
/* U+0394 */	0xA7	/*                    GREEK CAPITAL LETTER DELTA */,/* 660 */
/* U+0395 */	0xA8	/*                  GREEK CAPITAL LETTER EPSILON */,/* 661 */
/* U+0396 */	0xA9	/*                     GREEK CAPITAL LETTER ZETA */,/* 662 */
/* U+0397 */	0xAA	/*                      GREEK CAPITAL LETTER ETA */,/* 663 */
/* U+0398 */	0xAC	/*                    GREEK CAPITAL LETTER THETA */,/* 664 */
/* U+0399 */	0xAD	/*                     GREEK CAPITAL LETTER IOTA */,/* 665 */
/* U+039A */	0xB5	/*                    GREEK CAPITAL LETTER KAPPA */,/* 666 */
/* U+039B */	0xB6	/*                    GREEK CAPITAL LETTER LAMDA */,/* 667 */
/* U+039C */	0xB7	/*                       GREEK CAPITAL LETTER MU */,/* 668 */
/* U+039D */	0xB8	/*                       GREEK CAPITAL LETTER NU */,/* 669 */
/* U+039E */	0xBD	/*                       GREEK CAPITAL LETTER XI */,/* 670 */
/* U+039F */	0xBE	/*                  GREEK CAPITAL LETTER OMICRON */,/* 671 */
/* U+03A0 */	0xC6	/*                       GREEK CAPITAL LETTER PI */,/* 672 */
/* U+03A1 */	0xC7	/*                      GREEK CAPITAL LETTER RHO */,/* 673 */
/* U+03A2 */	CANT_MAP_CHARACTER,	/* 674 */
/* U+03A3 */	0xCF	/*                    GREEK CAPITAL LETTER SIGMA */,/* 675 */
/* U+03A4 */	0xD0	/*                      GREEK CAPITAL LETTER TAU */,/* 676 */
/* U+03A5 */	0xD1	/*                  GREEK CAPITAL LETTER UPSILON */,/* 677 */
/* U+03A6 */	0xD2	/*                      GREEK CAPITAL LETTER PHI */,/* 678 */
/* U+03A7 */	0xD3	/*                      GREEK CAPITAL LETTER CHI */,/* 679 */
/* U+03A8 */	0xD4	/*                      GREEK CAPITAL LETTER PSI */,/* 680 */
/* U+03A9 */	0xD5	/*                    GREEK CAPITAL LETTER OMEGA */,/* 681 */
/* U+03AA */	0x91	/*      GREEK CAPITAL LETTER IOTA WITH DIALYTIKA */,/* 682 */
/* U+03AB */	0x96	/*   GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA */,/* 683 */
/* U+03AC */	0x9B	/*           GREEK SMALL LETTER ALPHA WITH TONOS */,/* 684 */
/* U+03AD */	0x9D	/*         GREEK SMALL LETTER EPSILON WITH TONOS */,/* 685 */
/* U+03AE */	0x9E	/*             GREEK SMALL LETTER ETA WITH TONOS */,/* 686 */
/* U+03AF */	0x9F	/*            GREEK SMALL LETTER IOTA WITH TONOS */,/* 687 */
/* U+03B0 */	0xFC	/* GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS */,/* 688 */
/* U+03B1 */	0xD6	/*                      GREEK SMALL LETTER ALPHA */,/* 689 */
/* U+03B2 */	0xD7	/*                       GREEK SMALL LETTER BETA */,/* 690 */
/* U+03B3 */	0xD8	/*                      GREEK SMALL LETTER GAMMA */,/* 691 */
/* U+03B4 */	0xDD	/*                      GREEK SMALL LETTER DELTA */,/* 692 */
/* U+03B5 */	0xDE	/*                    GREEK SMALL LETTER EPSILON */,/* 693 */
/* U+03B6 */	0xE0	/*                       GREEK SMALL LETTER ZETA */,/* 694 */
/* U+03B7 */	0xE1	/*                        GREEK SMALL LETTER ETA */,/* 695 */
/* U+03B8 */	0xE2	/*                      GREEK SMALL LETTER THETA */,/* 696 */
/* U+03B9 */	0xE3	/*                       GREEK SMALL LETTER IOTA */,/* 697 */
/* U+03BA */	0xE4	/*                      GREEK SMALL LETTER KAPPA */,/* 698 */
/* U+03BB */	0xE5	/*                      GREEK SMALL LETTER LAMDA */,/* 699 */
/* U+03BC */	0xE6	/*                         GREEK SMALL LETTER MU */,/* 700 */
/* U+03BD */	0xE7	/*                         GREEK SMALL LETTER NU */,/* 701 */
/* U+03BE */	0xE8	/*                         GREEK SMALL LETTER XI */,/* 702 */
/* U+03BF */	0xE9	/*                    GREEK SMALL LETTER OMICRON */,/* 703 */
/* U+03C0 */	0xEA	/*                         GREEK SMALL LETTER PI */,/* 704 */
/* U+03C1 */	0xEB	/*                        GREEK SMALL LETTER RHO */,/* 705 */
/* U+03C2 */	0xED	/*                GREEK SMALL LETTER FINAL SIGMA */,/* 706 */
/* U+03C3 */	0xEC	/*                      GREEK SMALL LETTER SIGMA */,/* 707 */
/* U+03C4 */	0xEE	/*                        GREEK SMALL LETTER TAU */,/* 708 */
/* U+03C5 */	0xF2	/*                    GREEK SMALL LETTER UPSILON */,/* 709 */
/* U+03C6 */	0xF3	/*                        GREEK SMALL LETTER PHI */,/* 710 */
/* U+03C7 */	0xF4	/*                        GREEK SMALL LETTER CHI */,/* 711 */
/* U+03C8 */	0xF6	/*                        GREEK SMALL LETTER PSI */,/* 712 */
/* U+03C9 */	0xFA	/*                      GREEK SMALL LETTER OMEGA */,/* 713 */
/* U+03CA */	0xA0	/*        GREEK SMALL LETTER IOTA WITH DIALYTIKA */,/* 714 */
/* U+03CB */	0xFB	/*     GREEK SMALL LETTER UPSILON WITH DIALYTIKA */,/* 715 */
/* U+03CC */	0xA2	/*         GREEK SMALL LETTER OMICRON WITH TONOS */,/* 716 */
/* U+03CD */	0xA3	/*         GREEK SMALL LETTER UPSILON WITH TONOS */,/* 717 */
/* U+03CE */	0xFD	/*           GREEK SMALL LETTER OMEGA WITH TONOS */,/* 718 */
/* U+03CF */	CANT_MAP_CHARACTER,	/* 719 */
/* U+03D0 */	CANT_MAP_CHARACTER,	/* 720 */
/* U+03D1 */	CANT_MAP_CHARACTER,	/* 721 */
/* U+03D2 */	CANT_MAP_CHARACTER,	/* 722 */
/* U+03D3 */	CANT_MAP_CHARACTER,	/* 723 */
/* U+03D4 */	CANT_MAP_CHARACTER,	/* 724 */
/* U+03D5 */	CANT_MAP_CHARACTER,	/* 725 */
/* U+03D6 */	CANT_MAP_CHARACTER,	/* 726 */
/* U+03D7 */	CANT_MAP_CHARACTER,	/* 727 */
/* U+03D8 */	CANT_MAP_CHARACTER,	/* 728 */
/* U+03D9 */	CANT_MAP_CHARACTER,	/* 729 */
/* U+03DA */	CANT_MAP_CHARACTER,	/* 730 */
/* U+03DB */	CANT_MAP_CHARACTER,	/* 731 */
/* U+03DC */	CANT_MAP_CHARACTER,	/* 732 */
/* U+03DD */	CANT_MAP_CHARACTER,	/* 733 */
/* U+03DE */	CANT_MAP_CHARACTER,	/* 734 */
/* U+03DF */	CANT_MAP_CHARACTER,	/* 735 */
/* U+03E0 */	CANT_MAP_CHARACTER,	/* 736 */
/* U+03E1 */	CANT_MAP_CHARACTER,	/* 737 */
/* U+03E2 */	CANT_MAP_CHARACTER,	/* 738 */
/* U+03E3 */	CANT_MAP_CHARACTER,	/* 739 */
/* U+03E4 */	CANT_MAP_CHARACTER,	/* 740 */
/* U+03E5 */	CANT_MAP_CHARACTER,	/* 741 */
/* U+03E6 */	CANT_MAP_CHARACTER,	/* 742 */
/* U+03E7 */	CANT_MAP_CHARACTER,	/* 743 */
/* U+03E8 */	CANT_MAP_CHARACTER,	/* 744 */
/* U+03E9 */	CANT_MAP_CHARACTER,	/* 745 */
/* U+03EA */	CANT_MAP_CHARACTER,	/* 746 */
/* U+03EB */	CANT_MAP_CHARACTER,	/* 747 */
/* U+03EC */	CANT_MAP_CHARACTER,	/* 748 */
/* U+03ED */	CANT_MAP_CHARACTER,	/* 749 */
/* U+03EE */	CANT_MAP_CHARACTER,	/* 750 */
/* U+03EF */	CANT_MAP_CHARACTER,	/* 751 */
/* U+03F0 */	CANT_MAP_CHARACTER,	/* 752 */
/* U+03F1 */	CANT_MAP_CHARACTER,	/* 753 */
/* U+03F2 */	CANT_MAP_CHARACTER,	/* 754 */
/* U+03F3 */	CANT_MAP_CHARACTER,	/* 755 */
/* U+03F4 */	CANT_MAP_CHARACTER,	/* 756 */
/* U+03F5 */	CANT_MAP_CHARACTER,	/* 757 */
/* U+03F6 */	CANT_MAP_CHARACTER,	/* 758 */
/* U+03F7 */	CANT_MAP_CHARACTER,	/* 759 */
/* U+03F8 */	CANT_MAP_CHARACTER,	/* 760 */
/* U+03F9 */	CANT_MAP_CHARACTER,	/* 761 */
/* U+03FA */	CANT_MAP_CHARACTER,	/* 762 */
/* U+03FB */	CANT_MAP_CHARACTER,	/* 763 */
/* U+03FC */	CANT_MAP_CHARACTER,	/* 764 */
/* U+03FD */	CANT_MAP_CHARACTER,	/* 765 */
/* U+03FE */	CANT_MAP_CHARACTER,	/* 766 */
/* U+03FF */	CANT_MAP_CHARACTER,	/* 767 */
/* U+2000 */	CANT_MAP_CHARACTER,	/* 768 */
/* U+2001 */	CANT_MAP_CHARACTER,	/* 769 */
/* U+2002 */	CANT_MAP_CHARACTER,	/* 770 */
/* U+2003 */	CANT_MAP_CHARACTER,	/* 771 */
/* U+2004 */	CANT_MAP_CHARACTER,	/* 772 */
/* U+2005 */	CANT_MAP_CHARACTER,	/* 773 */
/* U+2006 */	CANT_MAP_CHARACTER,	/* 774 */
/* U+2007 */	CANT_MAP_CHARACTER,	/* 775 */
/* U+2008 */	CANT_MAP_CHARACTER,	/* 776 */
/* U+2009 */	CANT_MAP_CHARACTER,	/* 777 */
/* U+200A */	CANT_MAP_CHARACTER,	/* 778 */
/* U+200B */	CANT_MAP_CHARACTER,	/* 779 */
/* U+200C */	CANT_MAP_CHARACTER,	/* 780 */
/* U+200D */	CANT_MAP_CHARACTER,	/* 781 */
/* U+200E */	CANT_MAP_CHARACTER,	/* 782 */
/* U+200F */	CANT_MAP_CHARACTER,	/* 783 */
/* U+2010 */	CANT_MAP_CHARACTER,	/* 784 */
/* U+2011 */	CANT_MAP_CHARACTER,	/* 785 */
/* U+2012 */	CANT_MAP_CHARACTER,	/* 786 */
/* U+2013 */	CANT_MAP_CHARACTER,	/* 787 */
/* U+2014 */	CANT_MAP_CHARACTER,	/* 788 */
/* U+2015 */	0x8E	/*                                HORIZONTAL BAR */,/* 789 */
/* U+2016 */	CANT_MAP_CHARACTER,	/* 790 */
/* U+2017 */	CANT_MAP_CHARACTER,	/* 791 */
/* U+2018 */	0x8B	/*                    LEFT SINGLE QUOTATION MARK */,/* 792 */
/* U+2019 */	0x8C	/*                   RIGHT SINGLE QUOTATION MARK */,/* 793 */
/* U+201A */	CANT_MAP_CHARACTER,	/* 794 */
/* U+201B */	CANT_MAP_CHARACTER,	/* 795 */
/* U+201C */	CANT_MAP_CHARACTER,	/* 796 */
/* U+201D */	CANT_MAP_CHARACTER,	/* 797 */
/* U+201E */	CANT_MAP_CHARACTER,	/* 798 */
/* U+201F */	CANT_MAP_CHARACTER,	/* 799 */
/* U+2020 */	CANT_MAP_CHARACTER,	/* 800 */
/* U+2021 */	CANT_MAP_CHARACTER,	/* 801 */
/* U+2022 */	CANT_MAP_CHARACTER,	/* 802 */
/* U+2023 */	CANT_MAP_CHARACTER,	/* 803 */
/* U+2024 */	CANT_MAP_CHARACTER,	/* 804 */
/* U+2025 */	CANT_MAP_CHARACTER,	/* 805 */
/* U+2026 */	CANT_MAP_CHARACTER,	/* 806 */
/* U+2027 */	CANT_MAP_CHARACTER,	/* 807 */
/* U+2028 */	CANT_MAP_CHARACTER,	/* 808 */
/* U+2029 */	CANT_MAP_CHARACTER,	/* 809 */
/* U+202A */	CANT_MAP_CHARACTER,	/* 810 */
/* U+202B */	CANT_MAP_CHARACTER,	/* 811 */
/* U+202C */	CANT_MAP_CHARACTER,	/* 812 */
/* U+202D */	CANT_MAP_CHARACTER,	/* 813 */
/* U+202E */	CANT_MAP_CHARACTER,	/* 814 */
/* U+202F */	CANT_MAP_CHARACTER,	/* 815 */
/* U+2030 */	CANT_MAP_CHARACTER,	/* 816 */
/* U+2031 */	CANT_MAP_CHARACTER,	/* 817 */
/* U+2032 */	CANT_MAP_CHARACTER,	/* 818 */
/* U+2033 */	CANT_MAP_CHARACTER,	/* 819 */
/* U+2034 */	CANT_MAP_CHARACTER,	/* 820 */
/* U+2035 */	CANT_MAP_CHARACTER,	/* 821 */
/* U+2036 */	CANT_MAP_CHARACTER,	/* 822 */
/* U+2037 */	CANT_MAP_CHARACTER,	/* 823 */
/* U+2038 */	CANT_MAP_CHARACTER,	/* 824 */
/* U+2039 */	CANT_MAP_CHARACTER,	/* 825 */
/* U+203A */	CANT_MAP_CHARACTER,	/* 826 */
/* U+203B */	CANT_MAP_CHARACTER,	/* 827 */
/* U+203C */	CANT_MAP_CHARACTER,	/* 828 */
/* U+203D */	CANT_MAP_CHARACTER,	/* 829 */
/* U+203E */	CANT_MAP_CHARACTER,	/* 830 */
/* U+203F */	CANT_MAP_CHARACTER,	/* 831 */
/* U+2040 */	CANT_MAP_CHARACTER,	/* 832 */
/* U+2041 */	CANT_MAP_CHARACTER,	/* 833 */
/* U+2042 */	CANT_MAP_CHARACTER,	/* 834 */
/* U+2043 */	CANT_MAP_CHARACTER,	/* 835 */
/* U+2044 */	CANT_MAP_CHARACTER,	/* 836 */
/* U+2045 */	CANT_MAP_CHARACTER,	/* 837 */
/* U+2046 */	CANT_MAP_CHARACTER,	/* 838 */
/* U+2047 */	CANT_MAP_CHARACTER,	/* 839 */
/* U+2048 */	CANT_MAP_CHARACTER,	/* 840 */
/* U+2049 */	CANT_MAP_CHARACTER,	/* 841 */
/* U+204A */	CANT_MAP_CHARACTER,	/* 842 */
/* U+204B */	CANT_MAP_CHARACTER,	/* 843 */
/* U+204C */	CANT_MAP_CHARACTER,	/* 844 */
/* U+204D */	CANT_MAP_CHARACTER,	/* 845 */
/* U+204E */	CANT_MAP_CHARACTER,	/* 846 */
/* U+204F */	CANT_MAP_CHARACTER,	/* 847 */
/* U+2050 */	CANT_MAP_CHARACTER,	/* 848 */
/* U+2051 */	CANT_MAP_CHARACTER,	/* 849 */
/* U+2052 */	CANT_MAP_CHARACTER,	/* 850 */
/* U+2053 */	CANT_MAP_CHARACTER,	/* 851 */
/* U+2054 */	CANT_MAP_CHARACTER,	/* 852 */
/* U+2055 */	CANT_MAP_CHARACTER,	/* 853 */
/* U+2056 */	CANT_MAP_CHARACTER,	/* 854 */
/* U+2057 */	CANT_MAP_CHARACTER,	/* 855 */
/* U+2058 */	CANT_MAP_CHARACTER,	/* 856 */
/* U+2059 */	CANT_MAP_CHARACTER,	/* 857 */
/* U+205A */	CANT_MAP_CHARACTER,	/* 858 */
/* U+205B */	CANT_MAP_CHARACTER,	/* 859 */
/* U+205C */	CANT_MAP_CHARACTER,	/* 860 */
/* U+205D */	CANT_MAP_CHARACTER,	/* 861 */
/* U+205E */	CANT_MAP_CHARACTER,	/* 862 */
/* U+205F */	CANT_MAP_CHARACTER,	/* 863 */
/* U+2060 */	CANT_MAP_CHARACTER,	/* 864 */
/* U+2061 */	CANT_MAP_CHARACTER,	/* 865 */
/* U+2062 */	CANT_MAP_CHARACTER,	/* 866 */
/* U+2063 */	CANT_MAP_CHARACTER,	/* 867 */
/* U+2064 */	CANT_MAP_CHARACTER,	/* 868 */
/* U+2065 */	CANT_MAP_CHARACTER,	/* 869 */
/* U+2066 */	CANT_MAP_CHARACTER,	/* 870 */
/* U+2067 */	CANT_MAP_CHARACTER,	/* 871 */
/* U+2068 */	CANT_MAP_CHARACTER,	/* 872 */
/* U+2069 */	CANT_MAP_CHARACTER,	/* 873 */
/* U+206A */	CANT_MAP_CHARACTER,	/* 874 */
/* U+206B */	CANT_MAP_CHARACTER,	/* 875 */
/* U+206C */	CANT_MAP_CHARACTER,	/* 876 */
/* U+206D */	CANT_MAP_CHARACTER,	/* 877 */
/* U+206E */	CANT_MAP_CHARACTER,	/* 878 */
/* U+206F */	CANT_MAP_CHARACTER,	/* 879 */
/* U+2070 */	CANT_MAP_CHARACTER,	/* 880 */
/* U+2071 */	CANT_MAP_CHARACTER,	/* 881 */
/* U+2072 */	CANT_MAP_CHARACTER,	/* 882 */
/* U+2073 */	CANT_MAP_CHARACTER,	/* 883 */
/* U+2074 */	CANT_MAP_CHARACTER,	/* 884 */
/* U+2075 */	CANT_MAP_CHARACTER,	/* 885 */
/* U+2076 */	CANT_MAP_CHARACTER,	/* 886 */
/* U+2077 */	CANT_MAP_CHARACTER,	/* 887 */
/* U+2078 */	CANT_MAP_CHARACTER,	/* 888 */
/* U+2079 */	CANT_MAP_CHARACTER,	/* 889 */
/* U+207A */	CANT_MAP_CHARACTER,	/* 890 */
/* U+207B */	CANT_MAP_CHARACTER,	/* 891 */
/* U+207C */	CANT_MAP_CHARACTER,	/* 892 */
/* U+207D */	CANT_MAP_CHARACTER,	/* 893 */
/* U+207E */	CANT_MAP_CHARACTER,	/* 894 */
/* U+207F */	CANT_MAP_CHARACTER,	/* 895 */
/* U+2080 */	CANT_MAP_CHARACTER,	/* 896 */
/* U+2081 */	CANT_MAP_CHARACTER,	/* 897 */
/* U+2082 */	CANT_MAP_CHARACTER,	/* 898 */
/* U+2083 */	CANT_MAP_CHARACTER,	/* 899 */
/* U+2084 */	CANT_MAP_CHARACTER,	/* 900 */
/* U+2085 */	CANT_MAP_CHARACTER,	/* 901 */
/* U+2086 */	CANT_MAP_CHARACTER,	/* 902 */
/* U+2087 */	CANT_MAP_CHARACTER,	/* 903 */
/* U+2088 */	CANT_MAP_CHARACTER,	/* 904 */
/* U+2089 */	CANT_MAP_CHARACTER,	/* 905 */
/* U+208A */	CANT_MAP_CHARACTER,	/* 906 */
/* U+208B */	CANT_MAP_CHARACTER,	/* 907 */
/* U+208C */	CANT_MAP_CHARACTER,	/* 908 */
/* U+208D */	CANT_MAP_CHARACTER,	/* 909 */
/* U+208E */	CANT_MAP_CHARACTER,	/* 910 */
/* U+208F */	CANT_MAP_CHARACTER,	/* 911 */
/* U+2090 */	CANT_MAP_CHARACTER,	/* 912 */
/* U+2091 */	CANT_MAP_CHARACTER,	/* 913 */
/* U+2092 */	CANT_MAP_CHARACTER,	/* 914 */
/* U+2093 */	CANT_MAP_CHARACTER,	/* 915 */
/* U+2094 */	CANT_MAP_CHARACTER,	/* 916 */
/* U+2095 */	CANT_MAP_CHARACTER,	/* 917 */
/* U+2096 */	CANT_MAP_CHARACTER,	/* 918 */
/* U+2097 */	CANT_MAP_CHARACTER,	/* 919 */
/* U+2098 */	CANT_MAP_CHARACTER,	/* 920 */
/* U+2099 */	CANT_MAP_CHARACTER,	/* 921 */
/* U+209A */	CANT_MAP_CHARACTER,	/* 922 */
/* U+209B */	CANT_MAP_CHARACTER,	/* 923 */
/* U+209C */	CANT_MAP_CHARACTER,	/* 924 */
/* U+209D */	CANT_MAP_CHARACTER,	/* 925 */
/* U+209E */	CANT_MAP_CHARACTER,	/* 926 */
/* U+209F */	CANT_MAP_CHARACTER,	/* 927 */
/* U+20A0 */	CANT_MAP_CHARACTER,	/* 928 */
/* U+20A1 */	CANT_MAP_CHARACTER,	/* 929 */
/* U+20A2 */	CANT_MAP_CHARACTER,	/* 930 */
/* U+20A3 */	CANT_MAP_CHARACTER,	/* 931 */
/* U+20A4 */	CANT_MAP_CHARACTER,	/* 932 */
/* U+20A5 */	CANT_MAP_CHARACTER,	/* 933 */
/* U+20A6 */	CANT_MAP_CHARACTER,	/* 934 */
/* U+20A7 */	CANT_MAP_CHARACTER,	/* 935 */
/* U+20A8 */	CANT_MAP_CHARACTER,	/* 936 */
/* U+20A9 */	CANT_MAP_CHARACTER,	/* 937 */
/* U+20AA */	CANT_MAP_CHARACTER,	/* 938 */
/* U+20AB */	CANT_MAP_CHARACTER,	/* 939 */
/* U+20AC */	CANT_MAP_CHARACTER,	/* 940 */
/* U+20AD */	CANT_MAP_CHARACTER,	/* 941 */
/* U+20AE */	CANT_MAP_CHARACTER,	/* 942 */
/* U+20AF */	CANT_MAP_CHARACTER,	/* 943 */
/* U+20B0 */	CANT_MAP_CHARACTER,	/* 944 */
/* U+20B1 */	CANT_MAP_CHARACTER,	/* 945 */
/* U+20B2 */	CANT_MAP_CHARACTER,	/* 946 */
/* U+20B3 */	CANT_MAP_CHARACTER,	/* 947 */
/* U+20B4 */	CANT_MAP_CHARACTER,	/* 948 */
/* U+20B5 */	CANT_MAP_CHARACTER,	/* 949 */
/* U+20B6 */	CANT_MAP_CHARACTER,	/* 950 */
/* U+20B7 */	CANT_MAP_CHARACTER,	/* 951 */
/* U+20B8 */	CANT_MAP_CHARACTER,	/* 952 */
/* U+20B9 */	CANT_MAP_CHARACTER,	/* 953 */
/* U+20BA */	CANT_MAP_CHARACTER,	/* 954 */
/* U+20BB */	CANT_MAP_CHARACTER,	/* 955 */
/* U+20BC */	CANT_MAP_CHARACTER,	/* 956 */
/* U+20BD */	CANT_MAP_CHARACTER,	/* 957 */
/* U+20BE */	CANT_MAP_CHARACTER,	/* 958 */
/* U+20BF */	CANT_MAP_CHARACTER,	/* 959 */
/* U+20C0 */	CANT_MAP_CHARACTER,	/* 960 */
/* U+20C1 */	CANT_MAP_CHARACTER,	/* 961 */
/* U+20C2 */	CANT_MAP_CHARACTER,	/* 962 */
/* U+20C3 */	CANT_MAP_CHARACTER,	/* 963 */
/* U+20C4 */	CANT_MAP_CHARACTER,	/* 964 */
/* U+20C5 */	CANT_MAP_CHARACTER,	/* 965 */
/* U+20C6 */	CANT_MAP_CHARACTER,	/* 966 */
/* U+20C7 */	CANT_MAP_CHARACTER,	/* 967 */
/* U+20C8 */	CANT_MAP_CHARACTER,	/* 968 */
/* U+20C9 */	CANT_MAP_CHARACTER,	/* 969 */
/* U+20CA */	CANT_MAP_CHARACTER,	/* 970 */
/* U+20CB */	CANT_MAP_CHARACTER,	/* 971 */
/* U+20CC */	CANT_MAP_CHARACTER,	/* 972 */
/* U+20CD */	CANT_MAP_CHARACTER,	/* 973 */
/* U+20CE */	CANT_MAP_CHARACTER,	/* 974 */
/* U+20CF */	CANT_MAP_CHARACTER,	/* 975 */
/* U+20D0 */	CANT_MAP_CHARACTER,	/* 976 */
/* U+20D1 */	CANT_MAP_CHARACTER,	/* 977 */
/* U+20D2 */	CANT_MAP_CHARACTER,	/* 978 */
/* U+20D3 */	CANT_MAP_CHARACTER,	/* 979 */
/* U+20D4 */	CANT_MAP_CHARACTER,	/* 980 */
/* U+20D5 */	CANT_MAP_CHARACTER,	/* 981 */
/* U+20D6 */	CANT_MAP_CHARACTER,	/* 982 */
/* U+20D7 */	CANT_MAP_CHARACTER,	/* 983 */
/* U+20D8 */	CANT_MAP_CHARACTER,	/* 984 */
/* U+20D9 */	CANT_MAP_CHARACTER,	/* 985 */
/* U+20DA */	CANT_MAP_CHARACTER,	/* 986 */
/* U+20DB */	CANT_MAP_CHARACTER,	/* 987 */
/* U+20DC */	CANT_MAP_CHARACTER,	/* 988 */
/* U+20DD */	CANT_MAP_CHARACTER,	/* 989 */
/* U+20DE */	CANT_MAP_CHARACTER,	/* 990 */
/* U+20DF */	CANT_MAP_CHARACTER,	/* 991 */
/* U+20E0 */	CANT_MAP_CHARACTER,	/* 992 */
/* U+20E1 */	CANT_MAP_CHARACTER,	/* 993 */
/* U+20E2 */	CANT_MAP_CHARACTER,	/* 994 */
/* U+20E3 */	CANT_MAP_CHARACTER,	/* 995 */
/* U+20E4 */	CANT_MAP_CHARACTER,	/* 996 */
/* U+20E5 */	CANT_MAP_CHARACTER,	/* 997 */
/* U+20E6 */	CANT_MAP_CHARACTER,	/* 998 */
/* U+20E7 */	CANT_MAP_CHARACTER,	/* 999 */
/* U+20E8 */	CANT_MAP_CHARACTER,	/* 1000 */
/* U+20E9 */	CANT_MAP_CHARACTER,	/* 1001 */
/* U+20EA */	CANT_MAP_CHARACTER,	/* 1002 */
/* U+20EB */	CANT_MAP_CHARACTER,	/* 1003 */
/* U+20EC */	CANT_MAP_CHARACTER,	/* 1004 */
/* U+20ED */	CANT_MAP_CHARACTER,	/* 1005 */
/* U+20EE */	CANT_MAP_CHARACTER,	/* 1006 */
/* U+20EF */	CANT_MAP_CHARACTER,	/* 1007 */
/* U+20F0 */	CANT_MAP_CHARACTER,	/* 1008 */
/* U+20F1 */	CANT_MAP_CHARACTER,	/* 1009 */
/* U+20F2 */	CANT_MAP_CHARACTER,	/* 1010 */
/* U+20F3 */	CANT_MAP_CHARACTER,	/* 1011 */
/* U+20F4 */	CANT_MAP_CHARACTER,	/* 1012 */
/* U+20F5 */	CANT_MAP_CHARACTER,	/* 1013 */
/* U+20F6 */	CANT_MAP_CHARACTER,	/* 1014 */
/* U+20F7 */	CANT_MAP_CHARACTER,	/* 1015 */
/* U+20F8 */	CANT_MAP_CHARACTER,	/* 1016 */
/* U+20F9 */	CANT_MAP_CHARACTER,	/* 1017 */
/* U+20FA */	CANT_MAP_CHARACTER,	/* 1018 */
/* U+20FB */	CANT_MAP_CHARACTER,	/* 1019 */
/* U+20FC */	CANT_MAP_CHARACTER,	/* 1020 */
/* U+20FD */	CANT_MAP_CHARACTER,	/* 1021 */
/* U+20FE */	CANT_MAP_CHARACTER,	/* 1022 */
/* U+20FF */	CANT_MAP_CHARACTER,	/* 1023 */
/* U+2500 */	0xC4	/*                 BOX DRAWINGS LIGHT HORIZONTAL */,/* 1024 */
/* U+2501 */	CANT_MAP_CHARACTER,	/* 1025 */
/* U+2502 */	0xB3	/*                   BOX DRAWINGS LIGHT VERTICAL */,/* 1026 */
/* U+2503 */	CANT_MAP_CHARACTER,	/* 1027 */
/* U+2504 */	CANT_MAP_CHARACTER,	/* 1028 */
/* U+2505 */	CANT_MAP_CHARACTER,	/* 1029 */
/* U+2506 */	CANT_MAP_CHARACTER,	/* 1030 */
/* U+2507 */	CANT_MAP_CHARACTER,	/* 1031 */
/* U+2508 */	CANT_MAP_CHARACTER,	/* 1032 */
/* U+2509 */	CANT_MAP_CHARACTER,	/* 1033 */
/* U+250A */	CANT_MAP_CHARACTER,	/* 1034 */
/* U+250B */	CANT_MAP_CHARACTER,	/* 1035 */
/* U+250C */	0xDA	/*             BOX DRAWINGS LIGHT DOWN AND RIGHT */,/* 1036 */
/* U+250D */	CANT_MAP_CHARACTER,	/* 1037 */
/* U+250E */	CANT_MAP_CHARACTER,	/* 1038 */
/* U+250F */	CANT_MAP_CHARACTER,	/* 1039 */
/* U+2510 */	0xBF	/*              BOX DRAWINGS LIGHT DOWN AND LEFT */,/* 1040 */
/* U+2511 */	CANT_MAP_CHARACTER,	/* 1041 */
/* U+2512 */	CANT_MAP_CHARACTER,	/* 1042 */
/* U+2513 */	CANT_MAP_CHARACTER,	/* 1043 */
/* U+2514 */	0xC0	/*               BOX DRAWINGS LIGHT UP AND RIGHT */,/* 1044 */
/* U+2515 */	CANT_MAP_CHARACTER,	/* 1045 */
/* U+2516 */	CANT_MAP_CHARACTER,	/* 1046 */
/* U+2517 */	CANT_MAP_CHARACTER,	/* 1047 */
/* U+2518 */	0xD9	/*                BOX DRAWINGS LIGHT UP AND LEFT */,/* 1048 */
/* U+2519 */	CANT_MAP_CHARACTER,	/* 1049 */
/* U+251A */	CANT_MAP_CHARACTER,	/* 1050 */
/* U+251B */	CANT_MAP_CHARACTER,	/* 1051 */
/* U+251C */	0xC3	/*         BOX DRAWINGS LIGHT VERTICAL AND RIGHT */,/* 1052 */
/* U+251D */	CANT_MAP_CHARACTER,	/* 1053 */
/* U+251E */	CANT_MAP_CHARACTER,	/* 1054 */
/* U+251F */	CANT_MAP_CHARACTER,	/* 1055 */
/* U+2520 */	CANT_MAP_CHARACTER,	/* 1056 */
/* U+2521 */	CANT_MAP_CHARACTER,	/* 1057 */
/* U+2522 */	CANT_MAP_CHARACTER,	/* 1058 */
/* U+2523 */	CANT_MAP_CHARACTER,	/* 1059 */
/* U+2524 */	0xB4	/*          BOX DRAWINGS LIGHT VERTICAL AND LEFT */,/* 1060 */
/* U+2525 */	CANT_MAP_CHARACTER,	/* 1061 */
/* U+2526 */	CANT_MAP_CHARACTER,	/* 1062 */
/* U+2527 */	CANT_MAP_CHARACTER,	/* 1063 */
/* U+2528 */	CANT_MAP_CHARACTER,	/* 1064 */
/* U+2529 */	CANT_MAP_CHARACTER,	/* 1065 */
/* U+252A */	CANT_MAP_CHARACTER,	/* 1066 */
/* U+252B */	CANT_MAP_CHARACTER,	/* 1067 */
/* U+252C */	0xC2	/*        BOX DRAWINGS LIGHT DOWN AND HORIZONTAL */,/* 1068 */
/* U+252D */	CANT_MAP_CHARACTER,	/* 1069 */
/* U+252E */	CANT_MAP_CHARACTER,	/* 1070 */
/* U+252F */	CANT_MAP_CHARACTER,	/* 1071 */
/* U+2530 */	CANT_MAP_CHARACTER,	/* 1072 */
/* U+2531 */	CANT_MAP_CHARACTER,	/* 1073 */
/* U+2532 */	CANT_MAP_CHARACTER,	/* 1074 */
/* U+2533 */	CANT_MAP_CHARACTER,	/* 1075 */
/* U+2534 */	0xC1	/*          BOX DRAWINGS LIGHT UP AND HORIZONTAL */,/* 1076 */
/* U+2535 */	CANT_MAP_CHARACTER,	/* 1077 */
/* U+2536 */	CANT_MAP_CHARACTER,	/* 1078 */
/* U+2537 */	CANT_MAP_CHARACTER,	/* 1079 */
/* U+2538 */	CANT_MAP_CHARACTER,	/* 1080 */
/* U+2539 */	CANT_MAP_CHARACTER,	/* 1081 */
/* U+253A */	CANT_MAP_CHARACTER,	/* 1082 */
/* U+253B */	CANT_MAP_CHARACTER,	/* 1083 */
/* U+253C */	0xC5	/*    BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL */,/* 1084 */
/* U+253D */	CANT_MAP_CHARACTER,	/* 1085 */
/* U+253E */	CANT_MAP_CHARACTER,	/* 1086 */
/* U+253F */	CANT_MAP_CHARACTER,	/* 1087 */
/* U+2540 */	CANT_MAP_CHARACTER,	/* 1088 */
/* U+2541 */	CANT_MAP_CHARACTER,	/* 1089 */
/* U+2542 */	CANT_MAP_CHARACTER,	/* 1090 */
/* U+2543 */	CANT_MAP_CHARACTER,	/* 1091 */
/* U+2544 */	CANT_MAP_CHARACTER,	/* 1092 */
/* U+2545 */	CANT_MAP_CHARACTER,	/* 1093 */
/* U+2546 */	CANT_MAP_CHARACTER,	/* 1094 */
/* U+2547 */	CANT_MAP_CHARACTER,	/* 1095 */
/* U+2548 */	CANT_MAP_CHARACTER,	/* 1096 */
/* U+2549 */	CANT_MAP_CHARACTER,	/* 1097 */
/* U+254A */	CANT_MAP_CHARACTER,	/* 1098 */
/* U+254B */	CANT_MAP_CHARACTER,	/* 1099 */
/* U+254C */	CANT_MAP_CHARACTER,	/* 1100 */
/* U+254D */	CANT_MAP_CHARACTER,	/* 1101 */
/* U+254E */	CANT_MAP_CHARACTER,	/* 1102 */
/* U+254F */	CANT_MAP_CHARACTER,	/* 1103 */
/* U+2550 */	0xCD	/*                BOX DRAWINGS DOUBLE HORIZONTAL */,/* 1104 */
/* U+2551 */	0xBA	/*                  BOX DRAWINGS DOUBLE VERTICAL */,/* 1105 */
/* U+2552 */	CANT_MAP_CHARACTER,	/* 1106 */
/* U+2553 */	CANT_MAP_CHARACTER,	/* 1107 */
/* U+2554 */	0xC9	/*            BOX DRAWINGS DOUBLE DOWN AND RIGHT */,/* 1108 */
/* U+2555 */	CANT_MAP_CHARACTER,	/* 1109 */
/* U+2556 */	CANT_MAP_CHARACTER,	/* 1110 */
/* U+2557 */	0xBB	/*             BOX DRAWINGS DOUBLE DOWN AND LEFT */,/* 1111 */
/* U+2558 */	CANT_MAP_CHARACTER,	/* 1112 */
/* U+2559 */	CANT_MAP_CHARACTER,	/* 1113 */
/* U+255A */	0xC8	/*              BOX DRAWINGS DOUBLE UP AND RIGHT */,/* 1114 */
/* U+255B */	CANT_MAP_CHARACTER,	/* 1115 */
/* U+255C */	CANT_MAP_CHARACTER,	/* 1116 */
/* U+255D */	0xBC	/*               BOX DRAWINGS DOUBLE UP AND LEFT */,/* 1117 */
/* U+255E */	CANT_MAP_CHARACTER,	/* 1118 */
/* U+255F */	CANT_MAP_CHARACTER,	/* 1119 */
/* U+2560 */	0xCC	/*        BOX DRAWINGS DOUBLE VERTICAL AND RIGHT */,/* 1120 */
/* U+2561 */	CANT_MAP_CHARACTER,	/* 1121 */
/* U+2562 */	CANT_MAP_CHARACTER,	/* 1122 */
/* U+2563 */	0xB9	/*         BOX DRAWINGS DOUBLE VERTICAL AND LEFT */,/* 1123 */
/* U+2564 */	CANT_MAP_CHARACTER,	/* 1124 */
/* U+2565 */	CANT_MAP_CHARACTER,	/* 1125 */
/* U+2566 */	0xCB	/*       BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL */,/* 1126 */
/* U+2567 */	CANT_MAP_CHARACTER,	/* 1127 */
/* U+2568 */	CANT_MAP_CHARACTER,	/* 1128 */
/* U+2569 */	0xCA	/*         BOX DRAWINGS DOUBLE UP AND HORIZONTAL */,/* 1129 */
/* U+256A */	CANT_MAP_CHARACTER,	/* 1130 */
/* U+256B */	CANT_MAP_CHARACTER,	/* 1131 */
/* U+256C */	0xCE	/*   BOX DRAWINGS DOUBLE VERTICAL AND HORIZONTAL */,/* 1132 */
/* U+256D */	CANT_MAP_CHARACTER,	/* 1133 */
/* U+256E */	CANT_MAP_CHARACTER,	/* 1134 */
/* U+256F */	CANT_MAP_CHARACTER,	/* 1135 */
/* U+2570 */	CANT_MAP_CHARACTER,	/* 1136 */
/* U+2571 */	CANT_MAP_CHARACTER,	/* 1137 */
/* U+2572 */	CANT_MAP_CHARACTER,	/* 1138 */
/* U+2573 */	CANT_MAP_CHARACTER,	/* 1139 */
/* U+2574 */	CANT_MAP_CHARACTER,	/* 1140 */
/* U+2575 */	CANT_MAP_CHARACTER,	/* 1141 */
/* U+2576 */	CANT_MAP_CHARACTER,	/* 1142 */
/* U+2577 */	CANT_MAP_CHARACTER,	/* 1143 */
/* U+2578 */	CANT_MAP_CHARACTER,	/* 1144 */
/* U+2579 */	CANT_MAP_CHARACTER,	/* 1145 */
/* U+257A */	CANT_MAP_CHARACTER,	/* 1146 */
/* U+257B */	CANT_MAP_CHARACTER,	/* 1147 */
/* U+257C */	CANT_MAP_CHARACTER,	/* 1148 */
/* U+257D */	CANT_MAP_CHARACTER,	/* 1149 */
/* U+257E */	CANT_MAP_CHARACTER,	/* 1150 */
/* U+257F */	CANT_MAP_CHARACTER,	/* 1151 */
/* U+2580 */	0xDF	/*                              UPPER HALF BLOCK */,/* 1152 */
/* U+2581 */	CANT_MAP_CHARACTER,	/* 1153 */
/* U+2582 */	CANT_MAP_CHARACTER,	/* 1154 */
/* U+2583 */	CANT_MAP_CHARACTER,	/* 1155 */
/* U+2584 */	0xDC	/*                              LOWER HALF BLOCK */,/* 1156 */
/* U+2585 */	CANT_MAP_CHARACTER,	/* 1157 */
/* U+2586 */	CANT_MAP_CHARACTER,	/* 1158 */
/* U+2587 */	CANT_MAP_CHARACTER,	/* 1159 */
/* U+2588 */	0xDB	/*                                    FULL BLOCK */,/* 1160 */
/* U+2589 */	CANT_MAP_CHARACTER,	/* 1161 */
/* U+258A */	CANT_MAP_CHARACTER,	/* 1162 */
/* U+258B */	CANT_MAP_CHARACTER,	/* 1163 */
/* U+258C */	CANT_MAP_CHARACTER,	/* 1164 */
/* U+258D */	CANT_MAP_CHARACTER,	/* 1165 */
/* U+258E */	CANT_MAP_CHARACTER,	/* 1166 */
/* U+258F */	CANT_MAP_CHARACTER,	/* 1167 */
/* U+2590 */	CANT_MAP_CHARACTER,	/* 1168 */
/* U+2591 */	0xB0	/*                                   LIGHT SHADE */,/* 1169 */
/* U+2592 */	0xB1	/*                                  MEDIUM SHADE */,/* 1170 */
/* U+2593 */	0xB2	/*                                    DARK SHADE */,/* 1171 */
/* U+2594 */	CANT_MAP_CHARACTER,	/* 1172 */
/* U+2595 */	CANT_MAP_CHARACTER,	/* 1173 */
/* U+2596 */	CANT_MAP_CHARACTER,	/* 1174 */
/* U+2597 */	CANT_MAP_CHARACTER,	/* 1175 */
/* U+2598 */	CANT_MAP_CHARACTER,	/* 1176 */
/* U+2599 */	CANT_MAP_CHARACTER,	/* 1177 */
/* U+259A */	CANT_MAP_CHARACTER,	/* 1178 */
/* U+259B */	CANT_MAP_CHARACTER,	/* 1179 */
/* U+259C */	CANT_MAP_CHARACTER,	/* 1180 */
/* U+259D */	CANT_MAP_CHARACTER,	/* 1181 */
/* U+259E */	CANT_MAP_CHARACTER,	/* 1182 */
/* U+259F */	CANT_MAP_CHARACTER,	/* 1183 */
/* U+25A0 */	0xFE	/*                                  BLACK SQUARE */,/* 1184 */
/* U+25A1 */	CANT_MAP_CHARACTER,	/* 1185 */
/* U+25A2 */	CANT_MAP_CHARACTER,	/* 1186 */
/* U+25A3 */	CANT_MAP_CHARACTER,	/* 1187 */
/* U+25A4 */	CANT_MAP_CHARACTER,	/* 1188 */
/* U+25A5 */	CANT_MAP_CHARACTER,	/* 1189 */
/* U+25A6 */	CANT_MAP_CHARACTER,	/* 1190 */
/* U+25A7 */	CANT_MAP_CHARACTER,	/* 1191 */
/* U+25A8 */	CANT_MAP_CHARACTER,	/* 1192 */
/* U+25A9 */	CANT_MAP_CHARACTER,	/* 1193 */
/* U+25AA */	CANT_MAP_CHARACTER,	/* 1194 */
/* U+25AB */	CANT_MAP_CHARACTER,	/* 1195 */
/* U+25AC */	CANT_MAP_CHARACTER,	/* 1196 */
/* U+25AD */	CANT_MAP_CHARACTER,	/* 1197 */
/* U+25AE */	CANT_MAP_CHARACTER,	/* 1198 */
/* U+25AF */	CANT_MAP_CHARACTER,	/* 1199 */
/* U+25B0 */	CANT_MAP_CHARACTER,	/* 1200 */
/* U+25B1 */	CANT_MAP_CHARACTER,	/* 1201 */
/* U+25B2 */	CANT_MAP_CHARACTER,	/* 1202 */
/* U+25B3 */	CANT_MAP_CHARACTER,	/* 1203 */
/* U+25B4 */	CANT_MAP_CHARACTER,	/* 1204 */
/* U+25B5 */	CANT_MAP_CHARACTER,	/* 1205 */
/* U+25B6 */	CANT_MAP_CHARACTER,	/* 1206 */
/* U+25B7 */	CANT_MAP_CHARACTER,	/* 1207 */
/* U+25B8 */	CANT_MAP_CHARACTER,	/* 1208 */
/* U+25B9 */	CANT_MAP_CHARACTER,	/* 1209 */
/* U+25BA */	CANT_MAP_CHARACTER,	/* 1210 */
/* U+25BB */	CANT_MAP_CHARACTER,	/* 1211 */
/* U+25BC */	CANT_MAP_CHARACTER,	/* 1212 */
/* U+25BD */	CANT_MAP_CHARACTER,	/* 1213 */
/* U+25BE */	CANT_MAP_CHARACTER,	/* 1214 */
/* U+25BF */	CANT_MAP_CHARACTER,	/* 1215 */
/* U+25C0 */	CANT_MAP_CHARACTER,	/* 1216 */
/* U+25C1 */	CANT_MAP_CHARACTER,	/* 1217 */
/* U+25C2 */	CANT_MAP_CHARACTER,	/* 1218 */
/* U+25C3 */	CANT_MAP_CHARACTER,	/* 1219 */
/* U+25C4 */	CANT_MAP_CHARACTER,	/* 1220 */
/* U+25C5 */	CANT_MAP_CHARACTER,	/* 1221 */
/* U+25C6 */	CANT_MAP_CHARACTER,	/* 1222 */
/* U+25C7 */	CANT_MAP_CHARACTER,	/* 1223 */
/* U+25C8 */	CANT_MAP_CHARACTER,	/* 1224 */
/* U+25C9 */	CANT_MAP_CHARACTER,	/* 1225 */
/* U+25CA */	CANT_MAP_CHARACTER,	/* 1226 */
/* U+25CB */	CANT_MAP_CHARACTER,	/* 1227 */
/* U+25CC */	CANT_MAP_CHARACTER,	/* 1228 */
/* U+25CD */	CANT_MAP_CHARACTER,	/* 1229 */
/* U+25CE */	CANT_MAP_CHARACTER,	/* 1230 */
/* U+25CF */	CANT_MAP_CHARACTER,	/* 1231 */
/* U+25D0 */	CANT_MAP_CHARACTER,	/* 1232 */
/* U+25D1 */	CANT_MAP_CHARACTER,	/* 1233 */
/* U+25D2 */	CANT_MAP_CHARACTER,	/* 1234 */
/* U+25D3 */	CANT_MAP_CHARACTER,	/* 1235 */
/* U+25D4 */	CANT_MAP_CHARACTER,	/* 1236 */
/* U+25D5 */	CANT_MAP_CHARACTER,	/* 1237 */
/* U+25D6 */	CANT_MAP_CHARACTER,	/* 1238 */
/* U+25D7 */	CANT_MAP_CHARACTER,	/* 1239 */
/* U+25D8 */	CANT_MAP_CHARACTER,	/* 1240 */
/* U+25D9 */	CANT_MAP_CHARACTER,	/* 1241 */
/* U+25DA */	CANT_MAP_CHARACTER,	/* 1242 */
/* U+25DB */	CANT_MAP_CHARACTER,	/* 1243 */
/* U+25DC */	CANT_MAP_CHARACTER,	/* 1244 */
/* U+25DD */	CANT_MAP_CHARACTER,	/* 1245 */
/* U+25DE */	CANT_MAP_CHARACTER,	/* 1246 */
/* U+25DF */	CANT_MAP_CHARACTER,	/* 1247 */
/* U+25E0 */	CANT_MAP_CHARACTER,	/* 1248 */
/* U+25E1 */	CANT_MAP_CHARACTER,	/* 1249 */
/* U+25E2 */	CANT_MAP_CHARACTER,	/* 1250 */
/* U+25E3 */	CANT_MAP_CHARACTER,	/* 1251 */
/* U+25E4 */	CANT_MAP_CHARACTER,	/* 1252 */
/* U+25E5 */	CANT_MAP_CHARACTER,	/* 1253 */
/* U+25E6 */	CANT_MAP_CHARACTER,	/* 1254 */
/* U+25E7 */	CANT_MAP_CHARACTER,	/* 1255 */
/* U+25E8 */	CANT_MAP_CHARACTER,	/* 1256 */
/* U+25E9 */	CANT_MAP_CHARACTER,	/* 1257 */
/* U+25EA */	CANT_MAP_CHARACTER,	/* 1258 */
/* U+25EB */	CANT_MAP_CHARACTER,	/* 1259 */
/* U+25EC */	CANT_MAP_CHARACTER,	/* 1260 */
/* U+25ED */	CANT_MAP_CHARACTER,	/* 1261 */
/* U+25EE */	CANT_MAP_CHARACTER,	/* 1262 */
/* U+25EF */	CANT_MAP_CHARACTER,	/* 1263 */
/* U+25F0 */	CANT_MAP_CHARACTER,	/* 1264 */
/* U+25F1 */	CANT_MAP_CHARACTER,	/* 1265 */
/* U+25F2 */	CANT_MAP_CHARACTER,	/* 1266 */
/* U+25F3 */	CANT_MAP_CHARACTER,	/* 1267 */
/* U+25F4 */	CANT_MAP_CHARACTER,	/* 1268 */
/* U+25F5 */	CANT_MAP_CHARACTER,	/* 1269 */
/* U+25F6 */	CANT_MAP_CHARACTER,	/* 1270 */
/* U+25F7 */	CANT_MAP_CHARACTER,	/* 1271 */
/* U+25F8 */	CANT_MAP_CHARACTER,	/* 1272 */
/* U+25F9 */	CANT_MAP_CHARACTER,	/* 1273 */
/* U+25FA */	CANT_MAP_CHARACTER,	/* 1274 */
/* U+25FB */	CANT_MAP_CHARACTER,	/* 1275 */
/* U+25FC */	CANT_MAP_CHARACTER,	/* 1276 */
/* U+25FD */	CANT_MAP_CHARACTER,	/* 1277 */
/* U+25FE */	CANT_MAP_CHARACTER,	/* 1278 */
/* U+25FF */	CANT_MAP_CHARACTER,	/* 1279 */
	0 /* END OF MAP TABLE */
};
static const USHORT from_unicode_map[256] = {
/* U+00-- */	256,
/* U+01-- */	0,
/* U+02-- */	0,
/* U+03-- */	512,
/* U+04-- */	0,
/* U+05-- */	0,
/* U+06-- */	0,
/* U+07-- */	0,
/* U+08-- */	0,
/* U+09-- */	0,
/* U+0A-- */	0,
/* U+0B-- */	0,
/* U+0C-- */	0,
/* U+0D-- */	0,
/* U+0E-- */	0,
/* U+0F-- */	0,
/* U+10-- */	0,
/* U+11-- */	0,
/* U+12-- */	0,
/* U+13-- */	0,
/* U+14-- */	0,
/* U+15-- */	0,
/* U+16-- */	0,
/* U+17-- */	0,
/* U+18-- */	0,
/* U+19-- */	0,
/* U+1A-- */	0,
/* U+1B-- */	0,
/* U+1C-- */	0,
/* U+1D-- */	0,
/* U+1E-- */	0,
/* U+1F-- */	0,
/* U+20-- */	768,
/* U+21-- */	0,
/* U+22-- */	0,
/* U+23-- */	0,
/* U+24-- */	0,
/* U+25-- */	1024,
/* U+26-- */	0,
/* U+27-- */	0,
/* U+28-- */	0,
/* U+29-- */	0,
/* U+2A-- */	0,
/* U+2B-- */	0,
/* U+2C-- */	0,
/* U+2D-- */	0,
/* U+2E-- */	0,
/* U+2F-- */	0,
/* U+30-- */	0,
/* U+31-- */	0,
/* U+32-- */	0,
/* U+33-- */	0,
/* U+34-- */	0,
/* U+35-- */	0,
/* U+36-- */	0,
/* U+37-- */	0,
/* U+38-- */	0,
/* U+39-- */	0,
/* U+3A-- */	0,
/* U+3B-- */	0,
/* U+3C-- */	0,
/* U+3D-- */	0,
/* U+3E-- */	0,
/* U+3F-- */	0,
/* U+40-- */	0,
/* U+41-- */	0,
/* U+42-- */	0,
/* U+43-- */	0,
/* U+44-- */	0,
/* U+45-- */	0,
/* U+46-- */	0,
/* U+47-- */	0,
/* U+48-- */	0,
/* U+49-- */	0,
/* U+4A-- */	0,
/* U+4B-- */	0,
/* U+4C-- */	0,
/* U+4D-- */	0,
/* U+4E-- */	0,
/* U+4F-- */	0,
/* U+50-- */	0,
/* U+51-- */	0,
/* U+52-- */	0,
/* U+53-- */	0,
/* U+54-- */	0,
/* U+55-- */	0,
/* U+56-- */	0,
/* U+57-- */	0,
/* U+58-- */	0,
/* U+59-- */	0,
/* U+5A-- */	0,
/* U+5B-- */	0,
/* U+5C-- */	0,
/* U+5D-- */	0,
/* U+5E-- */	0,
/* U+5F-- */	0,
/* U+60-- */	0,
/* U+61-- */	0,
/* U+62-- */	0,
/* U+63-- */	0,
/* U+64-- */	0,
/* U+65-- */	0,
/* U+66-- */	0,
/* U+67-- */	0,
/* U+68-- */	0,
/* U+69-- */	0,
/* U+6A-- */	0,
/* U+6B-- */	0,
/* U+6C-- */	0,
/* U+6D-- */	0,
/* U+6E-- */	0,
/* U+6F-- */	0,
/* U+70-- */	0,
/* U+71-- */	0,
/* U+72-- */	0,
/* U+73-- */	0,
/* U+74-- */	0,
/* U+75-- */	0,
/* U+76-- */	0,
/* U+77-- */	0,
/* U+78-- */	0,
/* U+79-- */	0,
/* U+7A-- */	0,
/* U+7B-- */	0,
/* U+7C-- */	0,
/* U+7D-- */	0,
/* U+7E-- */	0,
/* U+7F-- */	0,
/* U+80-- */	0,
/* U+81-- */	0,
/* U+82-- */	0,
/* U+83-- */	0,
/* U+84-- */	0,
/* U+85-- */	0,
/* U+86-- */	0,
/* U+87-- */	0,
/* U+88-- */	0,
/* U+89-- */	0,
/* U+8A-- */	0,
/* U+8B-- */	0,
/* U+8C-- */	0,
/* U+8D-- */	0,
/* U+8E-- */	0,
/* U+8F-- */	0,
/* U+90-- */	0,
/* U+91-- */	0,
/* U+92-- */	0,
/* U+93-- */	0,
/* U+94-- */	0,
/* U+95-- */	0,
/* U+96-- */	0,
/* U+97-- */	0,
/* U+98-- */	0,
/* U+99-- */	0,
/* U+9A-- */	0,
/* U+9B-- */	0,
/* U+9C-- */	0,
/* U+9D-- */	0,
/* U+9E-- */	0,
/* U+9F-- */	0,
/* U+A0-- */	0,
/* U+A1-- */	0,
/* U+A2-- */	0,
/* U+A3-- */	0,
/* U+A4-- */	0,
/* U+A5-- */	0,
/* U+A6-- */	0,
/* U+A7-- */	0,
/* U+A8-- */	0,
/* U+A9-- */	0,
/* U+AA-- */	0,
/* U+AB-- */	0,
/* U+AC-- */	0,
/* U+AD-- */	0,
/* U+AE-- */	0,
/* U+AF-- */	0,
/* U+B0-- */	0,
/* U+B1-- */	0,
/* U+B2-- */	0,
/* U+B3-- */	0,
/* U+B4-- */	0,
/* U+B5-- */	0,
/* U+B6-- */	0,
/* U+B7-- */	0,
/* U+B8-- */	0,
/* U+B9-- */	0,
/* U+BA-- */	0,
/* U+BB-- */	0,
/* U+BC-- */	0,
/* U+BD-- */	0,
/* U+BE-- */	0,
/* U+BF-- */	0,
/* U+C0-- */	0,
/* U+C1-- */	0,
/* U+C2-- */	0,
/* U+C3-- */	0,
/* U+C4-- */	0,
/* U+C5-- */	0,
/* U+C6-- */	0,
/* U+C7-- */	0,
/* U+C8-- */	0,
/* U+C9-- */	0,
/* U+CA-- */	0,
/* U+CB-- */	0,
/* U+CC-- */	0,
/* U+CD-- */	0,
/* U+CE-- */	0,
/* U+CF-- */	0,
/* U+D0-- */	0,
/* U+D1-- */	0,
/* U+D2-- */	0,
/* U+D3-- */	0,
/* U+D4-- */	0,
/* U+D5-- */	0,
/* U+D6-- */	0,
/* U+D7-- */	0,
/* U+D8-- */	0,
/* U+D9-- */	0,
/* U+DA-- */	0,
/* U+DB-- */	0,
/* U+DC-- */	0,
/* U+DD-- */	0,
/* U+DE-- */	0,
/* U+DF-- */	0,
/* U+E0-- */	0,
/* U+E1-- */	0,
/* U+E2-- */	0,
/* U+E3-- */	0,
/* U+E4-- */	0,
/* U+E5-- */	0,
/* U+E6-- */	0,
/* U+E7-- */	0,
/* U+E8-- */	0,
/* U+E9-- */	0,
/* U+EA-- */	0,
/* U+EB-- */	0,
/* U+EC-- */	0,
/* U+ED-- */	0,
/* U+EE-- */	0,
/* U+EF-- */	0,
/* U+F0-- */	0,
/* U+F1-- */	0,
/* U+F2-- */	0,
/* U+F3-- */	0,
/* U+F4-- */	0,
/* U+F5-- */	0,
/* U+F6-- */	0,
/* U+F7-- */	0,
/* U+F8-- */	0,
/* U+F9-- */	0,
/* U+FA-- */	0,
/* U+FB-- */	0,
/* U+FC-- */	0,
/* U+FD-- */	0,
/* U+FE-- */	0,
/* U+FF-- */	0,
};
