(** OCaml record field. *)

(* ['record] is the type of the record.  ['field] is the type of the values stored in the
   record field with name [name]. *)
type ('record, 'field) t = {
  name : string;
  setter : ('record -> 'field -> unit) option;
  getter : ('record -> 'field);
}

let name f = f.name

let get f r = f.getter r

let setter f = f.setter
