# FIAIF is an Intelligent firewall
#
# description: Automates a packet filtering firewall with iptables.
#
# Script Author: Anders Fugmann <afu at fugmann dot net>
# 
# FIAIF is an Intelligent firewall
# Copyright (C) 2002-2011 Anders Peter Fugmann
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

###############################################################################
# Main function. Calls awk script to get a list
# of iptables calls to clean_up rules.
###############################################################################
function cleanup_rules ()
{
    local FILE=$(mktemp /tmp/fiaif-cleanup.XXXXXX)
    local COMMAND
    
    for TABLE in ${TABLES}; do
	iptables-save -t ${TABLE} | awk -f ${FIAIF_SHARED}/cleanup_rules.awk -v TABLE=${TABLE} >> ${FILE}
    done

    cat ${FILE} | while read COMMAND; do
	if [[ -n "${COMMAND%%#*}" ]]; then  
	    ${COMMAND} || echo "Error: ${COMMAND}"
	else
	    echo "${COMMAND}"
	fi
    done
    rm -f ${FILE}
}
