/* Please read the file README !
   This is Fefe's finger daemon, the current version is available from
     ftp://ftp.fu-berlin.de/pub/unix/security/ffingerd/
   There is a home page for this finger daemon, too, the URL is
     http://www.fefe.de/ffingerd/ */

#include <config.h>

#include <stdio.h>

#ifndef HAVE_STRCHR
# ifdef HAVE_INDEX
#  define strchr index
# else
error "No string processing available. Get a Real OS[TM]"
# endif
#endif

#ifdef STDC_HEADERS
# include <string.h>
#else
# ifdef HAVE_STRINGS_H
#  include <strings.h>
# else
char *strchr ();
# endif
#endif
#include <stdlib.h>

#ifdef HAVE_UNISTD_H
# include <unistd.h>
# include <sys/types.h>
#endif

#include <sys/socket.h>
#include <netinet/in.h>
#ifdef HAVE_ARPA_INET_H
#include <arpa/inet.h>
#endif
#include <pwd.h>
#include <netdb.h>
#include <sys/stat.h>

#ifdef HAVE_SYSLOG_H
# include <syslog.h>
#else
# ifdef HAVE_SYS_SYSLOG_H
#  include <sys/syslog.h>
# else
#  ifdef HAVE_SYSLOG
void openlog();
void syslog();
void closelog();
#  else
#   define NO_SYSLOG
#  endif 
# endif
#endif

#ifdef DAEMONTOLS
#define NO_SYSLOG
#endif

#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif
#ifdef HAVE_SYS_ERRNO_H
#include <sys/errno.h>
#endif

#ifndef PATH_MAX
#define PATH_MAX 256
#endif

#ifdef __STDC__
void dump_file(char *filename,char *found_message,char *not_found_message) {
#else
void dump_file(filename, found_message, not_found_message) 
  char *filename;
  char *found_message;
  char *not_found_message;
{
#endif
  FILE *file;
  char line[256];
  struct stat stat_buf;

  if (lstat(filename,&stat_buf)) {
    puts(not_found_message);
  } else {
    if (S_ISLNK(stat_buf.st_mode)) {
      char message[1200],linkdest[255];
      int i;
      if ((i=readlink(filename,linkdest,254)) != -1) {
	linkdest[i]=0;
      } else {
	linkdest[0]='\0';
      }
#ifndef NO_SYSLOG
      sprintf(message,"file \"%.512s\" is a symbolic link to \"%.512s\"!\n",filename,linkdest);
      syslog(LOG_FACILITY,"%s",message);
#endif
#ifdef DAEMONTOOLS
      fprintf(stderr,"file \"%s\" is a symbolic link to \"%s\"!\n",filename,linkdest);
#endif /* DAEMONTOOLS */
      puts(not_found_message);
    } else if (S_ISREG(stat_buf.st_mode)) {
      puts(found_message);
      if ((file=fopen(filename,"r"))) {
	for (;;) {
	  if (fgets(line,255,file)) {
	    fputs(line,stdout);
	  } else {
	    break;
	  }
	}
	fclose(file);
      }
    } else {
      puts(not_found_message);
    }
  }
}

#ifdef NEXT
#define S_ISREG(x) (x & S_IFREG)
#endif

#ifdef __STDC__
void dump_user(struct passwd *pwd,unsigned char *remote) {
#else
void dump_user(pwd,remote)
struct passwd *pwd;
unsigned char *remote;
{
#endif
  char filename[PATH_MAX+20];
  struct stat stat_buf;

  setgid(pwd->pw_gid);
  setuid(pwd->pw_uid);
#if PATH_MAX < 256
#error PATH_MAX is too small
#endif
  sprintf(filename,"%.256s/.nofinger",pwd->pw_dir);
  if (lstat(filename,&stat_buf) && (errno==ENOENT)) {
#ifndef NO_SYSLOG
#ifdef FASCIST_LOGGING
    char message[1500];
    sprintf(message,"finger \"%.256s\" from %.1076s\n",pwd->pw_name,remote);
    syslog(LOG_FACILITY,"%s",message);
#endif
#endif
#ifdef DAEMONTOOLS
#ifdef FASCIST_LOGGING
    fprintf(stderr, "finger \"%s\" from %s\n",pwd->pw_name,remote);
#endif /* FASCIST_LOGGING */
#endif /* DAEMONTOOLS */
    sprintf(filename,"%.256s",pwd->pw_gecos);
    if (strchr(filename,',')) { *(char *)strchr(filename,',')=0; }
    printf("Login: %-30s  Name: %-40s\n",pwd->pw_name,filename);
    sprintf(filename,"%.256s/.project",pwd->pw_dir);
    dump_file(filename,"Project:","No project.");
    sprintf(filename,"%.256s/.plan",pwd->pw_dir);
    dump_file(filename,"Plan:","No plan.");
    sprintf(filename,"%.256s/.pubkey",pwd->pw_dir);
    dump_file(filename,"Public key:","No public key.");
  } else {
#ifndef NO_SYSLOG
    char message[1500];
    sprintf(message,"attempt to finger \"%.256s\" from %.1076s\n",pwd->pw_name,remote);
    syslog(LOG_FACILITY,"%s",message);
#endif
#ifdef DAEMONTOOLS
    fprintf(stderr,"attempt to finger \"%s\" from %s\n",pwd->pw_name,remote);
#endif /* DAEMONTOOLS */
    puts("That user does not want to be fingered.");
  }
}

int main()
{
  char message[1435];
  unsigned char query[256];
  unsigned char *qptr;
#ifdef INET6
  struct sockaddr_storage name;
  char RemoteH[513], Remote_IP[40];
#else /* INET6 */
  struct sockaddr_in name;
#ifdef HAVE_INET_NTOA
  char *Remote_IP;
#else
  char Remote_IP[40];
#endif
  struct hostent *host;
#endif /* INET6 */
  int len;
  unsigned long remote;
  char Remote[1077];
  struct passwd *pwd;
#ifdef DAEMONTOOLS
  char RemoteInfo[516];
  char *c;
#endif

  if(geteuid() == 0) {
#ifndef NO_SYSLOG
    syslog(LOG_FACILITY,"ffingerd refuses to run as root");
#endif
    fprintf(stderr, "ffingerd refuses to run as root\n");
    printf("Temporary out of service\n");
    exit(1);
  }

#ifndef DAEMONTOOLS 
  openlog("ffingerd",LOG_PID,LOG_DAEMON);
  len=sizeof(name);
  if (getpeername(0, (struct sockaddr *)&name,&len) == -1) {
/*    perror("getpeername"); */
    if (errno==ENOTSOCK) {
      remote=0x7f000001;
    } else {
      syslog(LOG_ERR,"getpeername: %m");
      closelog();
      exit(0);
    }
  } else {
#ifdef INET6
    if ((name.__ss_family != AF_INET) && (name.__ss_family != AF_INET6)) {
#else
    if (name.sin_family != AF_INET) {
#endif
      syslog(LOG_ERR,"Connection not from INET domain ?!");
      closelog();
      exit(0);
    }
#ifndef INET6
    remote=ntohl(name.sin_addr.s_addr);
#ifdef HAVE_INET_NTOA
    Remote_IP=inet_ntoa(name.sin_addr);
#else
    sprintf(Remote_IP, "%.3ld.%.3ld.%.3ld.%.3ld",
	    remote>>24 & 255,remote>>16 & 255,
	    remote>>8 & 255,remote & 255);
#endif
    if ((host=gethostbyaddr((char *)&name.sin_addr,sizeof(struct in_addr),AF_INET))) {
      sprintf(Remote, "%.512s [%.15s]",host->h_name,Remote_IP);
    } else {
      /*      perror("gethostbyaddr");*/
      sprintf(Remote, "%.15s [%.15s]",Remote_IP,Remote_IP);
#else /* INET6 */
       getnameinfo((struct sockaddr *)&name,
#ifdef SIN6_LEN
		       name->ss_len,
#else
		       SA_LEN((struct sockaddr *)&name),
#endif
		     Remote_IP, sizeof(Remote_IP), NULL, 0, NI_NUMERICHOST);
       if (getnameinfo((struct sockaddr *)&name,
#ifdef SIN6_LEN
		       name->ss_len,
#else
		       SA_LEN((struct sockaddr *)&name),
#endif
		       RemoteH, sizeof(RemoteH), NULL, 0, 0) == 0) {
	 sprintf(Remote,"%.512s [%.39s]",RemoteH,Remote_IP);
    } else {
      sprintf(Remote,"%.39s [%.39s]",Remote_IP,Remote_IP);
#endif /* INET6 */
    }
  }
#else /* DAEMONTOOLS */
    if((c = getenv("TCPREMOTEHOST")) != NULL) {
      sprintf(Remote, "%.512s [%.39s:%.5s]", c, 
	       getenv("TCPREMOTEIP"),
	       getenv("TCPREMOTEPORT"));
    } else {
      sprintf(Remote,"%.39s [%.39s:%.5s]", 
	      getenv("TCPREMOTEIP"),
	      getenv("TCPREMOTEIP"),
	      getenv("TCPREMOTEPORT"));
    }
    
    if((c = getenv("TCPREMOTEINFO")) != NULL) {
      sprintf(RemoteInfo," (%.512s)", c);
      strncat(Remote, RemoteInfo, sizeof(Remote)-strlen(Remote)-1);
    }
#endif /* DAEMONTOOLS */

  if (!fgets(query,255,stdin)) {
#ifndef NO_SYSLOG
    syslog(LOG_FACILITY,"fgets failed");
    closelog();
#endif
#ifdef DAEMONTOOLS
    perror("fgets failed");
#endif /* DAEMONTOOLS */
    exit(1);    
  }

  for (len = 0; query[len]; len++) {
    if (query[len] == '\r' || query[len] == '\n') {
      query[len] = '\0';
      break;
    }
  }    

  if (strchr(query, '@') != NULL) {
#ifndef NO_SYSLOG
    sprintf(message,"indirect finger attempt at %.255s from %.1076s\n",query,Remote);
    syslog(LOG_FACILITY,"%s",message);
    closelog();
#endif
#ifdef DAEMONTOOLS
    fprintf( stderr, "indirect finger attempt at %s from %s\n",query,Remote);
#endif /* DAEMONTOOLS */
    puts("Sorry, we do not support indirect finger queries.");
    exit(0);
  }
  
  qptr=query;
  if (*qptr==' ') qptr++;
  if (*qptr=='/' && (*(qptr+1)=='W' || *(qptr+1)=='w')) qptr+=2;
  if (*qptr==' ') qptr++;
  if (*qptr==0) {
#ifndef NO_SYSLOG
    sprintf(message,"empty finger attempt from %.1076s\n",Remote);
    syslog(LOG_FACILITY,"%s",message);
    closelog();
#endif
#ifdef DAEMONTOOLS
    fprintf(stderr, "empty finger attempt from %s\n",Remote);
#endif /* DAEMONTOOLS */
    puts("Sorry, we do not support empty finger queries.");
    exit(0);
  }
  if ((pwd=getpwnam(qptr))) {
    dump_user(pwd,(unsigned char*)Remote);
  } else {
#ifndef NO_SYSLOG
    sprintf(message,"attempt to finger \"%.255s\" from %.1076s\n",qptr,Remote);
    syslog(LOG_FACILITY,"%s",message);
#endif
#ifdef DAEMONTOOLS
    fprintf(stderr,"attempt to finger \"%s\" from %s\n",qptr,Remote);
#endif /* DAEMONTOOLS */
    puts("That user does not want to be fingered.");
  }
#ifndef NO_SYSLOG
  closelog();
#endif
  return 0;
}
