/*
 *    ffe - flat file extractor
 *
 *    Copyright (C) 2006 Timo Savinen
 *    This file is part of ffe.
 * 
 *    ffe is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    ffe is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with ffe; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* $Id: xmalloc.c,v 1.6 2007-04-09 16:57:40 timo Exp $ */

#include "ffe.h"
#include <stdlib.h>
#include <string.h>
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

void *
xmalloc (size_t size)
{
    register void *value = malloc(size);
    if (value == NULL) panic("Out of memory",NULL,NULL);
    return value;
}

char *
xstrdup(char *str)
{
    register char *ret = strdup(str);
    if (ret == NULL) panic("Out of memory",NULL,NULL);
    return ret;
}

void *
xrealloc (void *ptr, size_t size)
{
    register void *value = realloc(ptr,size);
    if (value == NULL) panic("Out of memory",NULL,NULL);
    return value;
}
