// This code conforms with the UFC specification version 2.2.0
// and was automatically generated by FFC version 1.2.0.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: True
//   cpp_optimize:                   False
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'ufc'
//   log_level:                      20
//   log_prefix:                     ''
//   optimize:                       False
//   output_dir:                     '.'
//   precision:                      '8'
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   split:                          False
//   swig_binary:                    'swig'
//   swig_path:                      ''

#ifndef __PROJECTIONMANIFOLD_H
#define __PROJECTIONMANIFOLD_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class projectionmanifold_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  projectionmanifold_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~projectionmanifold_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Raviart-Thomas', Domain(Cell('triangle', 3), 'triangle_multiverse', 3, 2), 1, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual std::size_t topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual std::size_t geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the finite element function space
  virtual std::size_t space_dimension() const
  {
    return 3;
  }

  /// Return the rank of the value space
  virtual std::size_t value_rank() const
  {
    return 1;
  }

  /// Return the dimension of the value space for axis i
  virtual std::size_t value_dimension(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      {
        return 3;
        break;
      }
    }
    
    return 0;
  }

  /// Evaluate basis function i at given point x in cell
  virtual void evaluate_basis(std::size_t i,
                              double* values,
                              const double* x,
                              const double* vertex_coordinates,
                              int cell_orientation) const
  {
    // Compute Jacobian
    double J[6];
    compute_jacobian_triangle_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[6];
    double detJ;
    compute_jacobian_inverse_triangle_3d(K, detJ, J);
    
    
    // Check orientation
    if (cell_orientation == -1)
      throw std::runtime_error("cell orientation must be defined (not -1)");
    // (If cell_orientation == 1 = down, multiply det(J) by -1)
    else if (cell_orientation == 1)
      detJ *= -1;
    
    
    const double b0 = vertex_coordinates[0];
    const double b1 = vertex_coordinates[1];
    const double b2 = vertex_coordinates[2];
    
    // P_FFC = J^dag (p - b), P_FIAT = 2*P_FFC - (1, 1)
    double X = 2*(K[0]*(x[0] - b0) + K[1]*(x[1] - b1) + K[2]*(x[2] - b2)) - 1.0;
    double Y = 2*(K[3]*(x[0] - b0) + K[4]*(x[1] - b1) + K[5]*(x[2] - b2)) - 1.0;
    
    
    // Reset values
    values[0] = 0.0;
    values[1] = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.47140452, 0.28867513, -0.16666667};
      
      static const double coefficients1[3] = \
      {0.47140452, 0.0, 0.33333333};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using contravariant Piola transform to map values back to the physical element
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (1.0/detJ)*(J[0]*tmp_ref0 + J[1]*tmp_ref1);
      values[1] = (1.0/detJ)*(J[2]*tmp_ref0 + J[3]*tmp_ref1);
      values[2] = (1.0/detJ)*(J[4]*tmp_ref0 + J[5]*tmp_ref1);
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.94280904, -0.28867513, 0.16666667};
      
      static const double coefficients1[3] = \
      {-0.47140452, 0.0, -0.33333333};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using contravariant Piola transform to map values back to the physical element
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (1.0/detJ)*(J[0]*tmp_ref0 + J[1]*tmp_ref1);
      values[1] = (1.0/detJ)*(J[2]*tmp_ref0 + J[3]*tmp_ref1);
      values[2] = (1.0/detJ)*(J[4]*tmp_ref0 + J[5]*tmp_ref1);
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.47140452, 0.28867513, -0.16666667};
      
      static const double coefficients1[3] = \
      {-0.94280904, 0.0, 0.33333333};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using contravariant Piola transform to map values back to the physical element
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (1.0/detJ)*(J[0]*tmp_ref0 + J[1]*tmp_ref1);
      values[1] = (1.0/detJ)*(J[2]*tmp_ref0 + J[3]*tmp_ref1);
      values[2] = (1.0/detJ)*(J[4]*tmp_ref0 + J[5]*tmp_ref1);
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point x in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* x,
                                  const double* vertex_coordinates,
                                  int cell_orientation) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values[3] = {0.0, 0.0, 0.0};
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 3; r++)
    {
      evaluate_basis(r, dof_values, x, vertex_coordinates, cell_orientation);
      for (unsigned int s = 0; s < 3; s++)
      {
        values[r*3 + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point x in cell
  virtual void evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double* values,
                                          const double* x,
                                          const double* vertex_coordinates,
                                          int cell_orientation) const
  {
    // Compute Jacobian
    double J[6];
    compute_jacobian_triangle_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[6];
    double detJ;
    compute_jacobian_inverse_triangle_3d(K, detJ, J);
    
    
    // Check orientation
    if (cell_orientation == -1)
      throw std::runtime_error("cell orientation must be defined (not -1)");
    // (If cell_orientation == 1 = down, multiply det(J) by -1)
    else if (cell_orientation == 1)
      detJ *= -1;
    
    
    const double b0 = vertex_coordinates[0];
    const double b1 = vertex_coordinates[1];
    const double b2 = vertex_coordinates[2];
    
    // P_FFC = J^dag (p - b), P_FIAT = 2*P_FFC - (1, 1)
    double X = 2*(K[0]*(x[0] - b0) + K[1]*(x[1] - b1) + K[2]*(x[2] - b2)) - 1.0;
    double Y = 2*(K[3]*(x[0] - b0) + K[4]*(x[1] - b1) + K[5]*(x[2] - b2)) - 1.0;
    
    
    // Compute number of derivatives.
    unsigned int num_derivatives_t = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives_t *= 2;
    }// end loop over 'r'
    
    // Compute number of derivatives.
    unsigned int num_derivatives_g = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives_g *= 3;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations_t = new unsigned int *[num_derivatives_t];
    for (unsigned int row = 0; row < num_derivatives_t; row++)
    {
      combinations_t[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations_t[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives_t; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations_t[row][col] + 1 > 1)
            combinations_t[row][col] = 0;
          else
          {
            combinations_t[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations_g = new unsigned int *[num_derivatives_g];
    for (unsigned int row = 0; row < num_derivatives_g; row++)
    {
      combinations_g[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations_g[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives_g; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations_g[row][col] + 1 > 2)
            combinations_g[row][col] = 0;
          else
          {
            combinations_g[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][3] = {{K[0], K[1], K[2]}, {K[3], K[4], K[5]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives_g];
    
    for (unsigned int j = 0; j < num_derivatives_g; j++)
    {
      transform[j] = new double [num_derivatives_t];
      for (unsigned int k = 0; k < num_derivatives_t; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives_g; row++)
    {
      for (unsigned int col = 0; col < num_derivatives_t; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations_t[col][k]][combinations_g[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < 3*num_derivatives_g; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.47140452, 0.28867513, -0.16666667};
      
      static const double coefficients1[3] = \
      {0.47140452, 0.0, 0.33333333};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.8989795, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.4494897, 0.0, 0.0},
      {4.2426407, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[2*num_derivatives_t];
      for (unsigned int r = 0; r < 2*num_derivatives_t; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare pointer to array of reference derivatives on physical element.
      double *derivatives_p = new double[3*num_derivatives_t];
      for (unsigned int r = 0; r < 3*num_derivatives_t; r++)
      {
        derivatives_p[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives_t; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations_t[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations_t[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives_t + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using contravariant Piola transform to map values back to the physical element.
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives_t + r];
        derivatives_p[r] = (1.0/detJ)*(J[0]*tmp_ref0 + J[1]*tmp_ref1);
        derivatives_p[num_derivatives_t + r] = (1.0/detJ)*(J[2]*tmp_ref0 + J[3]*tmp_ref1);
        derivatives_p[2*num_derivatives_t + r] = (1.0/detJ)*(J[4]*tmp_ref0 + J[5]*tmp_ref1);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives_g; r++)
      {
        for (unsigned int s = 0; s < num_derivatives_t; s++)
        {
          values[r] += transform[r][s]*derivatives_p[s];
          values[num_derivatives_g + r] += transform[r][s]*derivatives_p[num_derivatives_t + s];
          values[2*num_derivatives_g + r] += transform[r][s]*derivatives_p[2*num_derivatives_t + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of reference derivatives on physical element.
      delete [] derivatives_p;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives_t; r++)
      {
        delete [] combinations_t[r];
      }// end loop over 'r'
      delete [] combinations_t;
      for (unsigned int r = 0; r < num_derivatives_g; r++)
      {
        delete [] combinations_g[r];
      }// end loop over 'r'
      delete [] combinations_g;
      for (unsigned int r = 0; r < num_derivatives_g; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.94280904, -0.28867513, 0.16666667};
      
      static const double coefficients1[3] = \
      {-0.47140452, 0.0, -0.33333333};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.8989795, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.4494897, 0.0, 0.0},
      {4.2426407, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[2*num_derivatives_t];
      for (unsigned int r = 0; r < 2*num_derivatives_t; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare pointer to array of reference derivatives on physical element.
      double *derivatives_p = new double[3*num_derivatives_t];
      for (unsigned int r = 0; r < 3*num_derivatives_t; r++)
      {
        derivatives_p[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives_t; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations_t[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations_t[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives_t + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using contravariant Piola transform to map values back to the physical element.
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives_t + r];
        derivatives_p[r] = (1.0/detJ)*(J[0]*tmp_ref0 + J[1]*tmp_ref1);
        derivatives_p[num_derivatives_t + r] = (1.0/detJ)*(J[2]*tmp_ref0 + J[3]*tmp_ref1);
        derivatives_p[2*num_derivatives_t + r] = (1.0/detJ)*(J[4]*tmp_ref0 + J[5]*tmp_ref1);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives_g; r++)
      {
        for (unsigned int s = 0; s < num_derivatives_t; s++)
        {
          values[r] += transform[r][s]*derivatives_p[s];
          values[num_derivatives_g + r] += transform[r][s]*derivatives_p[num_derivatives_t + s];
          values[2*num_derivatives_g + r] += transform[r][s]*derivatives_p[2*num_derivatives_t + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of reference derivatives on physical element.
      delete [] derivatives_p;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives_t; r++)
      {
        delete [] combinations_t[r];
      }// end loop over 'r'
      delete [] combinations_t;
      for (unsigned int r = 0; r < num_derivatives_g; r++)
      {
        delete [] combinations_g[r];
      }// end loop over 'r'
      delete [] combinations_g;
      for (unsigned int r = 0; r < num_derivatives_g; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.47140452, 0.28867513, -0.16666667};
      
      static const double coefficients1[3] = \
      {-0.94280904, 0.0, 0.33333333};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.8989795, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.4494897, 0.0, 0.0},
      {4.2426407, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[2*num_derivatives_t];
      for (unsigned int r = 0; r < 2*num_derivatives_t; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare pointer to array of reference derivatives on physical element.
      double *derivatives_p = new double[3*num_derivatives_t];
      for (unsigned int r = 0; r < 3*num_derivatives_t; r++)
      {
        derivatives_p[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives_t; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations_t[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations_t[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives_t + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using contravariant Piola transform to map values back to the physical element.
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives_t + r];
        derivatives_p[r] = (1.0/detJ)*(J[0]*tmp_ref0 + J[1]*tmp_ref1);
        derivatives_p[num_derivatives_t + r] = (1.0/detJ)*(J[2]*tmp_ref0 + J[3]*tmp_ref1);
        derivatives_p[2*num_derivatives_t + r] = (1.0/detJ)*(J[4]*tmp_ref0 + J[5]*tmp_ref1);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives_g; r++)
      {
        for (unsigned int s = 0; s < num_derivatives_t; s++)
        {
          values[r] += transform[r][s]*derivatives_p[s];
          values[num_derivatives_g + r] += transform[r][s]*derivatives_p[num_derivatives_t + s];
          values[2*num_derivatives_g + r] += transform[r][s]*derivatives_p[2*num_derivatives_t + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of reference derivatives on physical element.
      delete [] derivatives_p;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives_t; r++)
      {
        delete [] combinations_t[r];
      }// end loop over 'r'
      delete [] combinations_t;
      for (unsigned int r = 0; r < num_derivatives_g; r++)
      {
        delete [] combinations_g[r];
      }// end loop over 'r'
      delete [] combinations_g;
      for (unsigned int r = 0; r < num_derivatives_g; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point x in cell
  virtual void evaluate_basis_derivatives_all(std::size_t n,
                                              double* values,
                                              const double* x,
                                              const double* vertex_coordinates,
                                              int cell_orientation) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives_g = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives_g *= 3;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[3*num_derivatives_g];
    for (unsigned int r = 0; r < 3*num_derivatives_g; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 3; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, x, vertex_coordinates, cell_orientation);
      for (unsigned int s = 0; s < 3*num_derivatives_g; s++)
      {
        values[r*3*num_derivatives_g + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(std::size_t i,
                              const ufc::function& f,
                              const double* vertex_coordinates,
                              int cell_orientation,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation
    double vals[3];
    
    // Declare variable for physical coordinates
    double y[3];
    
    double result;
    // Compute Jacobian
    double J[6];
    compute_jacobian_triangle_3d(J, vertex_coordinates);
    
    
    // Compute Jacobian inverse and determinant
    double K[6];
    double detJ;
    compute_jacobian_inverse_triangle_3d(K, detJ, J);
    
    
    
    // Check orientation
    if (cell_orientation == -1)
      throw std::runtime_error("cell orientation must be defined (not -1)");
    // (If cell_orientation == 1 = down, multiply det(J) by -1)
    else if (cell_orientation == 1)
      detJ *= -1;
    switch (i)
    {
    case 0:
      {
        y[0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[6];
      y[1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[7];
      y[2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[8];
      f.evaluate(vals, y, c);
      result = (detJ*(K[0]*vals[0] + K[1]*vals[1] + K[2]*vals[2])) + (detJ*(K[3]*vals[0] + K[4]*vals[1] + K[5]*vals[2]));
      return result;
        break;
      }
    case 1:
      {
        y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[6];
      y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[7];
      y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[8];
      f.evaluate(vals, y, c);
      result = (detJ*(K[0]*vals[0] + K[1]*vals[1] + K[2]*vals[2]));
      return result;
        break;
      }
    case 2:
      {
        y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[3];
      y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[4];
      y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      result = (-1.0)*(detJ*(K[3]*vals[0] + K[4]*vals[1] + K[5]*vals[2]));
      return result;
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const double* vertex_coordinates,
                             int cell_orientation,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation
    double vals[3];
    
    // Declare variable for physical coordinates
    double y[3];
    
    double result;
    // Compute Jacobian
    double J[6];
    compute_jacobian_triangle_3d(J, vertex_coordinates);
    
    
    // Compute Jacobian inverse and determinant
    double K[6];
    double detJ;
    compute_jacobian_inverse_triangle_3d(K, detJ, J);
    
    
    
    // Check orientation
    if (cell_orientation == -1)
      throw std::runtime_error("cell orientation must be defined (not -1)");
    // (If cell_orientation == 1 = down, multiply det(J) by -1)
    else if (cell_orientation == 1)
      detJ *= -1;
    y[0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[6];
    y[1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[7];
    y[2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[8];
    f.evaluate(vals, y, c);
    result = (detJ*(K[0]*vals[0] + K[1]*vals[1] + K[2]*vals[2])) + (detJ*(K[3]*vals[0] + K[4]*vals[1] + K[5]*vals[2]));
    values[0] = result;
    y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[6];
    y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[7];
    y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[8];
    f.evaluate(vals, y, c);
    result = (detJ*(K[0]*vals[0] + K[1]*vals[1] + K[2]*vals[2]));
    values[1] = result;
    y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[3];
    y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[4];
    y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    result = (-1.0)*(detJ*(K[3]*vals[0] + K[4]*vals[1] + K[5]*vals[2]));
    values[2] = result;
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const double* vertex_coordinates,
                                         int cell_orientation,
                                         const ufc::cell& c) const
  {
    // Compute Jacobian
    double J[6];
    compute_jacobian_triangle_3d(J, vertex_coordinates);
    
    
    // Compute Jacobian inverse and determinant
    double K[6];
    double detJ;
    compute_jacobian_inverse_triangle_3d(K, detJ, J);
    
    
    
    // Check orientation
    if (cell_orientation == -1)
      throw std::runtime_error("cell orientation must be defined (not -1)");
    // (If cell_orientation == 1 = down, multiply det(J) by -1)
    else if (cell_orientation == 1)
      detJ *= -1;
    
    // Evaluate function and change variables
    vertex_values[0] = dof_values[1]*(1.0/detJ)*J[0] + dof_values[2]*((1.0/detJ)*(J[1]*(-1.0)));
    vertex_values[2] = dof_values[0]*(1.0/detJ)*J[0] + dof_values[2]*((1.0/detJ)*(J[0] + J[1]*(-1.0)));
    vertex_values[4] = dof_values[0]*(1.0/detJ)*J[1] + dof_values[1]*((1.0/detJ)*(J[0] + J[1]*(-1.0)));
    vertex_values[1] = dof_values[1]*(1.0/detJ)*J[2] + dof_values[2]*((1.0/detJ)*(J[3]*(-1.0)));
    vertex_values[3] = dof_values[0]*(1.0/detJ)*J[2] + dof_values[2]*((1.0/detJ)*(J[2] + J[3]*(-1.0)));
    vertex_values[5] = dof_values[0]*(1.0/detJ)*J[3] + dof_values[1]*((1.0/detJ)*(J[2] + J[3]*(-1.0)));
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    std::cerr << "*** FFC warning: " << "map_from_reference_cell not yet implemented." << std::endl;
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    std::cerr << "*** FFC warning: " << "map_to_reference_cell not yet implemented." << std::endl;
  }

  /// Return the number of sub elements (for a mixed element)
  virtual std::size_t num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(std::size_t i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new projectionmanifold_finite_element_0();
  }

};

/// This class defines the interface for a finite element.

class projectionmanifold_finite_element_1: public ufc::finite_element
{
public:

  /// Constructor
  projectionmanifold_finite_element_1() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~projectionmanifold_finite_element_1()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Discontinuous Lagrange', Domain(Cell('triangle', 3), 'triangle_multiverse', 3, 2), 0, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual std::size_t topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual std::size_t geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the finite element function space
  virtual std::size_t space_dimension() const
  {
    return 1;
  }

  /// Return the rank of the value space
  virtual std::size_t value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual std::size_t value_dimension(std::size_t i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point x in cell
  virtual void evaluate_basis(std::size_t i,
                              double* values,
                              const double* x,
                              const double* vertex_coordinates,
                              int cell_orientation) const
  {
    // Compute Jacobian
    double J[6];
    compute_jacobian_triangle_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[6];
    double detJ;
    compute_jacobian_inverse_triangle_3d(K, detJ, J);
    
    
    
    // P_FFC = J^dag (p - b), P_FIAT = 2*P_FFC - (1, 1)
    
    
    // Reset values
    *values = 0.0;
    
    // Array of basisvalues
    double basisvalues[1] = {0.0};
    
    // Declare helper variables
    
    // Compute basisvalues
    basisvalues[0] = 1.0;
    
    // Table(s) of coefficients
    static const double coefficients0[1] = \
    {1.0};
    
    // Compute value(s)
    for (unsigned int r = 0; r < 1; r++)
    {
      *values += coefficients0[r]*basisvalues[r];
    }// end loop over 'r'
  }

  /// Evaluate all basis functions at given point x in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* x,
                                  const double* vertex_coordinates,
                                  int cell_orientation) const
  {
    // Element is constant, calling evaluate_basis.
    evaluate_basis(0, values, x, vertex_coordinates, cell_orientation);
  }

  /// Evaluate order n derivatives of basis function i at given point x in cell
  virtual void evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double* values,
                                          const double* x,
                                          const double* vertex_coordinates,
                                          int cell_orientation) const
  {
    // Compute Jacobian
    double J[6];
    compute_jacobian_triangle_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[6];
    double detJ;
    compute_jacobian_inverse_triangle_3d(K, detJ, J);
    
    
    
    // P_FFC = J^dag (p - b), P_FIAT = 2*P_FFC - (1, 1)
    
    
    // Compute number of derivatives.
    unsigned int num_derivatives_t = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives_t *= 2;
    }// end loop over 'r'
    
    // Compute number of derivatives.
    unsigned int num_derivatives_g = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives_g *= 3;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations_t = new unsigned int *[num_derivatives_t];
    for (unsigned int row = 0; row < num_derivatives_t; row++)
    {
      combinations_t[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations_t[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives_t; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations_t[row][col] + 1 > 1)
            combinations_t[row][col] = 0;
          else
          {
            combinations_t[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations_g = new unsigned int *[num_derivatives_g];
    for (unsigned int row = 0; row < num_derivatives_g; row++)
    {
      combinations_g[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations_g[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives_g; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations_g[row][col] + 1 > 2)
            combinations_g[row][col] = 0;
          else
          {
            combinations_g[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][3] = {{K[0], K[1], K[2]}, {K[3], K[4], K[5]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives_g];
    
    for (unsigned int j = 0; j < num_derivatives_g; j++)
    {
      transform[j] = new double [num_derivatives_t];
      for (unsigned int k = 0; k < num_derivatives_t; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives_g; row++)
    {
      for (unsigned int col = 0; col < num_derivatives_t; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations_t[col][k]][combinations_g[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives_g; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    
    // Array of basisvalues
    double basisvalues[1] = {0.0};
    
    // Declare helper variables
    
    // Compute basisvalues
    basisvalues[0] = 1.0;
    
    // Table(s) of coefficients
    static const double coefficients0[1] = \
    {1.0};
    
    // Tables of derivatives of the polynomial base (transpose).
    static const double dmats0[1][1] = \
    {{0.0}};
    
    static const double dmats1[1][1] = \
    {{0.0}};
    
    // Compute reference derivatives.
    // Declare pointer to array of derivatives on FIAT element.
    double *derivatives = new double[num_derivatives_t];
    for (unsigned int r = 0; r < num_derivatives_t; r++)
    {
      derivatives[r] = 0.0;
    }// end loop over 'r'
    
    // Declare derivative matrix (of polynomial basis).
    double dmats[1][1] = \
    {{1.0}};
    
    // Declare (auxiliary) derivative matrix (of polynomial basis).
    double dmats_old[1][1] = \
    {{1.0}};
    
    // Loop possible derivatives.
    for (unsigned int r = 0; r < num_derivatives_t; r++)
    {
      // Resetting dmats values to compute next derivative.
      for (unsigned int t = 0; t < 1; t++)
      {
        for (unsigned int u = 0; u < 1; u++)
        {
          dmats[t][u] = 0.0;
          if (t == u)
          {
          dmats[t][u] = 1.0;
          }
          
        }// end loop over 'u'
      }// end loop over 't'
      
      // Looping derivative order to generate dmats.
      for (unsigned int s = 0; s < n; s++)
      {
        // Updating dmats_old with new values and resetting dmats.
        for (unsigned int t = 0; t < 1; t++)
        {
          for (unsigned int u = 0; u < 1; u++)
          {
            dmats_old[t][u] = dmats[t][u];
            dmats[t][u] = 0.0;
          }// end loop over 'u'
        }// end loop over 't'
        
        // Update dmats using an inner product.
        if (combinations_t[r][s] == 0)
        {
        for (unsigned int t = 0; t < 1; t++)
        {
          for (unsigned int u = 0; u < 1; u++)
          {
            for (unsigned int tu = 0; tu < 1; tu++)
            {
              dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
        if (combinations_t[r][s] == 1)
        {
        for (unsigned int t = 0; t < 1; t++)
        {
          for (unsigned int u = 0; u < 1; u++)
          {
            for (unsigned int tu = 0; tu < 1; tu++)
            {
              dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
      }// end loop over 's'
      for (unsigned int s = 0; s < 1; s++)
      {
        for (unsigned int t = 0; t < 1; t++)
        {
          derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
        }// end loop over 't'
      }// end loop over 's'
    }// end loop over 'r'
    
    // Transform derivatives back to physical element
    for (unsigned int r = 0; r < num_derivatives_g; r++)
    {
      for (unsigned int s = 0; s < num_derivatives_t; s++)
      {
        values[r] += transform[r][s]*derivatives[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer to array of derivatives on FIAT element
    delete [] derivatives;
    
    // Delete pointer to array of combinations of derivatives and transform
    for (unsigned int r = 0; r < num_derivatives_t; r++)
    {
      delete [] combinations_t[r];
    }// end loop over 'r'
    delete [] combinations_t;
    for (unsigned int r = 0; r < num_derivatives_g; r++)
    {
      delete [] combinations_g[r];
    }// end loop over 'r'
    delete [] combinations_g;
    for (unsigned int r = 0; r < num_derivatives_g; r++)
    {
      delete [] transform[r];
    }// end loop over 'r'
    delete [] transform;
  }

  /// Evaluate order n derivatives of all basis functions at given point x in cell
  virtual void evaluate_basis_derivatives_all(std::size_t n,
                                              double* values,
                                              const double* x,
                                              const double* vertex_coordinates,
                                              int cell_orientation) const
  {
    // Element is constant, calling evaluate_basis_derivatives.
    evaluate_basis_derivatives(0, n, values, x, vertex_coordinates, cell_orientation);
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(std::size_t i,
                              const ufc::function& f,
                              const double* vertex_coordinates,
                              int cell_orientation,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[3];
    switch (i)
    {
    case 0:
      {
        y[0] = 0.33333333*vertex_coordinates[0] + 0.33333333*vertex_coordinates[3] + 0.33333333*vertex_coordinates[6];
      y[1] = 0.33333333*vertex_coordinates[1] + 0.33333333*vertex_coordinates[4] + 0.33333333*vertex_coordinates[7];
      y[2] = 0.33333333*vertex_coordinates[2] + 0.33333333*vertex_coordinates[5] + 0.33333333*vertex_coordinates[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const double* vertex_coordinates,
                             int cell_orientation,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[3];
    y[0] = 0.33333333*vertex_coordinates[0] + 0.33333333*vertex_coordinates[3] + 0.33333333*vertex_coordinates[6];
    y[1] = 0.33333333*vertex_coordinates[1] + 0.33333333*vertex_coordinates[4] + 0.33333333*vertex_coordinates[7];
    y[2] = 0.33333333*vertex_coordinates[2] + 0.33333333*vertex_coordinates[5] + 0.33333333*vertex_coordinates[8];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const double* vertex_coordinates,
                                         int cell_orientation,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[0];
    vertex_values[2] = dof_values[0];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    std::cerr << "*** FFC warning: " << "map_from_reference_cell not yet implemented." << std::endl;
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    std::cerr << "*** FFC warning: " << "map_to_reference_cell not yet implemented." << std::endl;
  }

  /// Return the number of sub elements (for a mixed element)
  virtual std::size_t num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(std::size_t i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new projectionmanifold_finite_element_1();
  }

};

/// This class defines the interface for a finite element.

class projectionmanifold_finite_element_2: public ufc::finite_element
{
public:

  /// Constructor
  projectionmanifold_finite_element_2() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~projectionmanifold_finite_element_2()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "MixedElement(*[FiniteElement('Raviart-Thomas', Domain(Cell('triangle', 3), 'triangle_multiverse', 3, 2), 1, None), FiniteElement('Discontinuous Lagrange', Domain(Cell('triangle', 3), 'triangle_multiverse', 3, 2), 0, None)], **{'value_shape': (4,) })";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual std::size_t topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual std::size_t geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the finite element function space
  virtual std::size_t space_dimension() const
  {
    return 4;
  }

  /// Return the rank of the value space
  virtual std::size_t value_rank() const
  {
    return 1;
  }

  /// Return the dimension of the value space for axis i
  virtual std::size_t value_dimension(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      {
        return 4;
        break;
      }
    }
    
    return 0;
  }

  /// Evaluate basis function i at given point x in cell
  virtual void evaluate_basis(std::size_t i,
                              double* values,
                              const double* x,
                              const double* vertex_coordinates,
                              int cell_orientation) const
  {
    // Compute Jacobian
    double J[6];
    compute_jacobian_triangle_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[6];
    double detJ;
    compute_jacobian_inverse_triangle_3d(K, detJ, J);
    
    
    // Check orientation
    if (cell_orientation == -1)
      throw std::runtime_error("cell orientation must be defined (not -1)");
    // (If cell_orientation == 1 = down, multiply det(J) by -1)
    else if (cell_orientation == 1)
      detJ *= -1;
    
    
    const double b0 = vertex_coordinates[0];
    const double b1 = vertex_coordinates[1];
    const double b2 = vertex_coordinates[2];
    
    // P_FFC = J^dag (p - b), P_FIAT = 2*P_FFC - (1, 1)
    double X = 2*(K[0]*(x[0] - b0) + K[1]*(x[1] - b1) + K[2]*(x[2] - b2)) - 1.0;
    double Y = 2*(K[3]*(x[0] - b0) + K[4]*(x[1] - b1) + K[5]*(x[2] - b2)) - 1.0;
    
    
    // Reset values
    values[0] = 0.0;
    values[1] = 0.0;
    values[2] = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.47140452, 0.28867513, -0.16666667};
      
      static const double coefficients1[3] = \
      {0.47140452, 0.0, 0.33333333};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using contravariant Piola transform to map values back to the physical element
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (1.0/detJ)*(J[0]*tmp_ref0 + J[1]*tmp_ref1);
      values[1] = (1.0/detJ)*(J[2]*tmp_ref0 + J[3]*tmp_ref1);
      values[2] = (1.0/detJ)*(J[4]*tmp_ref0 + J[5]*tmp_ref1);
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.94280904, -0.28867513, 0.16666667};
      
      static const double coefficients1[3] = \
      {-0.47140452, 0.0, -0.33333333};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using contravariant Piola transform to map values back to the physical element
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (1.0/detJ)*(J[0]*tmp_ref0 + J[1]*tmp_ref1);
      values[1] = (1.0/detJ)*(J[2]*tmp_ref0 + J[3]*tmp_ref1);
      values[2] = (1.0/detJ)*(J[4]*tmp_ref0 + J[5]*tmp_ref1);
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.47140452, 0.28867513, -0.16666667};
      
      static const double coefficients1[3] = \
      {-0.94280904, 0.0, 0.33333333};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 3; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
        values[1] += coefficients1[r]*basisvalues[r];
      }// end loop over 'r'
      
      // Using contravariant Piola transform to map values back to the physical element
      const double tmp_ref0 = values[0];
      const double tmp_ref1 = values[1];
      values[0] = (1.0/detJ)*(J[0]*tmp_ref0 + J[1]*tmp_ref1);
      values[1] = (1.0/detJ)*(J[2]*tmp_ref0 + J[3]*tmp_ref1);
      values[2] = (1.0/detJ)*(J[4]*tmp_ref0 + J[5]*tmp_ref1);
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[1] = {0.0};
      
      // Declare helper variables
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      
      // Table(s) of coefficients
      static const double coefficients0[1] = \
      {1.0};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 1; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point x in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* x,
                                  const double* vertex_coordinates,
                                  int cell_orientation) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values[4] = {0.0, 0.0, 0.0, 0.0};
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 4; r++)
    {
      evaluate_basis(r, dof_values, x, vertex_coordinates, cell_orientation);
      for (unsigned int s = 0; s < 4; s++)
      {
        values[r*4 + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point x in cell
  virtual void evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double* values,
                                          const double* x,
                                          const double* vertex_coordinates,
                                          int cell_orientation) const
  {
    // Compute Jacobian
    double J[6];
    compute_jacobian_triangle_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[6];
    double detJ;
    compute_jacobian_inverse_triangle_3d(K, detJ, J);
    
    
    // Check orientation
    if (cell_orientation == -1)
      throw std::runtime_error("cell orientation must be defined (not -1)");
    // (If cell_orientation == 1 = down, multiply det(J) by -1)
    else if (cell_orientation == 1)
      detJ *= -1;
    
    
    const double b0 = vertex_coordinates[0];
    const double b1 = vertex_coordinates[1];
    const double b2 = vertex_coordinates[2];
    
    // P_FFC = J^dag (p - b), P_FIAT = 2*P_FFC - (1, 1)
    double X = 2*(K[0]*(x[0] - b0) + K[1]*(x[1] - b1) + K[2]*(x[2] - b2)) - 1.0;
    double Y = 2*(K[3]*(x[0] - b0) + K[4]*(x[1] - b1) + K[5]*(x[2] - b2)) - 1.0;
    
    
    // Compute number of derivatives.
    unsigned int num_derivatives_t = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives_t *= 2;
    }// end loop over 'r'
    
    // Compute number of derivatives.
    unsigned int num_derivatives_g = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives_g *= 3;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations_t = new unsigned int *[num_derivatives_t];
    for (unsigned int row = 0; row < num_derivatives_t; row++)
    {
      combinations_t[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations_t[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives_t; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations_t[row][col] + 1 > 1)
            combinations_t[row][col] = 0;
          else
          {
            combinations_t[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations_g = new unsigned int *[num_derivatives_g];
    for (unsigned int row = 0; row < num_derivatives_g; row++)
    {
      combinations_g[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations_g[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives_g; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations_g[row][col] + 1 > 2)
            combinations_g[row][col] = 0;
          else
          {
            combinations_g[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][3] = {{K[0], K[1], K[2]}, {K[3], K[4], K[5]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives_g];
    
    for (unsigned int j = 0; j < num_derivatives_g; j++)
    {
      transform[j] = new double [num_derivatives_t];
      for (unsigned int k = 0; k < num_derivatives_t; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives_g; row++)
    {
      for (unsigned int col = 0; col < num_derivatives_t; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations_t[col][k]][combinations_g[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < 4*num_derivatives_g; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.47140452, 0.28867513, -0.16666667};
      
      static const double coefficients1[3] = \
      {0.47140452, 0.0, 0.33333333};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.8989795, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.4494897, 0.0, 0.0},
      {4.2426407, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[2*num_derivatives_t];
      for (unsigned int r = 0; r < 2*num_derivatives_t; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare pointer to array of reference derivatives on physical element.
      double *derivatives_p = new double[3*num_derivatives_t];
      for (unsigned int r = 0; r < 3*num_derivatives_t; r++)
      {
        derivatives_p[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives_t; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations_t[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations_t[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives_t + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using contravariant Piola transform to map values back to the physical element.
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives_t + r];
        derivatives_p[r] = (1.0/detJ)*(J[0]*tmp_ref0 + J[1]*tmp_ref1);
        derivatives_p[num_derivatives_t + r] = (1.0/detJ)*(J[2]*tmp_ref0 + J[3]*tmp_ref1);
        derivatives_p[2*num_derivatives_t + r] = (1.0/detJ)*(J[4]*tmp_ref0 + J[5]*tmp_ref1);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives_g; r++)
      {
        for (unsigned int s = 0; s < num_derivatives_t; s++)
        {
          values[r] += transform[r][s]*derivatives_p[s];
          values[num_derivatives_g + r] += transform[r][s]*derivatives_p[num_derivatives_t + s];
          values[2*num_derivatives_g + r] += transform[r][s]*derivatives_p[2*num_derivatives_t + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of reference derivatives on physical element.
      delete [] derivatives_p;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives_t; r++)
      {
        delete [] combinations_t[r];
      }// end loop over 'r'
      delete [] combinations_t;
      for (unsigned int r = 0; r < num_derivatives_g; r++)
      {
        delete [] combinations_g[r];
      }// end loop over 'r'
      delete [] combinations_g;
      for (unsigned int r = 0; r < num_derivatives_g; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.94280904, -0.28867513, 0.16666667};
      
      static const double coefficients1[3] = \
      {-0.47140452, 0.0, -0.33333333};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.8989795, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.4494897, 0.0, 0.0},
      {4.2426407, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[2*num_derivatives_t];
      for (unsigned int r = 0; r < 2*num_derivatives_t; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare pointer to array of reference derivatives on physical element.
      double *derivatives_p = new double[3*num_derivatives_t];
      for (unsigned int r = 0; r < 3*num_derivatives_t; r++)
      {
        derivatives_p[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives_t; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations_t[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations_t[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives_t + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using contravariant Piola transform to map values back to the physical element.
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives_t + r];
        derivatives_p[r] = (1.0/detJ)*(J[0]*tmp_ref0 + J[1]*tmp_ref1);
        derivatives_p[num_derivatives_t + r] = (1.0/detJ)*(J[2]*tmp_ref0 + J[3]*tmp_ref1);
        derivatives_p[2*num_derivatives_t + r] = (1.0/detJ)*(J[4]*tmp_ref0 + J[5]*tmp_ref1);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives_g; r++)
      {
        for (unsigned int s = 0; s < num_derivatives_t; s++)
        {
          values[r] += transform[r][s]*derivatives_p[s];
          values[num_derivatives_g + r] += transform[r][s]*derivatives_p[num_derivatives_t + s];
          values[2*num_derivatives_g + r] += transform[r][s]*derivatives_p[2*num_derivatives_t + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of reference derivatives on physical element.
      delete [] derivatives_p;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives_t; r++)
      {
        delete [] combinations_t[r];
      }// end loop over 'r'
      delete [] combinations_t;
      for (unsigned int r = 0; r < num_derivatives_g; r++)
      {
        delete [] combinations_g[r];
      }// end loop over 'r'
      delete [] combinations_g;
      for (unsigned int r = 0; r < num_derivatives_g; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[3] = {0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[1] *= std::sqrt(3.0);
      
      // Table(s) of coefficients
      static const double coefficients0[3] = \
      {0.47140452, 0.28867513, -0.16666667};
      
      static const double coefficients1[3] = \
      {-0.94280904, 0.0, 0.33333333};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.0, 0.0, 0.0},
      {4.8989795, 0.0, 0.0},
      {0.0, 0.0, 0.0}};
      
      static const double dmats1[3][3] = \
      {{0.0, 0.0, 0.0},
      {2.4494897, 0.0, 0.0},
      {4.2426407, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[2*num_derivatives_t];
      for (unsigned int r = 0; r < 2*num_derivatives_t; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare pointer to array of reference derivatives on physical element.
      double *derivatives_p = new double[3*num_derivatives_t];
      for (unsigned int r = 0; r < 3*num_derivatives_t; r++)
      {
        derivatives_p[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.0, 0.0, 0.0},
      {0.0, 1.0, 0.0},
      {0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives_t; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations_t[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations_t[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
            derivatives[num_derivatives_t + r] += coefficients1[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
        
        // Using contravariant Piola transform to map values back to the physical element.
        const double tmp_ref0 = derivatives[r];
        const double tmp_ref1 = derivatives[num_derivatives_t + r];
        derivatives_p[r] = (1.0/detJ)*(J[0]*tmp_ref0 + J[1]*tmp_ref1);
        derivatives_p[num_derivatives_t + r] = (1.0/detJ)*(J[2]*tmp_ref0 + J[3]*tmp_ref1);
        derivatives_p[2*num_derivatives_t + r] = (1.0/detJ)*(J[4]*tmp_ref0 + J[5]*tmp_ref1);
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives_g; r++)
      {
        for (unsigned int s = 0; s < num_derivatives_t; s++)
        {
          values[r] += transform[r][s]*derivatives_p[s];
          values[num_derivatives_g + r] += transform[r][s]*derivatives_p[num_derivatives_t + s];
          values[2*num_derivatives_g + r] += transform[r][s]*derivatives_p[2*num_derivatives_t + s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of reference derivatives on physical element.
      delete [] derivatives_p;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives_t; r++)
      {
        delete [] combinations_t[r];
      }// end loop over 'r'
      delete [] combinations_t;
      for (unsigned int r = 0; r < num_derivatives_g; r++)
      {
        delete [] combinations_g[r];
      }// end loop over 'r'
      delete [] combinations_g;
      for (unsigned int r = 0; r < num_derivatives_g; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[1] = {0.0};
      
      // Declare helper variables
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      
      // Table(s) of coefficients
      static const double coefficients0[1] = \
      {1.0};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[1][1] = \
      {{0.0}};
      
      static const double dmats1[1][1] = \
      {{0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives_t];
      for (unsigned int r = 0; r < num_derivatives_t; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[1][1] = \
      {{1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[1][1] = \
      {{1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives_t; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 1; t++)
        {
          for (unsigned int u = 0; u < 1; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 1; t++)
          {
            for (unsigned int u = 0; u < 1; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations_t[r][s] == 0)
          {
          for (unsigned int t = 0; t < 1; t++)
          {
            for (unsigned int u = 0; u < 1; u++)
            {
              for (unsigned int tu = 0; tu < 1; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations_t[r][s] == 1)
          {
          for (unsigned int t = 0; t < 1; t++)
          {
            for (unsigned int u = 0; u < 1; u++)
            {
              for (unsigned int tu = 0; tu < 1; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 1; s++)
        {
          for (unsigned int t = 0; t < 1; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives_g; r++)
      {
        for (unsigned int s = 0; s < num_derivatives_t; s++)
        {
          values[2*num_derivatives_g + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives_t; r++)
      {
        delete [] combinations_t[r];
      }// end loop over 'r'
      delete [] combinations_t;
      for (unsigned int r = 0; r < num_derivatives_g; r++)
      {
        delete [] combinations_g[r];
      }// end loop over 'r'
      delete [] combinations_g;
      for (unsigned int r = 0; r < num_derivatives_g; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point x in cell
  virtual void evaluate_basis_derivatives_all(std::size_t n,
                                              double* values,
                                              const double* x,
                                              const double* vertex_coordinates,
                                              int cell_orientation) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives_g = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives_g *= 3;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[4*num_derivatives_g];
    for (unsigned int r = 0; r < 4*num_derivatives_g; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 4; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, x, vertex_coordinates, cell_orientation);
      for (unsigned int s = 0; s < 4*num_derivatives_g; s++)
      {
        values[r*4*num_derivatives_g + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(std::size_t i,
                              const ufc::function& f,
                              const double* vertex_coordinates,
                              int cell_orientation,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation
    double vals[4];
    
    // Declare variable for physical coordinates
    double y[3];
    
    double result;
    // Compute Jacobian
    double J[6];
    compute_jacobian_triangle_3d(J, vertex_coordinates);
    
    
    // Compute Jacobian inverse and determinant
    double K[6];
    double detJ;
    compute_jacobian_inverse_triangle_3d(K, detJ, J);
    
    
    
    // Check orientation
    if (cell_orientation == -1)
      throw std::runtime_error("cell orientation must be defined (not -1)");
    // (If cell_orientation == 1 = down, multiply det(J) by -1)
    else if (cell_orientation == 1)
      detJ *= -1;
    switch (i)
    {
    case 0:
      {
        y[0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[6];
      y[1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[7];
      y[2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[8];
      f.evaluate(vals, y, c);
      result = (detJ*(K[0]*vals[0] + K[1]*vals[1] + K[2]*vals[2])) + (detJ*(K[3]*vals[0] + K[4]*vals[1] + K[5]*vals[2]));
      return result;
        break;
      }
    case 1:
      {
        y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[6];
      y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[7];
      y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[8];
      f.evaluate(vals, y, c);
      result = (detJ*(K[0]*vals[0] + K[1]*vals[1] + K[2]*vals[2]));
      return result;
        break;
      }
    case 2:
      {
        y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[3];
      y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[4];
      y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      result = (-1.0)*(detJ*(K[3]*vals[0] + K[4]*vals[1] + K[5]*vals[2]));
      return result;
        break;
      }
    case 3:
      {
        y[0] = 0.33333333*vertex_coordinates[0] + 0.33333333*vertex_coordinates[3] + 0.33333333*vertex_coordinates[6];
      y[1] = 0.33333333*vertex_coordinates[1] + 0.33333333*vertex_coordinates[4] + 0.33333333*vertex_coordinates[7];
      y[2] = 0.33333333*vertex_coordinates[2] + 0.33333333*vertex_coordinates[5] + 0.33333333*vertex_coordinates[8];
      f.evaluate(vals, y, c);
      return vals[3];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const double* vertex_coordinates,
                             int cell_orientation,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation
    double vals[4];
    
    // Declare variable for physical coordinates
    double y[3];
    
    double result;
    // Compute Jacobian
    double J[6];
    compute_jacobian_triangle_3d(J, vertex_coordinates);
    
    
    // Compute Jacobian inverse and determinant
    double K[6];
    double detJ;
    compute_jacobian_inverse_triangle_3d(K, detJ, J);
    
    
    
    // Check orientation
    if (cell_orientation == -1)
      throw std::runtime_error("cell orientation must be defined (not -1)");
    // (If cell_orientation == 1 = down, multiply det(J) by -1)
    else if (cell_orientation == 1)
      detJ *= -1;
    y[0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[6];
    y[1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[7];
    y[2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[8];
    f.evaluate(vals, y, c);
    result = (detJ*(K[0]*vals[0] + K[1]*vals[1] + K[2]*vals[2])) + (detJ*(K[3]*vals[0] + K[4]*vals[1] + K[5]*vals[2]));
    values[0] = result;
    y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[6];
    y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[7];
    y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[8];
    f.evaluate(vals, y, c);
    result = (detJ*(K[0]*vals[0] + K[1]*vals[1] + K[2]*vals[2]));
    values[1] = result;
    y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[3];
    y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[4];
    y[2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    result = (-1.0)*(detJ*(K[3]*vals[0] + K[4]*vals[1] + K[5]*vals[2]));
    values[2] = result;
    y[0] = 0.33333333*vertex_coordinates[0] + 0.33333333*vertex_coordinates[3] + 0.33333333*vertex_coordinates[6];
    y[1] = 0.33333333*vertex_coordinates[1] + 0.33333333*vertex_coordinates[4] + 0.33333333*vertex_coordinates[7];
    y[2] = 0.33333333*vertex_coordinates[2] + 0.33333333*vertex_coordinates[5] + 0.33333333*vertex_coordinates[8];
    f.evaluate(vals, y, c);
    values[3] = vals[3];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const double* vertex_coordinates,
                                         int cell_orientation,
                                         const ufc::cell& c) const
  {
    // Compute Jacobian
    double J[6];
    compute_jacobian_triangle_3d(J, vertex_coordinates);
    
    
    // Compute Jacobian inverse and determinant
    double K[6];
    double detJ;
    compute_jacobian_inverse_triangle_3d(K, detJ, J);
    
    
    
    // Check orientation
    if (cell_orientation == -1)
      throw std::runtime_error("cell orientation must be defined (not -1)");
    // (If cell_orientation == 1 = down, multiply det(J) by -1)
    else if (cell_orientation == 1)
      detJ *= -1;
    
    // Evaluate function and change variables
    vertex_values[0] = dof_values[1]*(1.0/detJ)*J[0] + dof_values[2]*((1.0/detJ)*(J[1]*(-1.0)));
    vertex_values[3] = dof_values[0]*(1.0/detJ)*J[0] + dof_values[2]*((1.0/detJ)*(J[0] + J[1]*(-1.0)));
    vertex_values[6] = dof_values[0]*(1.0/detJ)*J[1] + dof_values[1]*((1.0/detJ)*(J[0] + J[1]*(-1.0)));
    vertex_values[1] = dof_values[1]*(1.0/detJ)*J[2] + dof_values[2]*((1.0/detJ)*(J[3]*(-1.0)));
    vertex_values[4] = dof_values[0]*(1.0/detJ)*J[2] + dof_values[2]*((1.0/detJ)*(J[2] + J[3]*(-1.0)));
    vertex_values[7] = dof_values[0]*(1.0/detJ)*J[3] + dof_values[1]*((1.0/detJ)*(J[2] + J[3]*(-1.0)));
    // Evaluate function and change variables
    vertex_values[2] = dof_values[3];
    vertex_values[5] = dof_values[3];
    vertex_values[8] = dof_values[3];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    std::cerr << "*** FFC warning: " << "map_from_reference_cell not yet implemented." << std::endl;
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    std::cerr << "*** FFC warning: " << "map_to_reference_cell not yet implemented." << std::endl;
  }

  /// Return the number of sub elements (for a mixed element)
  virtual std::size_t num_sub_elements() const
  {
    return 2;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      {
        return new projectionmanifold_finite_element_0();
        break;
      }
    case 1:
      {
        return new projectionmanifold_finite_element_1();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new projectionmanifold_finite_element_2();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class projectionmanifold_dofmap_0: public ufc::dofmap
{
public:

  /// Constructor
  projectionmanifold_dofmap_0() : ufc::dofmap()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~projectionmanifold_dofmap_0()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Raviart-Thomas', Domain(Cell('triangle', 3), 'triangle_multiverse', 3, 2), 1, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(std::size_t d) const
  {
    switch (d)
    {
    case 0:
      {
        return false;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Return the topological dimension of the associated cell shape
  virtual std::size_t topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual std::size_t geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the global finite element function space
  virtual std::size_t global_dimension(const std::vector<std::size_t>&
                                       num_global_entities) const
  {
    return num_global_entities[1];
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual std::size_t local_dimension(const ufc::cell& c) const
  {
    return 3;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual std::size_t max_local_dimension() const
  {
    return 3;
  }

  /// Return the number of dofs on each cell facet
  virtual std::size_t num_facet_dofs() const
  {
    return 1;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual std::size_t num_entity_dofs(std::size_t d) const
  {
    switch (d)
    {
    case 0:
      {
        return 0;
        break;
      }
    case 1:
      {
        return 1;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(std::size_t* dofs,
                             const std::vector<std::size_t>& num_global_entities,
                             const ufc::cell& c) const
  {
    dofs[0] = c.entity_indices[1][0];
    dofs[1] = c.entity_indices[1][1];
    dofs[2] = c.entity_indices[1][2];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(std::size_t* dofs,
                                   std::size_t facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 0;
        break;
      }
    case 1:
      {
        dofs[0] = 1;
        break;
      }
    case 2:
      {
        dofs[0] = 2;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(std::size_t* dofs,
                                    std::size_t d, std::size_t i) const
  {
    if (d > 2)
    {
    std::cerr << "*** FFC warning: " << "d is larger than dimension (2)" << std::endl;
    }
    
    switch (d)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      std::cerr << "*** FFC warning: " << "i is larger than number of entities (2)" << std::endl;
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** dof_coordinates,
                                    const double* vertex_coordinates) const
  {
    dof_coordinates[0][0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[6];
    dof_coordinates[0][1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[7];
    dof_coordinates[0][2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[8];
    dof_coordinates[1][0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[6];
    dof_coordinates[1][1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[7];
    dof_coordinates[1][2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[8];
    dof_coordinates[2][0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[3];
    dof_coordinates[2][1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[4];
    dof_coordinates[2][2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[5];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual std::size_t num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(std::size_t i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new projectionmanifold_dofmap_0();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class projectionmanifold_dofmap_1: public ufc::dofmap
{
public:

  /// Constructor
  projectionmanifold_dofmap_1() : ufc::dofmap()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~projectionmanifold_dofmap_1()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Discontinuous Lagrange', Domain(Cell('triangle', 3), 'triangle_multiverse', 3, 2), 0, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(std::size_t d) const
  {
    switch (d)
    {
    case 0:
      {
        return false;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  /// Return the topological dimension of the associated cell shape
  virtual std::size_t topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual std::size_t geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the global finite element function space
  virtual std::size_t global_dimension(const std::vector<std::size_t>&
                                       num_global_entities) const
  {
    return num_global_entities[2];
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual std::size_t local_dimension(const ufc::cell& c) const
  {
    return 1;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual std::size_t max_local_dimension() const
  {
    return 1;
  }

  /// Return the number of dofs on each cell facet
  virtual std::size_t num_facet_dofs() const
  {
    return 0;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual std::size_t num_entity_dofs(std::size_t d) const
  {
    switch (d)
    {
    case 0:
      {
        return 0;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 1;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(std::size_t* dofs,
                             const std::vector<std::size_t>& num_global_entities,
                             const ufc::cell& c) const
  {
    dofs[0] = c.entity_indices[2][0];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(std::size_t* dofs,
                                   std::size_t facet) const
  {
    switch (facet)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(std::size_t* dofs,
                                    std::size_t d, std::size_t i) const
  {
    if (d > 2)
    {
    std::cerr << "*** FFC warning: " << "d is larger than dimension (2)" << std::endl;
    }
    
    switch (d)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      std::cerr << "*** FFC warning: " << "i is larger than number of entities (0)" << std::endl;
      }
      
      dofs[0] = 0;
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** dof_coordinates,
                                    const double* vertex_coordinates) const
  {
    dof_coordinates[0][0] = 0.33333333*vertex_coordinates[0] + 0.33333333*vertex_coordinates[3] + 0.33333333*vertex_coordinates[6];
    dof_coordinates[0][1] = 0.33333333*vertex_coordinates[1] + 0.33333333*vertex_coordinates[4] + 0.33333333*vertex_coordinates[7];
    dof_coordinates[0][2] = 0.33333333*vertex_coordinates[2] + 0.33333333*vertex_coordinates[5] + 0.33333333*vertex_coordinates[8];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual std::size_t num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(std::size_t i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new projectionmanifold_dofmap_1();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class projectionmanifold_dofmap_2: public ufc::dofmap
{
public:

  /// Constructor
  projectionmanifold_dofmap_2() : ufc::dofmap()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~projectionmanifold_dofmap_2()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for MixedElement(*[FiniteElement('Raviart-Thomas', Domain(Cell('triangle', 3), 'triangle_multiverse', 3, 2), 1, None), FiniteElement('Discontinuous Lagrange', Domain(Cell('triangle', 3), 'triangle_multiverse', 3, 2), 0, None)], **{'value_shape': (4,) })";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(std::size_t d) const
  {
    switch (d)
    {
    case 0:
      {
        return false;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  /// Return the topological dimension of the associated cell shape
  virtual std::size_t topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual std::size_t geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the global finite element function space
  virtual std::size_t global_dimension(const std::vector<std::size_t>&
                                       num_global_entities) const
  {
    return num_global_entities[1] + num_global_entities[2];
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual std::size_t local_dimension(const ufc::cell& c) const
  {
    return 4;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual std::size_t max_local_dimension() const
  {
    return 4;
  }

  /// Return the number of dofs on each cell facet
  virtual std::size_t num_facet_dofs() const
  {
    return 1;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual std::size_t num_entity_dofs(std::size_t d) const
  {
    switch (d)
    {
    case 0:
      {
        return 0;
        break;
      }
    case 1:
      {
        return 1;
        break;
      }
    case 2:
      {
        return 1;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(std::size_t* dofs,
                             const std::vector<std::size_t>& num_global_entities,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[1][0];
    dofs[1] = offset + c.entity_indices[1][1];
    dofs[2] = offset + c.entity_indices[1][2];
    offset += num_global_entities[1];
    dofs[3] = offset + c.entity_indices[2][0];
    offset += num_global_entities[2];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(std::size_t* dofs,
                                   std::size_t facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 0;
        break;
      }
    case 1:
      {
        dofs[0] = 1;
        break;
      }
    case 2:
      {
        dofs[0] = 2;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(std::size_t* dofs,
                                    std::size_t d, std::size_t i) const
  {
    if (d > 2)
    {
    std::cerr << "*** FFC warning: " << "d is larger than dimension (2)" << std::endl;
    }
    
    switch (d)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      std::cerr << "*** FFC warning: " << "i is larger than number of entities (2)" << std::endl;
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      std::cerr << "*** FFC warning: " << "i is larger than number of entities (0)" << std::endl;
      }
      
      dofs[0] = 3;
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** dof_coordinates,
                                    const double* vertex_coordinates) const
  {
    dof_coordinates[0][0] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[6];
    dof_coordinates[0][1] = 0.5*vertex_coordinates[4] + 0.5*vertex_coordinates[7];
    dof_coordinates[0][2] = 0.5*vertex_coordinates[5] + 0.5*vertex_coordinates[8];
    dof_coordinates[1][0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[6];
    dof_coordinates[1][1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[7];
    dof_coordinates[1][2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[8];
    dof_coordinates[2][0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[3];
    dof_coordinates[2][1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[4];
    dof_coordinates[2][2] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[5];
    dof_coordinates[3][0] = 0.33333333*vertex_coordinates[0] + 0.33333333*vertex_coordinates[3] + 0.33333333*vertex_coordinates[6];
    dof_coordinates[3][1] = 0.33333333*vertex_coordinates[1] + 0.33333333*vertex_coordinates[4] + 0.33333333*vertex_coordinates[7];
    dof_coordinates[3][2] = 0.33333333*vertex_coordinates[2] + 0.33333333*vertex_coordinates[5] + 0.33333333*vertex_coordinates[8];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual std::size_t num_sub_dofmaps() const
  {
    return 2;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      {
        return new projectionmanifold_dofmap_0();
        break;
      }
    case 1:
      {
        return new projectionmanifold_dofmap_1();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new projectionmanifold_dofmap_2();
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class projectionmanifold_cell_integral_0_otherwise: public ufc::cell_integral
{
public:

  /// Constructor
  projectionmanifold_cell_integral_0_otherwise() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~projectionmanifold_cell_integral_0_otherwise()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const double* vertex_coordinates,
                               int cell_orientation) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      5
    // Number of operations (multiply-add pairs) for geometry tensor:    66
    // Number of operations (multiply-add pairs) for tensor contraction: 136
    // Total number of operations (multiply-add pairs):                  207
    
    // Compute Jacobian
    double J[6];
    compute_jacobian_triangle_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[6];
    double detJ;
    compute_jacobian_inverse_triangle_3d(K, detJ, J);
    
    // Check orientation
    if (cell_orientation == -1)
      throw std::runtime_error("cell orientation must be defined (not -1)");
    // (If cell_orientation == 1 = down, multiply det(J) by -1)
    else if (cell_orientation == 1)
      detJ *= -1;
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0_0 = 1.0 / (detJ)*det*J[4]*K[2]*(1.0);
    const double G0_1_1 = 1.0 / (detJ)*det*J[5]*K[5]*(1.0);
    const double G1_0_0 = 1.0 / (detJ)*det*J[0]*K[0]*(1.0);
    const double G1_1_1 = 1.0 / (detJ)*det*J[1]*K[3]*(1.0);
    const double G2_0_0 = 1.0 / (detJ)*det*J[2]*K[1]*(1.0);
    const double G2_1_1 = 1.0 / (detJ)*det*J[3]*K[4]*(1.0);
    const double G3_0_0 = 1.0 / (detJ)*det*J[4]*K[2]*(1.0);
    const double G3_1_1 = 1.0 / (detJ)*det*J[5]*K[5]*(1.0);
    const double G4_0_0 = 1.0 / (detJ)*det*J[0]*K[0]*(1.0);
    const double G4_1_1 = 1.0 / (detJ)*det*J[1]*K[3]*(1.0);
    const double G5_0_0 = 1.0 / (detJ)*det*J[2]*K[1]*(1.0);
    const double G5_1_1 = 1.0 / (detJ)*det*J[3]*K[4]*(1.0);
    const double G6_0_0 = 1.0 / (detJ*detJ)*det*J[4]*J[4]*(1.0);
    const double G6_0_1 = 1.0 / (detJ*detJ)*det*J[4]*J[5]*(1.0);
    const double G6_1_0 = 1.0 / (detJ*detJ)*det*J[5]*J[4]*(1.0);
    const double G6_1_1 = 1.0 / (detJ*detJ)*det*J[5]*J[5]*(1.0);
    const double G7_0_0 = 1.0 / (detJ*detJ)*det*J[0]*J[0]*(1.0);
    const double G7_0_1 = 1.0 / (detJ*detJ)*det*J[0]*J[1]*(1.0);
    const double G7_1_0 = 1.0 / (detJ*detJ)*det*J[1]*J[0]*(1.0);
    const double G7_1_1 = 1.0 / (detJ*detJ)*det*J[1]*J[1]*(1.0);
    const double G8_0_0 = 1.0 / (detJ*detJ)*det*J[2]*J[2]*(1.0);
    const double G8_0_1 = 1.0 / (detJ*detJ)*det*J[2]*J[3]*(1.0);
    const double G8_1_0 = 1.0 / (detJ*detJ)*det*J[3]*J[2]*(1.0);
    const double G8_1_1 = 1.0 / (detJ*detJ)*det*J[3]*J[3]*(1.0);
    
    // Compute element tensor
    A[0] = 0.083333333*G6_0_0 + 0.041666667*G6_0_1 + 0.041666667*G6_1_0 + 0.083333333*G6_1_1 + 0.083333333*G7_0_0 + 0.041666667*G7_0_1 + 0.041666667*G7_1_0 + 0.083333333*G7_1_1 + 0.083333333*G8_0_0 + 0.041666667*G8_0_1 + 0.041666667*G8_1_0 + 0.083333333*G8_1_1;
    A[1] = 0.083333333*G6_0_0 - 0.041666667*G6_0_1 + 0.125*G6_1_0 - 0.083333333*G6_1_1 + 0.083333333*G7_0_0 - 0.041666667*G7_0_1 + 0.125*G7_1_0 - 0.083333333*G7_1_1 + 0.083333333*G8_0_0 - 0.041666667*G8_0_1 + 0.125*G8_1_0 - 0.083333333*G8_1_1;
    A[2] = 0.083333333*G6_0_0 - 0.125*G6_0_1 + 0.041666667*G6_1_0 - 0.083333333*G6_1_1 + 0.083333333*G7_0_0 - 0.125*G7_0_1 + 0.041666667*G7_1_0 - 0.083333333*G7_1_1 + 0.083333333*G8_0_0 - 0.125*G8_0_1 + 0.041666667*G8_1_0 - 0.083333333*G8_1_1;
    A[3] = 0.5*G0_0_0 + 0.5*G0_1_1 + 0.5*G1_0_0 + 0.5*G1_1_1 + 0.5*G2_0_0 + 0.5*G2_1_1;
    A[4] = 0.083333333*G6_0_0 + 0.125*G6_0_1 - 0.041666667*G6_1_0 - 0.083333333*G6_1_1 + 0.083333333*G7_0_0 + 0.125*G7_0_1 - 0.041666667*G7_1_0 - 0.083333333*G7_1_1 + 0.083333333*G8_0_0 + 0.125*G8_0_1 - 0.041666667*G8_1_0 - 0.083333333*G8_1_1;
    A[5] = 0.25*G6_0_0 - 0.125*G6_0_1 - 0.125*G6_1_0 + 0.083333333*G6_1_1 + 0.25*G7_0_0 - 0.125*G7_0_1 - 0.125*G7_1_0 + 0.083333333*G7_1_1 + 0.25*G8_0_0 - 0.125*G8_0_1 - 0.125*G8_1_0 + 0.083333333*G8_1_1;
    A[6] = 0.083333333*G6_0_0 - 0.20833333*G6_0_1 - 0.041666667*G6_1_0 + 0.083333333*G6_1_1 + 0.083333333*G7_0_0 - 0.20833333*G7_0_1 - 0.041666667*G7_1_0 + 0.083333333*G7_1_1 + 0.083333333*G8_0_0 - 0.20833333*G8_0_1 - 0.041666667*G8_1_0 + 0.083333333*G8_1_1;
    A[7] = -0.5*G0_0_0 - 0.5*G0_1_1 - 0.5*G1_0_0 - 0.5*G1_1_1 - 0.5*G2_0_0 - 0.5*G2_1_1;
    A[8] = 0.083333333*G6_0_0 + 0.041666667*G6_0_1 - 0.125*G6_1_0 - 0.083333333*G6_1_1 + 0.083333333*G7_0_0 + 0.041666667*G7_0_1 - 0.125*G7_1_0 - 0.083333333*G7_1_1 + 0.083333333*G8_0_0 + 0.041666667*G8_0_1 - 0.125*G8_1_0 - 0.083333333*G8_1_1;
    A[9] = 0.083333333*G6_0_0 - 0.041666667*G6_0_1 - 0.20833333*G6_1_0 + 0.083333333*G6_1_1 + 0.083333333*G7_0_0 - 0.041666667*G7_0_1 - 0.20833333*G7_1_0 + 0.083333333*G7_1_1 + 0.083333333*G8_0_0 - 0.041666667*G8_0_1 - 0.20833333*G8_1_0 + 0.083333333*G8_1_1;
    A[10] = 0.083333333*G6_0_0 - 0.125*G6_0_1 - 0.125*G6_1_0 + 0.25*G6_1_1 + 0.083333333*G7_0_0 - 0.125*G7_0_1 - 0.125*G7_1_0 + 0.25*G7_1_1 + 0.083333333*G8_0_0 - 0.125*G8_0_1 - 0.125*G8_1_0 + 0.25*G8_1_1;
    A[11] = 0.5*G0_0_0 + 0.5*G0_1_1 + 0.5*G1_0_0 + 0.5*G1_1_1 + 0.5*G2_0_0 + 0.5*G2_1_1;
    A[12] = 0.5*G3_0_0 + 0.5*G3_1_1 + 0.5*G4_0_0 + 0.5*G4_1_1 + 0.5*G5_0_0 + 0.5*G5_1_1;
    A[13] = -0.5*G3_0_0 - 0.5*G3_1_1 - 0.5*G4_0_0 - 0.5*G4_1_1 - 0.5*G5_0_0 - 0.5*G5_1_1;
    A[14] = 0.5*G3_0_0 + 0.5*G3_1_1 + 0.5*G4_0_0 + 0.5*G4_1_1 + 0.5*G5_0_0 + 0.5*G5_1_1;
    A[15] = 0.0;
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class projectionmanifold_form_0: public ufc::form
{
public:

  /// Constructor
  projectionmanifold_form_0() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~projectionmanifold_form_0()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "e78a2278f8cab860e9ac0865b6fee052698344942c6cbff9e41a848e6f2a49353e4cd71f65096c2facc2f4034f037d7eebb82d42c0e9ecd9a8ef113467c90a0f";
  }

  /// Return the rank of the global tensor (r)
  virtual std::size_t rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual std::size_t num_coefficients() const
  {
    return 0;
  }

  /// Return the number of cell domains
  virtual std::size_t num_cell_domains() const
  {
    return 0;
  }

  /// Return the number of exterior facet domains
  virtual std::size_t num_exterior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of interior facet domains
  virtual std::size_t num_interior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of point domains
  virtual std::size_t num_point_domains() const
  {
    return 0;
  }

  /// Return whether the form has any cell integrals
  virtual bool has_cell_integrals() const
  {
    return true;
  }

  /// Return whether the form has any exterior facet integrals
  virtual bool has_exterior_facet_integrals() const
  {
    return false;
  }

  /// Return whether the form has any interior facet integrals
  virtual bool has_interior_facet_integrals() const
  {
    return false;
  }

  /// Return whether the form has any point integrals
  virtual bool has_point_integrals() const
  {
    return false;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      {
        return new projectionmanifold_finite_element_2();
        break;
      }
    case 1:
      {
        return new projectionmanifold_finite_element_2();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      {
        return new projectionmanifold_dofmap_2();
        break;
      }
    case 1:
      {
        return new projectionmanifold_dofmap_2();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(std::size_t i) const
  {
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(std::size_t i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(std::size_t i) const
  {
    return 0;
  }

  /// Create a new point integral on sub domain i
  virtual ufc::point_integral* create_point_integral(std::size_t i) const
  {
    return 0;
  }

  /// Create a new cell integral on everywhere else
  virtual ufc::cell_integral* create_default_cell_integral() const
  {
    return new projectionmanifold_cell_integral_0_otherwise();
  }

  /// Create a new exterior facet integral on everywhere else
  virtual ufc::exterior_facet_integral* create_default_exterior_facet_integral() const
  {
    return 0;
  }

  /// Create a new interior facet integral on everywhere else
  virtual ufc::interior_facet_integral* create_default_interior_facet_integral() const
  {
    return 0;
  }

  /// Create a new point integral on everywhere else
  virtual ufc::point_integral* create_default_point_integral() const
  {
    return 0;
  }

};

#endif
