// This code conforms with the UFC specification version 1.4.1
// and was automatically generated by FFC version 0.9.3.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: True
//   cpp_optimize:                   False
//   epsilon:                        1e-14
//   form_postfix:                   True
//   format:                         'ufc'
//   log_level:                      10
//   log_prefix:                     ''
//   optimize:                       False
//   output_dir:                     '.'
//   precision:                      '8'
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   split:                          False

#ifndef __COEFFICIENTOPERATORS_H
#define __COEFFICIENTOPERATORS_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class coefficientoperators_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  coefficientoperators_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~coefficientoperators_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 1)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 3;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Reset values.
    *values = 0.00000000;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[3] = {0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = (1.00000000 + Y + 2.00000000*X)/2.00000000;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.50000000 + r + Y*(1.50000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[3] = \
      {0.47140452, -0.28867513, -0.16666667};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 3; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[3] = {0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = (1.00000000 + Y + 2.00000000*X)/2.00000000;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.50000000 + r + Y*(1.50000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[3] = \
      {0.47140452, 0.28867513, -0.16666667};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 3; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[3] = {0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = (1.00000000 + Y + 2.00000000*X)/2.00000000;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.50000000 + r + Y*(1.50000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[3] = \
      {0.47140452, 0.00000000, 0.33333333};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 3; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.00000000;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 3; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Compute constants
    const double C0 = x[1][0] + x[2][0];
    const double C1 = x[1][1] + x[2][1];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J_01*(C1 - 2.0*coordinates[1]) + J_11*(2.0*coordinates[0] - C0)) / detJ;
    double Y = (J_00*(2.0*coordinates[1] - C1) + J_10*(C0 - 2.0*coordinates[0])) / detJ;
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K_00, K_01}, {K_10, K_11}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.00000000;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[3] = {0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = (1.00000000 + Y + 2.00000000*X)/2.00000000;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.50000000 + r + Y*(1.50000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[3] = \
      {0.47140452, -0.28867513, -0.16666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.00000000, 0.00000000, 0.00000000},
      {4.89897949, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[3][3] = \
      {{0.00000000, 0.00000000, 0.00000000},
      {2.44948974, 0.00000000, 0.00000000},
      {4.24264069, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[3] = {0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = (1.00000000 + Y + 2.00000000*X)/2.00000000;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.50000000 + r + Y*(1.50000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[3] = \
      {0.47140452, 0.28867513, -0.16666667};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.00000000, 0.00000000, 0.00000000},
      {4.89897949, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[3][3] = \
      {{0.00000000, 0.00000000, 0.00000000},
      {2.44948974, 0.00000000, 0.00000000},
      {4.24264069, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[3] = {0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = (1.00000000 + Y + 2.00000000*X)/2.00000000;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)/2 + 1;
        ss = r*(r + 1)/2;
        basisvalues[rr] = basisvalues[ss]*(0.50000000 + r + Y*(1.50000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          rr = (r + s)*(r + s + 1)/2 + s;
          basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[3] = \
      {0.47140452, 0.00000000, 0.33333333};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[3][3] = \
      {{0.00000000, 0.00000000, 0.00000000},
      {4.89897949, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[3][3] = \
      {{0.00000000, 0.00000000, 0.00000000},
      {2.44948974, 0.00000000, 0.00000000},
      {4.24264069, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[3][3] = \
      {{1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[3][3] = \
      {{1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 3; t++)
        {
          for (unsigned int u = 0; u < 3; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 3; t++)
          {
            for (unsigned int u = 0; u < 3; u++)
            {
              for (unsigned int tu = 0; tu < 3; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 3; s++)
        {
          for (unsigned int t = 0; t < 3; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.00000000;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 3; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.00000000;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[2];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class coefficientoperators_dof_map_0: public ufc::dof_map
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  coefficientoperators_dof_map_0() : ufc::dof_map()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~coefficientoperators_dof_map_0()
  {
    // Do nothing
  }

  /// Return a string identifying the dof map
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 1)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dof map for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0];
    return false;
  }

  /// Initialize dof map for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dof map for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 3;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 3;
  }

  // Return the geometric dimension of the coordinates this dof map provides
  virtual unsigned int geometric_dimension() const
  {
    return 2;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 2;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    dofs[0] = c.entity_indices[0][0];
    dofs[1] = c.entity_indices[0][1];
    dofs[2] = c.entity_indices[0][2];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 2)
    {
    std::cerr << "*** FFC warning: " << "d is larger than dimension (2)" << std::endl;
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      std::cerr << "*** FFC warning: " << "i is larger than number of entities (2)" << std::endl;
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
  }

  /// Return the number of sub dof maps (for a mixed element)
  virtual unsigned int num_sub_dof_maps() const
  {
    return 0;
  }

  /// Create a new dof_map for sub dof map i (for a mixed element)
  virtual ufc::dof_map* create_sub_dof_map(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class coefficientoperators_cell_integral_0_0: public ufc::cell_integral
{
public:

  /// Constructor
  coefficientoperators_cell_integral_0_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~coefficientoperators_cell_integral_0_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    
    // Compute determinant of Jacobian
    double detJ = J_00*J_11 - J_01*J_10;
    
    // Compute inverse of Jacobian
    const double K_00 =  J_11 / detJ;
    const double K_01 = -J_01 / detJ;
    const double K_10 = -J_10 / detJ;
    const double K_11 =  J_00 / detJ;
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Array of quadrature weights.
    static const double W9[9] = {0.05581442, 0.06367809, 0.01939638, 0.08930307, 0.10188494, 0.03103421, 0.05581442, 0.06367809, 0.01939638};
    // Quadrature points on the UFC reference element: (0.10271765, 0.08858796), (0.06655407, 0.40946686), (0.02393113, 0.78765946), (0.45570602, 0.08858796), (0.29526657, 0.40946686), (0.10617027, 0.78765946), (0.80869439, 0.08858796), (0.52397907, 0.40946686), (0.18840941, 0.78765946)
    
    // Value of basis functions at quadrature points.
    static const double FE0[9][3] = \
    {{0.80869439, 0.10271765, 0.08858796},
    {0.52397907, 0.06655407, 0.40946686},
    {0.18840941, 0.02393113, 0.78765946},
    {0.45570602, 0.45570602, 0.08858796},
    {0.29526657, 0.29526657, 0.40946686},
    {0.10617027, 0.10617027, 0.78765946},
    {0.10271765, 0.80869439, 0.08858796},
    {0.06655407, 0.52397907, 0.40946686},
    {0.02393113, 0.18840941, 0.78765946}};
    
    static const double FE0_D01[9][3] = \
    {{-1.00000000, 0.00000000, 1.00000000},
    {-1.00000000, 0.00000000, 1.00000000},
    {-1.00000000, 0.00000000, 1.00000000},
    {-1.00000000, 0.00000000, 1.00000000},
    {-1.00000000, 0.00000000, 1.00000000},
    {-1.00000000, 0.00000000, 1.00000000},
    {-1.00000000, 0.00000000, 1.00000000},
    {-1.00000000, 0.00000000, 1.00000000},
    {-1.00000000, 0.00000000, 1.00000000}};
    
    static const double FE0_D10[9][3] = \
    {{-1.00000000, 1.00000000, 0.00000000},
    {-1.00000000, 1.00000000, 0.00000000},
    {-1.00000000, 1.00000000, 0.00000000},
    {-1.00000000, 1.00000000, 0.00000000},
    {-1.00000000, 1.00000000, 0.00000000},
    {-1.00000000, 1.00000000, 0.00000000},
    {-1.00000000, 1.00000000, 0.00000000},
    {-1.00000000, 1.00000000, 0.00000000},
    {-1.00000000, 1.00000000, 0.00000000}};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 9; r++)
    {
      A[r] = 0.00000000;
    }// end loop over 'r'
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('eliminate zeros', False), ('ignore ones', False), ('ignore zero tables', False), ('optimisation', False), ('remove zero terms', False)
    
    // Loop quadrature points for integral.
    // Number of operations to compute element tensor for following IP loop = 2133
    for (unsigned int ip = 0; ip < 9; ip++)
    {
      
      // Coefficient declarations.
      double F0 = 0.00000000;
      double F1 = 0.00000000;
      
      // Total number of operations to compute function values = 12
      for (unsigned int r = 0; r < 3; r++)
      {
        F0 += FE0[ip][r]*w[1][r];
        F1 += FE0[ip][r]*w[0][r];
      }// end loop over 'r'
      
      // Number of operations for primary indices: 225
      for (unsigned int j = 0; j < 3; j++)
      {
        for (unsigned int k = 0; k < 3; k++)
        {
          // Number of operations to compute entry: 25
          A[j*3 + k] += (FE0[ip][j]*FE0[ip][k]*std::sqrt(F1*F0)*F0 + ((((K_00*FE0_D10[ip][j] + K_10*FE0_D01[ip][j]))*((K_00*FE0_D10[ip][k] + K_10*FE0_D01[ip][k])) + ((K_01*FE0_D10[ip][j] + K_11*FE0_D01[ip][j]))*((K_01*FE0_D10[ip][k] + K_11*FE0_D01[ip][k]))))*std::sqrt(F0)*std::sqrt(1.00000000/(std::abs(1.00000000/(F1)))))*W9[ip]*det;
        }// end loop over 'k'
      }// end loop over 'j'
    }// end loop over 'ip'
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class coefficientoperators_form_0: public ufc::form
{
public:

  /// Constructor
  coefficientoperators_form_0() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~coefficientoperators_form_0()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(Sum(Product(Coefficient(FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 1), 1), Product(Product(Argument(FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 1), 0), Argument(FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 1), 1)), sqrt(Product(Coefficient(FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 1), 0), Coefficient(FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 1), 1))))), Product(IndexSum(Product(Indexed(ComponentTensor(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 1), 0), MultiIndex((Index(0),), {Index(0): 2})), MultiIndex((Index(0),), {Index(0): 2})), MultiIndex((Index(1),), {Index(1): 2})), Indexed(ComponentTensor(SpatialDerivative(Argument(FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 1), 1), MultiIndex((Index(2),), {Index(2): 2})), MultiIndex((Index(2),), {Index(2): 2})), MultiIndex((Index(1),), {Index(1): 2}))), MultiIndex((Index(1),), {Index(1): 2})), Product(sqrt(Coefficient(FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 1), 1)), sqrt(Division(IntValue(1, (), (), {}), Abs(Division(IntValue(1, (), (), {}), Coefficient(FiniteElement('Lagrange', Cell('triangle', 1, Space(2)), 1), 0)))))))), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 2;
  }

  /// Return the number of cell integrals
  virtual unsigned int num_cell_integrals() const
  {
    return 1;
  }

  /// Return the number of exterior facet integrals
  virtual unsigned int num_exterior_facet_integrals() const
  {
    return 0;
  }

  /// Return the number of interior facet integrals
  virtual unsigned int num_interior_facet_integrals() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new coefficientoperators_finite_element_0();
        break;
      }
    case 1:
      {
        return new coefficientoperators_finite_element_0();
        break;
      }
    case 2:
      {
        return new coefficientoperators_finite_element_0();
        break;
      }
    case 3:
      {
        return new coefficientoperators_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dof map for argument function i
  virtual ufc::dof_map* create_dof_map(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new coefficientoperators_dof_map_0();
        break;
      }
    case 1:
      {
        return new coefficientoperators_dof_map_0();
        break;
      }
    case 2:
      {
        return new coefficientoperators_dof_map_0();
        break;
      }
    case 3:
      {
        return new coefficientoperators_dof_map_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new coefficientoperators_cell_integral_0_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

#endif
