/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import ucar.grid.GridRecord;

public final class GribGridRecord
implements GridRecord {
    public int productType;
    public int discipline;
    public int category;
    public int paramNumber;
    public int typeGenProcess;
    public int levelType1;
    public int levelType2;
    public double levelValue1;
    public double levelValue2;
    public int gdsKey;
    public long offset1;
    public long offset2;
    public Date refTime;
    public int forecastTime;
    public int startOfInterval = -9999;
    public int timeUnit;
    private Date validTime = null;
    public int decimalScale = -9999;
    public boolean bmsExists = true;
    public int center = -1;
    public int subCenter = -1;
    public int table = -1;
    public boolean isEnsemble = false;
    public int ensembleNumber = -9999;
    public int numberForecasts = -9999;
    public int type = -9999;
    public float lowerLimit = -9999.0f;
    public float upperLimit = -9999.0f;

    public GribGridRecord() {
    }

    GribGridRecord(Calendar calendar, SimpleDateFormat dateFormat, String productTypeS, String disciplineS, String categoryS, String paramS, String typeGenProcessS, String levelType1S, String levelValue1S, String levelType2S, String levelValue2S, String refTimeS, String foreTimeS, String gdsKeyS, String offset1S, String offset2S, String decimalScaleS, String bmsExistsS, String centerS, String subCenterS, String tableS) {
        try {
            this.gdsKey = Integer.parseInt(gdsKeyS);
            this.productType = Integer.parseInt(productTypeS);
            this.discipline = Integer.parseInt(disciplineS);
            this.category = Integer.parseInt(categoryS);
            this.paramNumber = Integer.parseInt(paramS);
            this.typeGenProcess = Integer.parseInt(typeGenProcessS);
            this.levelType1 = Integer.parseInt(levelType1S);
            this.levelValue1 = Float.parseFloat(levelValue1S);
            this.levelType2 = Integer.parseInt(levelType2S);
            this.levelValue2 = Float.parseFloat(levelValue2S);
            this.refTime = dateFormat.parse(refTimeS);
            this.forecastTime = Integer.parseInt(foreTimeS);
            calendar.setTime(this.refTime);
            calendar.add(10, this.forecastTime);
            this.validTime = calendar.getTime();
            this.offset1 = Long.parseLong(offset1S);
            this.offset2 = Long.parseLong(offset2S);
            if (decimalScaleS != null) {
                this.decimalScale = Integer.parseInt(decimalScaleS);
            }
            if (bmsExistsS != null) {
                this.bmsExists = bmsExistsS.equals("true");
            }
            if (centerS != null) {
                this.center = Integer.parseInt(centerS);
            }
            if (subCenterS != null) {
                this.subCenter = Integer.parseInt(subCenterS);
            }
            if (tableS != null) {
                this.table = Integer.parseInt(tableS);
            }
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(e);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public double getLevel1() {
        return this.levelValue1;
    }

    public double getLevel2() {
        return this.levelValue2;
    }

    public int getLevelType1() {
        return this.levelType1;
    }

    public int getLevelType2() {
        return this.levelType2;
    }

    public Date getReferenceTime() {
        return this.refTime;
    }

    public Date getValidTime() {
        return this.validTime;
    }

    public void setValidTime(Date t) {
        this.validTime = t;
    }

    public int getValidTimeOffset() {
        return this.forecastTime;
    }

    public String getParameterName() {
        return null;
    }

    public int getGridDefRecordIdInt() {
        return this.gdsKey;
    }

    public String getGridDefRecordId() {
        return Integer.toString(this.gdsKey);
    }

    public int getGridNumber() {
        return 0;
    }

    public int getDecimalScale() {
        return this.decimalScale;
    }

    public boolean isEnsemble() {
        return this.isEnsemble;
    }

    public int getEnsembleType() {
        return this.type;
    }

    public int getEnsembleNumber() {
        return this.ensembleNumber;
    }

    public int getNumberForecasts() {
        return this.numberForecasts;
    }

    public String toString() {
        return "GribGridRecord{productType=" + this.productType + ", discipline=" + this.discipline + ", category=" + this.category + ", paramNumber=" + this.paramNumber + ", typeGenProcess=" + this.typeGenProcess + ", levelType1=" + this.levelType1 + ", levelType2=" + this.levelType2 + ", levelValue1=" + this.levelValue1 + ", levelValue2=" + this.levelValue2 + ", gdsKey=" + this.gdsKey + ", offset1=" + this.offset1 + ", offset2=" + this.offset2 + ", refTime=" + this.refTime + ", forecastTime=" + this.forecastTime + ", decimalScale=" + this.decimalScale + ", bmsExists=" + this.bmsExists + ", center=" + this.center + ", subCenter=" + this.subCenter + ", table=" + this.table + ", validTime=" + this.validTime + '}';
    }
}

