/* This file has been automatically generated by builder part of the ferite distribution */
/* file:  sys_Sys_Dir.c */
/* class: Dir */

#include <ferite.h>       /* we need this without a doubt */
#include "sys_header.h"  /* this is the module header */

FE_NATIVE_FUNCTION( ferite_sys_Sys_Dir_readdir_ )
{
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   { /* Main function body. */
#line 1096 "posix.fec"

       
           struct dirent *de;
           FeriteVariable *fv;

           if(!self->odata)
           {
               ferite_set_error(script, EBADF, "The directory stream is not"
                                "open");
               fv = ferite_create_string_variable_from_ptr(script, "", "",
                                                           0, FE_CHARSET_DEFAULT, FE_STATIC);
               FE_RETURN_VAR(fv);
           }

           errno = 0;
           if(!(de = readdir((DIR *)self->odata)))
           {
               if(errno)
                 ferite_set_error(script, errno, "%s", strerror(errno));
               else ferite_set_error(script, 0, "");
               fv = ferite_create_string_variable_from_ptr(script, "", "",
                                                           0, FE_CHARSET_DEFAULT, FE_STATIC);
           }
           else
           {
               fv = ferite_create_string_variable_from_ptr(script,
                                                           "Sys::Dir::readdir", de->d_name, 0,
                                                           FE_CHARSET_DEFAULT, FE_STATIC);
           }
           FE_RETURN_VAR(fv);
       
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_Dir_destructor_ )
{
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   { /* Main function body. */
#line 1163 "posix.fec"

       
           if(self->odata)
           {
               closedir((DIR *)self->odata);
               self->odata = NULL;
           }
       
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_Dir_constructor_s )
{
   FeriteString *directory;
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   ferite_get_parameters( params, 1, &directory );

   { /* Main function body. */
#line 1073 "posix.fec"

       
           if(self->odata) closedir((DIR *)self->odata);
           if(!(self->odata = opendir(directory->data)))
           {
               ferite_set_error(script, errno, "%s", strerror(errno));
               FE_RETURN_NULL_OBJECT;
           }
       
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

