/* This file has been automatically generated by builder part of the ferite distribution */
/* file: string_String.c */
/* namespace: String */

#include <ferite.h>       /* we need this without a doubt */
#include "string_header.h"  /* this is the module header */

FE_NATIVE_FUNCTION( string_String_toHex_s )
{
   FeriteString *s;

   ferite_get_parameters( params, 1, &s );

   { /* Main function body. */
#line 111 "string.fec"

    
        int i;
	char *p;
	FeriteString *str;
	FeriteVariable *fv;
	if(!(str = ferite_str_new(NULL, s->length * 2,
					FE_CHARSET_DEFAULT))) {
	    FE_RETURN_NULL_OBJECT;
	}
	p = str->data;
	for(i = 0; i < s->length; i++) {
		sprintf(p, "%.2x", (unsigned char)s->data[i]);
		p += 2;
	}
	FE_RETURN_STR(str, FE_TRUE);
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( string_String_escape_s )
{
   FeriteString *str;

   ferite_get_parameters( params, 1, &str );

   { /* Main function body. */
#line 1048 "string.fec"

    
        FeriteVariable *ret;
        char tmp[5], *buf, *newbuf;
        int i, len, bufsiz = 256, buflen = 0;

        if(str->length == 0 || !(buf = fmalloc(bufsiz))) {
            ret = ferite_create_string_variable_from_ptr(script, NULL, "", 0,
                                               FE_CHARSET_DEFAULT, FE_STATIC);
            FE_RETURN_VAR(ret);
        }

        for(i = 0; i < str->length; i++) {

            /* Initialising these two here assuming that it is going to be a
             * letter escape sequence saves two lines of code for each of
             * the letter escape sequences below: */
            len = 2;
            tmp[0] = '\\';

            switch(str->data[i]) {
                /* Handle all of the letter escapes first: */
                case '\a':
                    tmp[1] = 'a';
                    break;
                case '\b':
                    tmp[1] = 'b';
                    break;
                case '\f':
                    tmp[1] = 'f';
                    break;
                case '\n':
                    tmp[1] = 'n';
                    break;
                case '\r':
                    tmp[1] = 'r';
                    break;
                case '\t':
                    tmp[1] = 't';
                    break;
                case '\v':
                    tmp[1] = 'v';
                    break;
                case '\\':
                    tmp[1] = '\\';
                    break;
                case '\?':
                    tmp[1] = '\?';
                    break;
                case '\'':
                    tmp[1] = '\'';
                    break;
                case '\"':
                    tmp[1] = '\"';
                    break;
                default:
                    /* Handle any remaining non-printable characters by
                     * converting them to a hex escape number: */
                    if(!isprint(str->data[i])) {
                        len = snprintf(tmp, 5, "\\x%.2x",
                                (unsigned char)str->data[i]);
                    } else {
                        /* Anything else is included directly: */
                        tmp[0] = str->data[i];
                        len = 1;
                    }
                    break;
            }

            /* Expand the output buffer if necessary: */
            if(buflen + len > bufsiz) {
                bufsiz *= 2;
                /* Shouldn't really happen, but handle it if it does: */
                if(buflen + len > bufsiz) bufsiz += len;
		if(!(newbuf = frealloc(buf, bufsiz))) {
                    ffree(buf);
                    ret = ferite_create_string_variable_from_ptr(script, NULL,
                                         "", 0, FE_CHARSET_DEFAULT, FE_STATIC);
                    FE_RETURN_VAR(ret);
                } else buf = newbuf;
            }

	    memcpy(&buf[buflen], tmp, len);
	    buflen += len;
        }

        ret = ferite_create_string_variable_from_ptr(script, "String:escape",
                                  buf, buflen, FE_CHARSET_DEFAULT, FE_STATIC);
        ffree(buf);
	FE_RETURN_VAR(ret);
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( string_String_postTrim_ss )
{
   FeriteString *str;
   FeriteString *delims;

   ferite_get_parameters( params, 2, &str, &delims );

   { /* Main function body. */
#line 514 "string.fec"

    
        int j = 0;
        char *p = NULL;
        FeriteVariable *var = NULL;

        for( j = str->length ; j > 0 ; j-- )
        {
	    /* FIXME Change this after code defrost:
            if( memchr(delims->data, str->data[i], delims->length) == NULL ) */
            if( strchr(delims->data, str->data[j]) == NULL )
              break;
        }
	if( str->length > 0 )
	  j++;
	
        p = ( j == 0) ? "" : str->data;
        var = fe_new_str_static( "string::postTrim", str->data, j, FE_CHARSET_DEFAULT );
        FE_RETURN_VAR( var );
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( string_String_trim_ss )
{
   FeriteString *str;
   FeriteString *delims;

   ferite_get_parameters( params, 2, &str, &delims );

   { /* Main function body. */
#line 449 "string.fec"

    
        int i,j;
        char *p;
        FeriteVariable *var;

        for( i = 0 ; i < str->length ; i++ )
        {
	    /* FIXME Change this after code defrost:
            if( memchr(delims->data, str->data[i], delims->length) == NULL ) */
            if( strchr(delims->data, str->data[i]) == NULL )
              break;
        }
        for( j = str->length ; j > i-1 ; j-- )
        {
	    /* FIXME Change this after code defrost:
            if( memchr(delims->data, str->data[i], delims->length) == NULL ) */
            if( strchr(delims->data, str->data[j]) == NULL )
              break;
        }
        j++;
        p = ( j - i == 0) ? "" : str->data + i;
        var = fe_new_str_static( "string::trim", p, j - i, FE_CHARSET_DEFAULT );
        FE_RETURN_VAR( var );
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( string_String___isfmt_s )
{
   FeriteString *s;

   ferite_get_parameters( params, 1, &s );

   { /* Main function body. */
#line 956 "string.fec"

    
        char fmts[] = "diouxXfeEgGaAcCsS";

        if(!s->data[0] || !strchr(fmts, s->data[0])) {
	    FE_RETURN_FALSE;
	}
	FE_RETURN_TRUE;
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( string_String_isprint_s )
{
   FeriteString *s;

   ferite_get_parameters( params, 1, &s );

   { /* Main function body. */
#line 839 "string.fec"

    
        if(s->length > 0 && isprint(s->data[0])) {
	    FE_RETURN_TRUE;
	}
	FE_RETURN_FALSE;
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( string_String_isdigit_s )
{
   FeriteString *s;

   ferite_get_parameters( params, 1, &s );

   { /* Main function body. */
#line 731 "string.fec"

    
        if(s->length > 0 && isdigit(s->data[0])) {
	    FE_RETURN_TRUE;
	}
	FE_RETURN_FALSE;
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( string_String_isgraph_s )
{
   FeriteString *s;

   ferite_get_parameters( params, 1, &s );

   { /* Main function body. */
#line 820 "string.fec"

    
        if(s->length > 0 && isgraph(s->data[0])) {
	    FE_RETURN_TRUE;
	}
	FE_RETURN_FALSE;
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( string_String_toNumber_s )
{
   FeriteString *s;

   ferite_get_parameters( params, 1, &s );

   { /* Main function body. */
#line 236 "string.fec"

    
        long l;
	double d;
	char *ep;

        if(s->length) {
            errno = 0;
            l = strtol(s->data, &ep, 0);
	    if(errno != ERANGE && *ep == 0) FE_RETURN_LONG(l); 
            errno = 0;
            d = strtod(s->data, &ep);
            if(errno == ERANGE) {
                ferite_set_error(script, errno, "%s", strerror(errno));
		FE_RETURN_DOUBLE(d);
            }
	}

	if(!s->length || *ep != 0) {
            ferite_set_error(script, EINVAL, "String does not represent a "
	    						"valid number");
	    FE_RETURN_LONG(0);
	}

        ferite_set_error(script, 0, "");
        FE_RETURN_DOUBLE(d);
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( string_String_preTrim_ss )
{
   FeriteString *str;
   FeriteString *delims;

   ferite_get_parameters( params, 2, &str, &delims );

   { /* Main function body. */
#line 486 "string.fec"

    
        int i;
        char *p;
        FeriteVariable *var;
        for( i = 0 ; i < str->length ; i++ )
        {
	    /* FIXME Change this after code defrost:
            if( memchr(delims->data, str->data[i], delims->length) == NULL ) */
            if( strchr(delims->data, str->data[i]) == NULL )
              break;
        }
        p = ( str->length - i == 0) ? "" : str->data + i;
        var = fe_new_str_static( "string::preTrim", p, str->length - i , FE_CHARSET_DEFAULT );
        FE_RETURN_VAR( var );
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( string_String_blocks_sn )
{
   FeriteString *str;
   double size;

   ferite_get_parameters( params, 2, &str, &size );

   { /* Main function body. */
#line 1324 "string.fec"

    
	FeriteVariable *fv, *ret;
	long i, len, lsize = (long)size, asize;

        if(lsize < 1) {
            ret = ferite_create_uarray_variable(script, NULL, 0, FE_STATIC);
            FE_RETURN_VAR(ret);
        }

        asize = str->length / lsize;
	if(str->length % lsize) asize++;

        if(!(ret = ferite_create_uarray_variable(script, "String:blocks",
                                                        asize, FE_STATIC))) {
            FE_RETURN_VOID;
        }

        for(i = 0; i < str->length; i += len) {
            len = str->length - i;
            if(len > lsize) len = lsize;
            fv = ferite_create_string_variable_from_ptr(script,
                                     "String::blocks", &str->data[i], len,
                                            FE_CHARSET_DEFAULT, FE_STATIC);
            if(fv) {
                ferite_uarray_add(script, VAUA(ret), fv, NULL,
                                          FE_ARRAY_ADD_AT_END);
            }
        }

	FE_RETURN_VAR(ret);
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( string_String_toLower_s )
{
   FeriteString *str;

   ferite_get_parameters( params, 1, &str );

   { /* Main function body. */
#line 546 "string.fec"

    
        FeriteVariable *var;
        FeriteString *s;
        int i;

        var = ferite_create_string_variable( script, "string::toLower", str, FE_STATIC );
        s = VAS(var);
        for( i = 0 ; i < s->length ; i++ )
        {
            s->data[i] = tolower( s->data[i] );
        }
        FE_RETURN_VAR( var );
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( string_String_length_s )
{
   FeriteString *str;

   ferite_get_parameters( params, 1, &str );

   { /* Main function body. */
#line 59 "string.fec"

    
        FE_RETURN_LONG( str->length );
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( string_String_nCompareCase_ssn )
{
   FeriteString *a;
   FeriteString *b;
   double max;

   ferite_get_parameters( params, 3, &a, &b, &max );

   { /* Main function body. */
#line 641 "string.fec"

    
        int result;

        result = ferite_str_ncmp(a, b, (size_t)max);
        FE_RETURN_LONG( (long)result );
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( string_String_toUpper_s )
{
   FeriteString *str;

   ferite_get_parameters( params, 1, &str );

   { /* Main function body. */
#line 572 "string.fec"

    
        FeriteVariable *var;
        FeriteString *s;
        int i;

        var = ferite_create_string_variable( script, "string::toUpper", str, FE_STATIC );
        s = VAS(var);
        for( i = 0 ; i < s->length ; i++ )
        {
            s->data[i] = toupper( s->data[i] );
        }
        FE_RETURN_VAR( var );
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( string_String_nCompareNoCase_ssn )
{
   FeriteString *a;
   FeriteString *b;
   double max;

   ferite_get_parameters( params, 3, &a, &b, &max );

   { /* Main function body. */
#line 663 "string.fec"

    
        int result;

        result= ferite_str_case_ncmp(a, b, (size_t)max);
        FE_RETURN_LONG( (long)result );
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( string_String_toDouble_s )
{
   FeriteString *str;

   ferite_get_parameters( params, 1, &str );

   { /* Main function body. */
#line 75 "string.fec"

    
        double value;
        value = atof( str->data );
        FE_RETURN_DOUBLE( value );
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( string_String_ispunct_s )
{
   FeriteString *s;

   ferite_get_parameters( params, 1, &s );

   { /* Main function body. */
#line 783 "string.fec"

    
        if(s->length > 0 && ispunct(s->data[0])) {
	    FE_RETURN_TRUE;
	}
	FE_RETURN_FALSE;
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( string_String_isalnum_s )
{
   FeriteString *s;

   ferite_get_parameters( params, 1, &s );

   { /* Main function body. */
#line 748 "string.fec"

    
        if(s->length > 0 && isalnum(s->data[0])) {
	    FE_RETURN_TRUE;
	}
	FE_RETURN_FALSE;
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( string_String_dissect_ssn )
{
   FeriteString *s;
   FeriteString *d;
   double limit;

   ferite_get_parameters( params, 3, &s, &d, &limit );

   { /* Main function body. */
#line 299 "string.fec"

    
        int cuts = 0;
	FeriteString *fs;
        int left, right, i;
	FeriteVariable *a, *fv;

        if(!(a = ferite_create_uarray_variable(script, "string::split", 0,
                                                               FE_STATIC))) {
	    FE_RETURN_NULL_OBJECT;
	}

        for(left = right = 0; right < s->length; right++) {
            for(i = 0; i < d->length; i++) {
	        if(s->data[right] == d->data[i]) {
		    if((right - left) > 0) {
		        fv = ferite_create_string_variable_from_ptr(script,
					"", s->data + left, right - left,
					FE_CHARSET_DEFAULT, FE_STATIC);
                        ferite_uarray_add(script, VAUA(a), fv, NULL,
						FE_ARRAY_ADD_AT_END);
			cuts++;
		    }
		    left = right + 1;
		    break;
		}
	    }
	    if(limit > 0 && cuts == (int)limit) break;
	}

        /* Handle anything left on the end of the string: */
        if((s->length - left) > 0) {
            fv = ferite_create_string_variable_from_ptr(script, "",
	    				s->data + left, s->length - left,
					FE_CHARSET_DEFAULT, FE_STATIC);
            ferite_uarray_add(script, VAUA(a), fv, NULL, FE_ARRAY_ADD_AT_END);
        }

        FE_RETURN_VAR(a);
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( string_String_index_ss )
{
   FeriteString *a;
   FeriteString *b;

   ferite_get_parameters( params, 2, &a, &b );

   { /* Main function body. */
#line 182 "string.fec"

    
        FE_RETURN_LONG( ferite_find_string( a->data, b->data ) );
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( string_String_pad_sns )
{
   FeriteString *str;
   double pad;
   FeriteString *padchar;

   ferite_get_parameters( params, 3, &str, &pad, &padchar );

   { /* Main function body. */
#line 1272 "string.fec"

    
        unsigned char pch;
        FeriteVariable *ret;
        long lpad = (long)pad;

        if(lpad <= str->length) {
            ret = ferite_create_string_variable(script, "String::pad", str,
                                                                  FE_STATIC);
            FE_RETURN_VAR(ret);
        }

        if(!(ret = ferite_create_string_variable_from_ptr(script, "String::pad",
                                  NULL, lpad, FE_CHARSET_DEFAULT, FE_STATIC))) {
            FE_RETURN_VOID;
        }

        memcpy(VAS(ret)->data, str->data, str->length);
        if(padchar->length < 1) pch = ' ';
        else pch = padchar->data[0];
        memset(&VAS(ret)->data[str->length], pch, lpad - str->length);

        FE_RETURN_VAR(ret);
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( string_String_isNumber_s )
{
   FeriteString *s;

   ferite_get_parameters( params, 1, &s );

   { /* Main function body. */
#line 202 "string.fec"

    
        char *ep;

	errno = 0;
	if(s->length == 0) FE_RETURN_FALSE;
	strtod(s->data, &ep);
	if(errno == ERANGE || *ep != 0) {
	    FE_RETURN_FALSE;
	} else {
	    FE_RETURN_TRUE;
	}
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( string_String_isalpha_s )
{
   FeriteString *s;

   ferite_get_parameters( params, 1, &s );

   { /* Main function body. */
#line 680 "string.fec"

    
        if(s->length > 0 && isalpha(s->data[0])) {
	    FE_RETURN_TRUE;
	}
	FE_RETURN_FALSE;
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( string_String_compareCase_ss )
{
   FeriteString *a;
   FeriteString *b;

   ferite_get_parameters( params, 2, &a, &b );

   { /* Main function body. */
#line 598 "string.fec"

    
        int result;

	/* FIXME This should do something like if(result) FE_RETURN_FALSE();
	 * to ensure that the correct value is returned. The following
	 * functions have the same problem. */
        result = ferite_str_cmp(a, b);
        FE_RETURN_LONG( (long)result );
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( string_String_charToNum_s )
{
   FeriteString *s;

   ferite_get_parameters( params, 1, &s );

   { /* Main function body. */
#line 165 "string.fec"

    
        if(s->length == 0) {
		FE_RETURN_LONG(-1);
	} else {
		FE_RETURN_LONG((long)s->data[0]);
	}
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( string_String_compareNoCase_ss )
{
   FeriteString *a;
   FeriteString *b;

   ferite_get_parameters( params, 2, &a, &b );

   { /* Main function body. */
#line 621 "string.fec"

    
        int result;

        result = ferite_str_case_cmp(a, b);
        FE_RETURN_LONG( (long)result );
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( string_String_islower_s )
{
   FeriteString *s;

   ferite_get_parameters( params, 1, &s );

   { /* Main function body. */
#line 697 "string.fec"

    
        if(s->length > 0 && islower(s->data[0])) {
	    FE_RETURN_TRUE;
	}
	FE_RETURN_FALSE;
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( string_String_numToChar_n )
{
   double n;

   ferite_get_parameters( params, 1, &n );

   { /* Main function body. */
#line 140 "string.fec"

    
        unsigned char c;
        FeriteString *str;

        if((long)n < 0 || (long)n > 255) {
	    str = ferite_str_new(NULL, 0, FE_CHARSET_DEFAULT);
	    FE_RETURN_STR(str, FE_TRUE);
	} else c = (unsigned char)n;

        if(!(str = ferite_str_new(&c, 1, FE_CHARSET_DEFAULT))) {
	    FE_RETURN_NULL_OBJECT;
	}
        FE_RETURN_STR(str, FE_TRUE);
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( string_String_toLong_s )
{
   FeriteString *str;

   ferite_get_parameters( params, 1, &str );

   { /* Main function body. */
#line 94 "string.fec"

    
        long value;
        value = atol( str->data );
        FE_RETURN_LONG( value );
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( string_String_isupper_s )
{
   FeriteString *s;

   ferite_get_parameters( params, 1, &s );

   { /* Main function body. */
#line 714 "string.fec"

    
        if(s->length > 0 && isupper(s->data[0])) {
	    FE_RETURN_TRUE;
	}
	FE_RETURN_FALSE;
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( string_String_iscntrl_s )
{
   FeriteString *s;

   ferite_get_parameters( params, 1, &s );

   { /* Main function body. */
#line 857 "string.fec"

    
        if(s->length > 0 && iscntrl(s->data[0])) {
	    FE_RETURN_TRUE;
	}
	FE_RETURN_FALSE;
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( string_String_unescape_s )
{
   FeriteString *str;

   ferite_get_parameters( params, 1, &str );

   { /* Main function body. */
#line 1147 "string.fec"

    
        long l;
	int i, buflen = 0;
	FeriteVariable *ret;
	unsigned char *buf, c, tmp[4];

        /* We know the output can't be longer than the input when unescaping: */
        if(str->length == 0 || !(buf = fmalloc(str->length))) {
            ret = ferite_create_string_variable_from_ptr(script, NULL, "", 0,
                                               FE_CHARSET_DEFAULT, FE_STATIC);
            FE_RETURN_VAR(ret);
        }

        for(i = 0; i < str->length; i++) {
            /* Check if this is the start of an escape sequence (being careful
             * to handle the special case of the string ending with a single
             * backslash): */
            if(str->data[i] == '\\' && i < str->length - 1) {
                switch(str->data[++i]) {
                    /* Handle all the single letter escapes: */
                    case 'a':
                        c = '\a';
                        break;
                    case 'b':
                        c = '\b';
                        break;
                    case 'f':
                        c = '\f';
                        break;
                    case 'n':
                        c = '\n';
                        break;
                    case 'r':
                        c = '\r';
                        break;
                    case 't':
                        c = '\t';
                        break;
                    case 'v':
                        c = '\v';
                        break;
                    case '\\':
                        c = '\\';
                        break;
                    case '?':
                        c = '?';
                        break;
                    case '\'':
                        c = '\'';
                        break;
                    case '"':
                        c = '"';
                        break;
                    /* Handle hex numbers: */
                    case 'x':
                        /* We can safely do this because we know that
                         * str->data[str->length] is always '\0': */
                        if(isxdigit(str->data[i + 1])) {
                            tmp[0] = str->data[++i];
                            if(isxdigit(str->data[i + 1])) {
                                tmp[1] = str->data[++i];
                                tmp[2] = '\0';
                            } else tmp[1] = '\0'; /* Only one hex digit */
                            l = strtol(tmp, NULL, 16);
                            if(l > 255 || l < 0) c = 0; /* Shouldn't happen */
                            else c = (unsigned char)l;
                        } else c = 'x'; /* No hex digits after the x */
                        break;
                    /* Handle octal numbers: */
                    case '0':
                    case '1':
                    case '2':
                    case '3':
                    case '4':
                    case '5':
                    case '6':
                    case '7':
                        tmp[0] = str->data[i];
                        tmp[1] = str->data[i + 1];
                        if(tmp[1] >= '0' && tmp[1] <= '7') {
                            i++;
                            tmp[2] = str->data[i + 1];
                            if(tmp[2] >= '0' && tmp[2] <= '7') {
                                i++;
                                tmp[3] = '\0'; /* Three octal digits */
                            } else tmp[2] = '\0'; /* Two octal digits */
                        } else tmp[1] = '\0'; /* One octal digit */
                        l = strtol(tmp, NULL, 8);
                        if(l > 255 || l < 0) c = 0;
                        else c = (unsigned char)l;
                        break;
                    /* Anything else just gets copied straight through: */
                    default:
                        c = str->data[i];
                        break;
                }
            } else c = str->data[i];
            buf[buflen++] = c;
        }

        ret = ferite_create_string_variable_from_ptr(script, "String:unescape",
                                    buf, buflen, FE_CHARSET_DEFAULT, FE_STATIC);
        ffree(buf);
        FE_RETURN_VAR(ret);
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( string_String___printvar_sv )
{
   FeriteString *fmt;
   FeriteVariable *var = params[1];

   ferite_get_parameters( params, 2, &fmt, NULL );

   { /* Main function body. */
#line 874 "string.fec"

    
	long l;
        int ret;
	double d;
	char *buf;
	unsigned char c;
	int buflen = 256;
	FeriteString *fs;
	FeriteVariable *fv;

	if(fmt->length == 0 || !var || !(buf = fmalloc(buflen))) goto err2;

        do {
	    switch(fmt->data[fmt->length - 1]) {
	        case 'd':
		case 'i':
		case 'o':
		case 'u':
		case 'x':
		case 'X':
		    if(var->type == F_VAR_LONG) l = VAI(var);
		    else if(var->type == F_VAR_DOUBLE) l = (long)VAF(var);
		    else goto err1;
		    ret = snprintf(buf, buflen, fmt->data, l);
		    break;
		case 'f':
		case 'e':
		case 'E':
		case 'g':
		case 'G':
		case 'a':
		case 'A':
		    if(var->type == F_VAR_LONG) d =(double)VAI(var);
		    else if(var->type == F_VAR_DOUBLE) d = VAF(var);
		    else goto err1;
		    ret = snprintf(buf, buflen, fmt->data, d);
		    break;
		case 'c':
		case 'C':
		    if(var->type == F_VAR_LONG) c = (unsigned char)VAI(var);
		    else if(var->type == F_VAR_DOUBLE) c = (unsigned char)VAF(var);
		    else if(var->type == F_VAR_STR) {
		    	fs = VAS(var);
			if(fs->length == 0) goto err1;
			else c = fs->data[0];
		    } else goto err1;
		    ret = snprintf(buf, buflen, fmt->data, c);
		    break;
		case 's':
		case 'S':
                    if(var->type == F_VAR_STR) fs = VAS(var);
		    else goto err1;
		    ret = snprintf(buf, buflen, fmt->data, fs->data);
		    break;
		default:
		    goto err1;
	    }
	    /* Here we have to deal both with versions of snprintf() which
	     * return -1 if the buffer isn't long enough and versions which
	     * return the length of text that would have been generated if the
	     * buffer had been long enough. */
            if(ret > -1 && ret < buflen) break;
            else if(ret > -1) buflen = ret + 1;
	    else buflen *= 2;
	} while((buf = frealloc(buf, buflen)));

	if(!buf) goto err2;

        fv = ferite_create_string_variable_from_ptr(script, "", buf, ret,
                                             FE_CHARSET_DEFAULT, FE_STATIC);
        ffree(buf);
        FE_RETURN_VAR(fv);

err1:   ffree(buf);
err2:   fv = ferite_create_string_variable_from_ptr(script, "", "", 0,
                                             FE_CHARSET_DEFAULT, FE_STATIC);
        FE_RETURN_VAR(fv);
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( string_String_isspace_s )
{
   FeriteString *s;

   ferite_get_parameters( params, 1, &s );

   { /* Main function body. */
#line 801 "string.fec"

    
        if(s->length > 0 && isspace(s->data[0])) {
	    FE_RETURN_TRUE;
	}
	FE_RETURN_FALSE;
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( string_String_toArray_ssn )
{
   FeriteString *str;
   FeriteString *delims;
   double limit;

   ferite_get_parameters( params, 3, &str, &delims, &limit );

   { /* Main function body. */
#line 391 "string.fec"

    
        int splits = 0;
        char *name = NULL;
        FeriteVariable *array = NULL, *vstr = NULL;
        int i = 0, j = 0, start = 0;

        if( str->length > 0 && delims->length > 0 )
        {
            name = FE_CLEAN_STRING(str->length+1);
            array = ferite_create_uarray_variable( script, "string::toArray", 100, FE_STATIC );
            
            for( i = 0; i < str->length; i++ )
            {
                if( str->data[i] == delims->data[0] )
                {
                    for( j = 0; delims->data[j] == str->data[j+i] && (j+i) < str->length && j < delims->length; j++ )
                      ;
                    if( j == delims->length )
                    {
                        strncpy( name, str->data+start, i - start ); /* copy the data */
						name[i-start] = '\0';
                        vstr = ferite_create_string_variable_from_ptr( script, "", name, strlen(name), FE_CHARSET_DEFAULT, FE_STATIC );
                        ferite_uarray_add( script, VAUA(array), vstr, NULL, FE_ARRAY_ADD_AT_END );
                        start = i + j;
                        i += j - 1;
			splits++;
                    }                    
                }
		if(limit > 0 && splits == (int)limit) break;
            }
            if( start < str->length )
            {
                strncpy( name, str->data+start, str->length - start ); /* copy the data */
				name[str->length - start] = '\0';
                vstr = ferite_create_string_variable_from_ptr( script, "", name, strlen(name), FE_CHARSET_DEFAULT, FE_STATIC );
                ferite_uarray_add( script, VAUA(array), vstr, NULL, FE_ARRAY_ADD_AT_END );
            }
            ffree( name );
            FE_RETURN_VAR( array );
        }
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( string_String_isxdigit_s )
{
   FeriteString *s;

   ferite_get_parameters( params, 1, &s );

   { /* Main function body. */
#line 765 "string.fec"

    
        if(s->length > 0 && isxdigit(s->data[0])) {
	    FE_RETURN_TRUE;
	}
	FE_RETURN_FALSE;
    
   }
   FE_RETURN_VOID;
}

