/* -*- mode: c++; coding: utf-8; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4; show-trailing-whitespace: t -*- vim:fenc=utf-8:ft=tcl:et:sw=4:ts=4:sts=4

  This file is part of the Feel library

  Author(s): Christophe Prud'homme <christophe.prudhomme@feelpp.org>
       Date: 2013-12-16 Feel++ Consortium

  Copyright (C) 2013 Feel++ Consortium

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3.0 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
/**
   \file test_lag.cpp
   \author Christophe Prud'homme <christophe.prudhomme@feelpp.org>
   \date 2005-10-12
 */
#define BOOST_TEST_MODULE lagrange polynomials on hypercube test
// Boost.Test
#define USE_TEST 1
#include <boost/test/unit_test.hpp>
using boost::unit_test::test_suite;

#include <feel/feelpoly/lagrange.hpp>
#include <feel/feelpoly/im.hpp>

BOOST_AUTO_TEST_SUITE( lagrange_testsuite )

BOOST_AUTO_TEST_CASE( lag11scr64s )
{
    using namespace Feel;
    typedef Feel::fem::Lagrange<2, 1, 1, Scalar, Continuous, real64_type, Hypercube> fe_t;
    fe_t fe;
    BOOST_TEST_MESSAGE( "Lagrange Q" << fe_t::nOrder << " in  " << fe_t::nDim << "D" );
    BOOST_TEST_MESSAGE( "pts: " << fe.points() );
    ublas::vector<double> error( fe_t::nDim );
    ublas::vector<fe_t::matrix_type> der( fe.derivate( fe.points() ) );
    std::cout << "der = " << der << "\n";
    for ( int i = 0; i < fe_t::nDim; ++i )
        error[i] = ublas::norm_frobenius( der[i] - fe.derivate( i ).evaluate( fe.points() ) );

    BOOST_TEST_MESSAGE( "[checkDiff] Lagrange " << " dim : " << fe_t::nDim
                        << " order : " << fe_t::nOrder << " error: " << error   );
    BOOST_CHECK( ublas::norm_inf( error ) < 1e-10 );

}
BOOST_AUTO_TEST_SUITE_END()

