/* Various Thresholds of MPFR, not exported.

Copyright 2005, 2009  Free Software Foundation, Inc.

This file is part of the MPFR Library.

The MPFR Library is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 3.0 of the License, or (at your
option) any later version.

The MPFR Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
License for more details.

You should have received a copy of the GNU Lesser General Public License
along with the MPFR Library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
MA 02111-1307, USA. */

#ifndef __MPFR_IMPL_H__
# error "MPFR Internal not included"
#endif

/*****************************
 * Threshold for Pentium 4   *
 *****************************/
#if defined (__pentium4)

#define MPFR_MULHIGH_TAB  \
 -1,0,-1,0,-1,0,0,-1,0,-1,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 40,0,0,48,0,0,0,0,0,0,0,0,0,0,48,44, \
 56,0,56,0,46,0,0,56,56,68,52,54,56,56,54,60, \
 56,56,72,60,64,60,80,71,60,88,79,62,60,64,80,72, \
 95,60,78,80,80,65,80,64,96,80,96,80,66,88,96,66, \
 68,68,96,88,95,95,96,94,94,86,96,94,96,95,96,95, \
 96,96,95,96,95,92,96,92,96,112,111,112,111,112,112,111, \
 108,111,128,112,110,112,112,104,112,112,111,112,111,143,126,112, \
 128,112,128,144,127,127,128,112,128,128,120,124,126,120,110,128, \
 120,128,143,126,128,128,126,128,135,128,128,128,111,112,134,127, \
 134,127,128,111,112,125,126,167,134,185,125,126,127,165,125,128, \
 128,125,144,127,166,129,130,168,144,167,168,126,127,128,129,167, \
 168,167,168,143,166,165,164,167,166,167,168,163,191,184,166,167, \
 168,165,166,166,167,168,166,166,167,168,166,167,168,189,188,189, \
 190,164,192,203,167,168,190,175,192,188,190,187,188,192,167,191, \
 188,189,190,191,239,192,168,186,187,188,189,190,191,192,168,165, \
 233,189,166,239,192,167,191,191,190,191,191,189,186,191,188,166, \
 282,191,192,167,190,191,188,191,190,189,192,191,192,188,189,188, \
 240,190,191,192,185,189,189,186,235,192,188,238,191,191,240,232, \
 189,187,191,189,287,287,189,191,191,281,284,192,283,283,190,285, \
 286,287,288,288,284,285,287,282,285,284,201,239,283,281,282,192, \
 284,285,286,287,288,288,240,282,239,284,285,286,287,288,288,284, \
 334,286,335,284,284,334,287,284,285,283,288,281,325,287,280,335, \
 334,335,336,285,286,288,335,331,331,333,334,335,335,336,334,379, \
 335,336,334,287,336,280,329,283,282,334,286,334,335,335,336,281, \
 285,286,334,286,286,334,334,287,334,335,336,336,330,335,332,329, \
 334,287,334,334,332,335,332,331,334,332,332,335,336,332,334,334, \
 334,336,336,336,331,328,330,334,333,334,334,334,334,335,336,336, \
 333,334,329,334,334,332,331,335,333,333,335,336,336,329,332,333, \
 334,335,336,335,334,332,376,334,335,336,380,335,333,334,379,331, \
 335,332,383,376,336,336,379,334,383,335,336,384,376,376,379,378, \
 334,335,378,378,334,380,384,331,376,376,376,377,380,377,381,377, \
 376,376,380,336,379,380,384,379,377,384,377,378,376,376,381,378, \
 377,384,379,378,384,334,379,384,381,378,381,377,378,379,380,381, \
 378,383,380,381,376,383,384,372,376,377,378,379,377,381,379,378, \
 381,378,383,384,378,376,377,381,376,383,383,379,380,381,382,376, \
 384,376,376,336,381,503,380,376,376,377,378,377,380,376,377,379, \
 384,376,378,500,380,384,383,502,380,381,382,379,502,496,496,381, \
 382,499,497,500,501,496,382,498,498,496,381,496,499,497,379,500, \
 497,498,498,500,498,502,496,495,502,496,497,498,499,500,498,502, \
 503,496,493,498,495,496,496,499,497,504,488,496,498,503,498,496, \
 502,495,496,496,501,496,496,497,498,503,500,501,497,497,498,499, \
 496,497,502,499,500,494,497,503,501,502,496,497,498,499,568,496, \
 496,496,496,576,498,499,502,496,502,570,496,497,504,499,568,502, \
 496,497,570,500,500,575,504,500,576,570,569,502,573,568,569,502, \
 572,568,569,570,504,576,575,503,502,503,568,569,568,501,570,573, \
 502,570,576,573,568,575,576,500,568,502,570,575,569,569,569,568, \
 572,570,568,572,568,504,569,573,571,570,568,572,572,573,570,568, \
 568,568,568,563,570,571,568,563,568,569,568,570,568,569,568,575, \
 576,569,568,568,570,570,570,571,568,569,562,575,570,571,569,569, \
 568,569,570,569,570,573,568,564,571,568,568,568,569,570,572,572, \
 568,574,575,576,567,569,569,570,570,572,573,570,575,576,570,568, \
 568,573,568,573,576,575,568,568,569,568,572,569,568,568,568,569, \
 564,569,576,567,568,562,568,571,572,570,576,568,569,570,568,572, \
 563,574,568,570,568,568,570,570,571,569,568,569,570,570,572,563, \
 842,570,568,572,569,574,569,575,576,501,568,503,568,568,568,819, \
 568,568,574,563,568,563,562,564,564,569,574,568,568,568,570,572, \
 569,568,568,575,576,894,568,839,525,576,568,568,569,573,568,568, \
 560,791,793,719,945,563,564,719,562,568,568,570,570,562,568,569, \
 720,564,573,561,560,575,568,563,568,565,568,568,856,570,570,719, \
 816,573,566,575,568,569,568,855,572,573,568,860,857,568,856,867 \

#define MPFR_MUL_THRESHOLD 17
#define MPFR_EXP_2_THRESHOLD 691
#define MPFR_EXP_THRESHOLD 23744

/****************************
 * Threshold for AMD 64     *
 ****************************/
#elif defined (__amd64)

#define MPFR_MULHIGH_TAB  \
 -1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,32,40,40,40,39,39,40,40, \
 40,40,40,0,40,0,0,0,0,0,0,0,48,48,0,0, \
 0,56,0,64,56,52,64,64,64,64,64,64,64,64,63,64, \
 64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64, \
 80,80,72,80,76,80,79,76,79,80,80,80,76,80,78,80, \
 79,79,80,80,80,79,80,93,90,80,80,80,80,90,93,80, \
 93,90,80,90,90,90,111,92,111,96,108,111,99,105,114,111, \
 111,111,114,114,117,114,114,117,117,117,108,117,111,111,114,117, \
 117,117,117,116,114,117,116,117,114,114,114,116,117,117,117,116, \
 117,117,116,116,117,117,141,123,138,138,140,140,141,141,141,140, \
 117,138,140,140,117,141,138,141,141,140,141,153,123,144,141,147, \
 153,138,150,153,165,165,189,188,165,180,188,189,177,174,180,180, \
 176,186,189,189,180,180,180,189,183,180,187,188,189,186,186,186, \
 185,186,189,189,186,186,188,189,186,177,188,177,188,186,177,185, \
 186,186,188,187,188,185,188,189,189,189,189,186,189,188,189,188, \
 188,186,187,189,186,180,187,186,188,184,188,186,234,189,189,189, \
 237,188,234,231,231,237,213,237,189,234,228,236,237,222,225,237, \
 225,225,224,231,225,234,225,236,225,225,234,233,234,234,235,234, \
 237,237,225,231,228,228,235,228,227,222,230,230,233,227,237,228, \
 237,236,231,232,234,234,235,236,237,231,237,236,237,234,236,274, \
 275,276,274,276,276,275,237,237,237,274,274,274,275,274,265,276, \
 267,272,273,276,276,276,267,274,267,270,267,274,274,274,276,274, \
 273,276,275,275,276,267,267,276,276,274,275,276,270,274,270,276, \
 293,273,274,274,276,276,310,292,274,275,276,283,328,276,327,329, \
 311,294,330,312,339,324,311,312,327,319,321,348,348,346,329,347, \
 327,348,328,328,348,330,329,328,337,348,337,346,339,339,337,337, \
 339,338,339,330,345,342,339,337,347,339,347,348,337,337,338,347, \
 342,342,339,345,329,330,348,337,329,346,328,348,328,328,329,337, \
 338,339,329,328,337,330,337,337,337,328,337,338,339,345,339,342, \
 344,345,338,337,348,346,339,348,337,344,346,342,347,347,343,346, \
 345,346,347,348,339,344,345,345,348,366,345,346,364,360,364,362, \
 346,347,365,364,365,366,344,345,346,347,366,345,366,419,365,419, \
 347,346,346,419,348,346,347,346,347,348,411,365,348,418,346,409, \
 418,409,411,410,409,410,405,409,415,409,405,419,417,411,409,414, \
 409,409,418,414,417,416,417,418,348,420,409,417,414,420,414,409, \
 416,419,418,419,420,415,416,417,411,411,366,456,456,416,416,447, \
 418,456,420,417,436,418,417,420,454,420,453,417,438,419,455,456, \
 416,436,436,438,455,455,441,417,490,456,492,563,417,491,456,420, \
 561,492,561,490,456,564,564,492,564,561,563,489,492,492,561,492, \
 491,558,491,561,561,535,561,564,492,536,535,561,535,553,528,545, \
 535,562,528,564,560,527,526,527,564,559,562,555,562,533,526,564, \
 537,563,564,528,537,557,546,544,561,537,537,553,556,561,562,564, \
 562,555,555,564,562,560,562,559,560,553,553,564,561,564,546,552, \
 553,554,555,564,557,560,561,553,554,562,561,561,555,559,560,546, \
 560,560,561,549,558,564,562,561,554,563,561,564,553,560,559,553, \
 563,562,559,558,561,563,536,528,533,535,563,564,537,562,553,564, \
 537,564,527,528,553,558,560,561,561,558,535,564,561,545,563,563, \
 564,558,560,544,562,563,553,555,561,557,563,559,553,554,560,563, \
 564,554,555,560,561,562,564,564,558,544,563,564,549,555,561,549, \
 553,554,558,549,552,555,552,553,556,560,563,562,564,563,560,561, \
 562,557,562,563,561,561,560,559,554,571,557,563,558,559,558,559, \
 560,561,562,707,557,560,561,562,561,562,563,561,705,706,702,696, \
 705,562,563,700,703,707,705,681,690,684,707,699,702,704,635,636, \
 681,708,562,693,681,680,696,684,680,705,704,703,689,679,697,668, \
 706,707,708,704,705,636,666,704,681,635,669,636,666,666,671,708, \
 669,670,650,707,689,670,671,672,706,678,675,697,679,706,707,708, \
 670,671,694,671,705,671,707,671,689,700,707,707,688,705,697,707, \
 679,702,708,704,705,707,707,708,677,688,706,705,699,697,698,706, \
 707,706,699,688,689,707,706,707,693,697,699,703,701,701,681,705, \
 706,707,690,707,690,706,707,708,704,707,706,707,706,669,679,680, \
 681,672,685,707,687,676,703,679,679,680,681,700,684,707,685,707 \

#define MPFR_MUL_THRESHOLD 8
#define MPFR_EXP_2_THRESHOLD 470
#define MPFR_EXP_THRESHOLD 43009

/*****************************
 * Threshold for Athlon      *
 *****************************/
#elif defined (__athlon)

#define MPFR_MULHIGH_TAB  \
 -1,0,-1,0,-1,0,-1,-1,0,-1,-1,0,0,0,0,10, \
 0,12,13,14,15,16,0,0,0,0,0,19,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32, \
 30,32,30,34,32,32,36,34,36,36,38,38,42,38,38,42, \
 40,38,42,46,42,42,42,44,44,44,44,44,48,50,46,46, \
 60,50,50,48,50,56,56,56,56,56,56,56,60,60,64,60, \
 64,64,60,60,60,72,64,64,68,72,76,72,76,72,72,76, \
 75,76,76,72,76,72,75,72,72,72,84,76,84,75,72,76, \
 84,80,76,84,84,76,76,76,76,88,84,88,80,84,83,96, \
 84,96,92,84,88,91,92,88,92,90,96,96,92,91,92,96, \
 96,120,95,100,112,120,100,119,112,120,120,112,119,112,119,119, \
 120,118,119,119,119,118,119,120,128,127,120,128,128,120,120,127, \
 120,128,128,128,128,120,128,127,120,128,128,127,128,127,144,136, \
 128,144,152,152,152,136,144,144,144,136,151,152,144,152,128,151, \
 144,152,144,144,151,144,150,150,136,151,152,143,143,143,142,168, \
 144,144,168,151,168,144,152,151,152,152,160,152,151,152,160,151, \
 152,151,152,167,152,152,166,152,167,160,168,204,160,160,168,168, \
 204,176,202,167,168,166,167,168,204,184,202,204,204,204,204,192, \
 184,192,204,202,202,216,204,227,202,204,216,203,203,204,203,227, \
 202,204,202,202,202,203,202,215,204,202,203,202,202,215,228,214, \
 226,214,228,214,228,215,228,216,226,214,228,225,226,228,226,226, \
 226,215,216,216,226,225,226,227,216,227,240,216,252,252,226,227, \
 228,239,227,250,227,226,227,227,252,238,228,239,252,227,228,228, \
 252,226,246,228,227,227,252,247,250,263,262,250,252,250,250,252, \
 250,288,288,250,250,250,251,264,264,271,287,276,250,288,252,286, \
 251,287,288,251,276,274,288,262,263,263,282,252,288,252,276,284, \
 287,274,264,274,288,275,275,274,274,288,276,264,273,286,274,276, \
 300,287,288,286,286,276,288,285,275,300,275,273,275,299,300,299, \
 279,336,336,286,287,284,360,359,336,335,288,360,333,359,334,335, \
 335,287,359,335,336,336,359,333,334,359,360,288,360,332,335,336, \
 335,336,336,333,336,335,336,359,334,334,335,360,336,334,356,357, \
 335,336,358,359,359,336,335,336,334,355,384,356,354,384,334,357, \
 336,359,384,359,360,356,384,382,336,383,384,384,354,355,383,384, \
 382,359,384,382,382,383,383,359,381,382,383,356,384,382,381,384, \
 357,384,358,357,358,358,380,383,382,382,383,360,360,381,382,360, \
 377,360,378,360,360,381,382,383,381,380,383,383,360,382,383,380, \
 383,383,384,381,379,360,381,381,382,431,380,380,378,380,384,381, \
 382,382,384,407,384,382,379,384,430,431,383,384,408,384,456,431, \
 431,455,431,428,384,454,455,403,432,383,407,430,430,456,408,427, \
 455,455,456,455,432,431,431,429,455,432,432,424,430,427,427,429, \
 452,454,426,455,456,431,430,454,452,454,431,456,431,428,455,430, \
 454,430,432,455,454,442,443,432,443,431,451,452,456,430,451,456, \
 444,455,449,456,432,454,449,454,502,432,448,504,450,503,503,453, \
 454,502,446,452,453,454,455,499,504,453,456,504,454,453,503,455, \
 456,456,500,478,502,454,456,499,478,454,480,499,501,496,502,455, \
 499,502,503,456,478,500,501,500,479,503,504,451,452,479,454,455, \
 502,503,504,504,454,499,503,501,454,503,456,503,504,501,455,502, \
 503,503,502,504,610,503,504,574,480,551,528,504,609,576,480,503, \
 496,502,503,552,551,552,551,503,504,503,610,608,609,610,611,608, \
 608,551,648,611,612,550,576,572,608,611,610,606,608,611,610,574, \
 575,576,606,607,606,606,608,606,606,575,576,604,604,604,608,609, \
 606,606,606,608,604,604,611,604,604,576,610,606,610,606,604,610, \
 606,612,604,608,610,609,604,608,606,647,612,610,604,606,648,610, \
 610,606,646,608,604,647,606,647,606,609,610,647,648,609,641,611, \
 643,611,643,648,643,640,646,611,644,644,645,611,642,646,611,612, \
 640,647,610,611,610,611,606,647,648,647,648,644,682,642,682,683, \
 610,611,680,678,642,681,682,647,682,612,682,648,611,665,680,683, \
 609,646,666,676,680,646,679,647,646,646,648,679,684,611,612,643, \
 684,645,646,647,683,647,608,645,682,647,682,646,610,648,682,610, \
 684,612,612,683,684,647,647,646,680,646,646,745,648,646,644,647, \
 648,647,678,646,647,683,642,682,682,684,646,645,642,647,646,677, \
 646,647,683,678,680,646,646,643,681,647,683,645,666,755,756,645, \
 643,647,646,647,647,648,674,755,756,674,647,643,680,682,684,680, \
 680,682,682,675,682,677,666,683,680,682,682,684,680,681,674,674 \

#define MPFR_MUL_THRESHOLD 19
#define MPFR_EXP_2_THRESHOLD 411
#define MPFR_EXP_THRESHOLD 45200

/*****************************
 * Threshold for PentiumPro  *
 *****************************/
#elif defined (__i386)

#define MPFR_MULHIGH_TAB  \
 -1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,64,64,56,64,64, \
 64,64,64,64,64,64,63,63,63,63,63,63,63,64,64,64, \
 64,63,64,64,63,63,63,80,80,72,64,80,72,80,80,79, \
 79,79,79,79,80,80,80,80,96,96,96,95,96,96,94,96, \
 95,95,95,96,95,95,96,96,95,95,95,95,96,96,104,96, \
 96,95,104,103,96,104,96,96,96,128,104,104,128,127,128,128, \
 128,128,128,128,126,128,126,127,127,127,128,127,127,127,127,127, \
 126,126,126,126,126,126,126,126,127,127,128,128,126,127,126,128, \
 128,128,128,128,126,127,126,128,128,125,124,127,126,126,126,126, \
 128,128,128,127,127,128,168,160,166,128,159,159,160,192,192,168, \
 167,167,190,192,190,168,190,191,180,188,167,191,191,190,190,190, \
 190,192,191,192,190,191,190,191,190,192,188,191,192,190,190,192, \
 192,189,190,192,191,192,190,192,191,186,188,189,190,188,191,190, \
 192,192,189,189,191,192,190,189,190,190,187,188,188,190,190,192, \
 190,191,191,191,216,192,216,190,192,191,189,216,190,215,191,190, \
 215,189,190,190,192,216,190,190,192,192,190,239,192,192,228,240, \
 239,237,237,238,228,215,236,237,232,230,237,215,192,236,216,234, \
 237,232,236,239,230,256,245,288,285,240,239,248,214,236,257,256, \
 284,288,287,256,239,262,284,288,341,243,216,285,285,280,287,269, \
 286,285,286,286,286,286,286,284,281,281,284,285,283,284,283,273, \
 286,285,276,283,287,286,287,286,282,286,288,288,287,283,288,281, \
 282,280,286,283,284,280,285,280,288,284,283,283,283,283,287,288, \
 281,286,284,284,286,287,286,288,281,288,286,281,286,287,286,287, \
 312,284,288,286,311,288,285,286,312,280,283,308,284,310,287,285, \
 283,286,311,288,287,288,287,311,286,286,287,384,335,334,383,383, \
 333,380,335,312,382,382,384,383,312,311,381,377,382,384,379,379, \
 380,383,384,384,381,381,383,377,381,384,383,383,383,382,384,335, \
 336,384,377,377,379,384,377,382,379,383,379,378,377,377,376,380, \
 377,382,383,380,379,380,381,384,383,377,375,380,383,381,380,378, \
 379,376,380,378,383,374,376,376,375,384,382,376,384,383,377,377, \
 384,380,384,382,383,382,382,377,379,378,384,379,381,383,384,378, \
 383,377,376,381,383,383,379,379,381,377,381,384,377,380,380,384, \
 383,383,384,383,381,377,374,380,379,381,377,378,374,380,376,377, \
 376,383,383,379,380,383,384,383,430,383,381,382,374,382,379,501, \
 379,383,384,382,503,382,497,379,492,380,501,381,383,382,501,502, \
 495,502,499,380,384,498,381,384,498,384,499,499,502,480,497,495, \
 480,478,498,497,502,496,500,503,479,502,501,503,475,492,498,496, \
 479,504,500,492,498,496,500,500,499,494,494,504,492,494,495,496, \
 497,494,504,503,492,494,500,497,575,502,504,496,497,496,575,572, \
 570,502,503,574,568,568,569,502,571,572,568,504,570,569,573,576, \
 574,570,538,566,538,565,566,572,569,568,572,571,568,571,575,569, \
 564,571,568,575,568,576,561,567,560,576,562,573,568,574,572,575, \
 575,564,568,574,574,575,572,568,568,570,572,574,568,576,575,564, \
 572,573,570,564,574,576,574,574,567,566,570,575,571,576,570,573, \
 573,569,567,568,572,574,566,572,573,574,568,570,570,567,566,561, \
 557,571,564,560,557,562,574,563,576,571,557,569,572,575,571,564, \
 572,558,566,562,559,574,563,574,571,569,572,568,574,570,571,566, \
 571,568,566,566,565,572,570,568,572,572,565,575,569,566,567,575, \
 571,573,573,572,563,569,576,567,568,568,569,566,570,568,573,569, \
 570,573,570,574,574,575,574,568,575,568,564,568,567,571,576,576, \
 568,569,575,569,569,573,574,575,573,574,565,571,567,568,568,575, \
 571,569,573,575,575,570,570,571,565,569,571,571,643,648,571,575, \
 576,570,574,576,574,645,572,642,648,644,646,576,575,648,634,719, \
 573,645,644,643,570,641,638,641,574,644,644,645,644,638,637,574, \
 574,575,576,572,642,719,645,648,713,645,682,709,713,718,720,712, \
 645,718,719,716,644,698,682,678,707,647,681,682,716,684,681,682, \
 683,716,715,719,708,706,719,706,709,708,712,708,709,712,715,712, \
 720,717,717,718,717,704,705,706,707,718,700,710,708,708,713,683, \
 719,717,717,718,719,720,710,709,713,705,711,684,717,718,710,717 \

#define MPFR_MUL_THRESHOLD 11
#define MPFR_EXP_2_THRESHOLD 528
#define MPFR_EXP_THRESHOLD 47120

/*****************************
 * Threshold for IA64        *
 *****************************/
#elif defined (__ia64)

#define MPFR_MULHIGH_TAB  \
 -1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0, \
 128,124,124,124,124,124,120,124,120,124,120,124,120,124,124,124, \
 124,124,124,124,144,124,144,140,140,140,140,136,136,136,136,136, \
 136,136,136,136,136,136,136,136,136,136,136,136,140,139,140,152, \
 152,152,160,156,160,156,160,164,156,156,160,156,144,160,147,160, \
 160,159,160,160,160,168,168,168,160,164,176,168,172,168,156,168, \
 168,164,168,176,172,172,160,175,168,172,176,172,176,175,176,184, \
 176,175,176,180,176,180,184,184,168,180,184,184,184,171,172,207, \
 184,184,184,208,200,207,176,207,200,200,208,206,208,200,208,206, \
 200,200,206,207,206,207,208,207,207,206,208,207,208,208,208,208, \
 208,207,224,207,208,240,215,215,240,215,240,239,216,215,216,240, \
 224,223,224,220,222,220,224,223,224,223,224,231,224,223,232,228, \
 256,255,231,231,256,231,232,232,232,255,256,255,238,264,238,238, \
 256,255,256,248,256,264,240,239,240,240,248,271,248,255,272,248, \
 264,255,256,255,256,252,256,256,272,255,256,255,256,263,264,264, \
 264,263,264,264,263,264,264,271,256,271,271,271,272,272,285,270, \
 285,271,280,271,280,280,280,272,280,287,269,279,284,271,280,271, \
 271,271,285,286,271,272,272,280,272,279,272,278,280,271,286,284, \
 271,280,272,277,284,272,336,281,312,279,280,278,280,280,280,280, \
 284,280,348,280,272,334,272,284,285,287,286,279,336,323,331,334, \
 332,331,332,335,286,346,336,332,334,336,334,336,334,341,358,347, \
 336,336,334,335,334,346,344,347,347,360,371,348,355,382,334,356, \
 336,355,347,384,336,358,358,345,357,347,346,347,348,359,371,359, \
 358,382,346,383,347,357,360,358,357,357,360,370,406,394,382,347, \
 406,347,407,408,407,406,365,419,356,395,356,359,358,406,360,406, \
 359,359,408,419,395,432,360,420,408,425,408,395,430,395,371,432, \
 370,401,432,396,384,419,384,406,359,378,379,378,382,380,392,384, \
 377,384,383,395,407,383,384,455,455,371,371,404,381,405,395,431, \
 432,432,408,400,384,383,383,455,455,377,455,438,432,419,420,444, \
 398,424,392,469,432,427,431,430,404,396,406,384,454,451,464,404, \
 428,432,432,429,405,432,444,407,452,473,430,453,443,452,456,430, \
 454,431,407,430,407,416,455,456,468,456,468,443,431,443,442,460, \
 419,448,467,449,448,478,428,448,479,455,467,431,450,478,431,491, \
 480,442,440,458,478,442,442,432,430,467,467,467,469,467,455,479, \
 453,479,451,478,503,443,454,479,473,476,480,473,477,480,479,489, \
 491,491,491,480,476,454,503,499,500,502,504,460,491,455,466,491, \
 480,477,477,476,473,502,502,504,527,490,467,500,489,502,501,503, \
 515,474,528,480,496,498,492,480,479,504,504,480,492,504,503,522, \
 515,491,503,540,491,499,503,552,492,503,500,504,502,526,551,528, \
 526,514,516,528,528,506,551,503,509,491,496,502,503,514,503,501, \
 548,503,504,552,512,515,516,504,506,509,551,548,502,491,504,552, \
 520,526,528,551,502,521,526,520,514,523,539,549,503,545,528,538, \
 504,533,504,520,511,515,528,504,538,516,514,526,514,528,521,599, \
 551,599,515,520,550,528,526,527,597,548,552,624,535,598,540,528, \
 534,530,596,532,623,539,617,540,542,551,552,550,617,549,600,624, \
 624,550,551,547,596,616,622,551,550,551,552,646,646,648,624,647, \
 622,619,623,622,647,599,600,672,646,647,622,623,624,643,647,647, \
 672,641,622,599,671,617,646,623,622,650,644,647,648,672,647,648, \
 622,641,646,647,648,659,624,644,646,672,647,623,647,648,664,645, \
 644,647,646,622,646,647,668,621,624,647,670,644,626,659,647,624, \
 648,647,647,635,682,695,641,665,646,634,645,646,672,670,646,693, \
 624,694,647,648,624,620,660,648,646,660,688,694,695,667,672,666 \

#define MPFR_MUL_THRESHOLD 10
#define MPFR_EXP_2_THRESHOLD 534
#define MPFR_EXP_THRESHOLD 20877

/* __mips64? __mips? */
#endif

/*******************************
 * Default values of Threshold *
 *******************************/
#ifndef MPFR_MULHIGH_TAB
# define MPFR_MULHIGH_TAB -1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0
#endif
#ifndef MPFR_SQRHIGH_TAB
# define MPFR_SQRHIGH_TAB -1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0
#endif
#ifndef MPFR_MUL_THRESHOLD
# define MPFR_MUL_THRESHOLD 40
#endif
#ifndef MPFR_EXP_2_THRESHOLD
# define MPFR_EXP_2_THRESHOLD 100
#endif
#ifndef MPFR_EXP_THRESHOLD
# define MPFR_EXP_THRESHOLD 25000
#endif
