/***************************************************************************
 *   Copyright (C) 2002~2005 by Yuking                                     *
 *   yuking_net@sohu.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "punc.h"

#include <stdio.h>
#include <limits.h>
#include <string.h>
#include <stdlib.h>

#include "ime.h"
#include "tools.h"

ChnPunc        *chnPunc = (ChnPunc *) NULL;

extern int      iCodeInputCount;

/**
 * @brief رʵ
 * @param void
 * @return void
 * @note ļݵĸʽΪ ӦӢķ ı <ı>
 * رʵ䡣ʵ䶨һת롮.ֱתɡ
 */
int LoadPuncDict (void)
{
    FILE           *fpDict;				// ʵļָ
    int             iRecordNo;
    char            strText[11];
    char            strPath[PATH_MAX];	// ʵļȫ·
    char           *pstr;				// ʱָ
    int             i;

    fpDict = UserConfigFile(PUNC_DICT_FILENAME, "rt", NULL);

    // ļڣʹðװĿ¼µļ
    if (!fpDict) {
	strcpy (strPath, PKGDATADIR "/data/");
	strcat (strPath, PUNC_DICT_FILENAME);

	/* zxd add begin */
        if (access (strPath, 0) && getenv( "FCITXDIR" ) ) {
	    strcpy (strPath, getenv( "FCITXDIR") );
	    strcat (strPath, "/share/fcitx/data/" );
	    strcat (strPath, PUNC_DICT_FILENAME);
        }
        /* zxd add end */

	fpDict = fopen (strPath, "rt");
	if (!fpDict) {
	    printf ("Can't open Chinese punc file: %s\n", strPath);
	    return False;
	}
    }

    /* ʵжٵ
     * ǳ򵥣ǼļжУУ
     * ΪУȥԣڴ˷
     * ûһо˷sizeof (ChnPunc)ֽڴ*/
    iRecordNo = CalculateRecordNumber (fpDict);
    // ռ䣬ЩݡûмǷ뵽ڴ棬ϸ˵С
    // chnPuncһȫֱ
    chnPunc = (ChnPunc *) malloc (sizeof (ChnPunc) * (iRecordNo + 1));

    iRecordNo = 0;

    // ѭһһеĶʵļݡ뵽chnPuncȥ
    for (;;) {
	if (!fgets (strText, 10, fpDict))
	    break;
	i = strlen (strText) - 1;

	// ҵһַ
	while ((strText[i] == '\n') || (strText[i] == ' ')) {
	    if (!i)
		break;
	    i--;
	}

	// ҵг롣ǿʱ϶ҲԣҲԹ˿еĴ
	if (i) {
	    strText[i + 1] = '\0';				// ַӸ
	    pstr = strText;						// pstrָһǿַ
	    while (*pstr == ' ')
		pstr++;
	    chnPunc[iRecordNo].ASCII = *pstr++;	// ķӦASCIIֵ
	    while (*pstr == ' ')				// Ȼ󣬽pstrָһǿַ
		pstr++;

	    chnPunc[iRecordNo].iCount = 0;		// ÷мתӢ"Ϳתɡ͡
	    chnPunc[iRecordNo].iWhich = 0;		// ʾ÷ŵ״̬ڵڼת"iWhichʾתɡǡ
	    // νASCIIӦķŷ뵽ṹ
	    while (*pstr) {
		i = 0;
		// ΪķŶ˫ֽڵģԣҪһֱ֪ոַĩβ
		while (*pstr != ' ' && *pstr) {
		    chnPunc[iRecordNo].strChnPunc[chnPunc[iRecordNo].iCount][i] = *pstr;
		    i++;
		    pstr++;
		}

		// ÿķ'\0'
		chnPunc[iRecordNo].strChnPunc[chnPunc[iRecordNo].iCount][i] = '\0';
		while (*pstr == ' ')
		    pstr++;
		chnPunc[iRecordNo].iCount++;
	    }

	    iRecordNo++;
	}
    }

    chnPunc[iRecordNo].ASCII = '\0';
    fclose (fpDict);

    return True;
}

void FreePunc (void)
{
    if (!chnPunc)
	return;

    free (chnPunc);
    chnPunc = (ChnPunc *) NULL;
}

/*
 * ַõӦı
 * ַڱżУ򷵻NULL
 */
char           *GetPunc (int iKey)
{
    int             iIndex = 0;
    char           *pPunc;

    if (!chnPunc)
	return (char *) NULL;

    while (chnPunc[iIndex].ASCII) {
	if (chnPunc[iIndex].ASCII == iKey) {
	    pPunc = chnPunc[iIndex].strChnPunc[chnPunc[iIndex].iWhich];
	    chnPunc[iIndex].iWhich++;
	    if (chnPunc[iIndex].iWhich >= chnPunc[iIndex].iCount)
		chnPunc[iIndex].iWhich = 0;
	    return pPunc;
	}
	iIndex++;
    }

    return (char *) NULL;
}
