#! /bin/sh
#
# This script is called as:
# $0 --upstream-version <version> <filename>

echo
set -ex

test $# -eq 3 || exit 255

version="$2"
filename="$3"

curdir=`pwd`

tempdir=`mktemp -d`
echo ${tempdir}
tar --bzip2 -xf ${filename} -C ${tempdir}
cd ${tempdir}
rm -r fceu/vc
rm -r fceu/src/drivers/win
rm -r fceu/~attic
rm -r fceu/src/~attic
tar -cz * -f ${curdir}/../fceux_${version}+repack.orig.tar.gz
cd ${curdir}
rm -r ${tempdir}
