/*
 * Copyright (C) 2013 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>

#include "glue.h"

#include "sig_mdi.h"

void
sig_mdi_read(
	struct sig_mdi *b,
	void *s,
	unsigned int reg,
	uint16_t *valp
)
{
	unsigned int nr;
	void (*func)(void *, unsigned int, uint16_t *);

	for (nr = 0; ; nr++) {
		if (nr == b->nmembers) {
			*valp = 0xffff;
			return;
		}
		if (b->member[nr].s == s) {
			continue;
		}
		func = b->member[nr].f->read;
		assert(func);
		func(b->member[nr].s, reg, valp);
		return;
	}
}

void
sig_mdi_write(
	struct sig_mdi *b,
	void *s,
	unsigned int reg,
	uint16_t val
)
{
	unsigned int nr;
	void (*func)(void *, unsigned int, uint16_t);

	for (nr = 0; ; nr++) {
		if (nr == b->nmembers) {
			return;
		}
		if (b->member[nr].s == s) {
			continue;
		}
		func = b->member[nr].f->write;
		assert(func);
		func(b->member[nr].s, reg, val);
		return;
	}
}

void
sig_mdi_send(
	struct sig_mdi *b,
	void *s,
	const void *buf,
	unsigned int buflen
)
{
	unsigned int nr;
	void (*func)(void *, const void *, unsigned int);

	for (nr = 0; ; nr++) {
		if (nr == b->nmembers) {
			return;
		}
		if (b->member[nr].s == s) {
			continue;
		}
		func = b->member[nr].f->recv;
		assert(func);
		func(b->member[nr].s, buf, buflen);
		return;
	}
}

void
sig_mdi_connect(
	struct sig_mdi *b,
	void *s,
	const struct sig_mdi_funcs *f
)
{
	assert(b);
	assert(b->type == SIG_GEN_MDI);
	assert(b->nmembers < sizeof(b->member) / sizeof(b->member[0]));

	b->member[b->nmembers].s = s;
	b->member[b->nmembers].f = f;
	b->nmembers++;
}

struct sig_mdi *
sig_mdi_create(const char *name)
{
	struct sig_mdi *bus;

	bus = shm_alloc(sizeof(*bus));
	assert(bus);

	bus->type = SIG_GEN_MDI;
	bus->nmembers = 0;

	return bus;
}

void
sig_mdi_destroy(struct sig_mdi *bus)
{
	assert(bus);
	assert(bus->type == SIG_GEN_MDI);

	shm_free(bus);
}

void
sig_mdi_suspend(struct sig_mdi *b, FILE *fSig)
{
	size_t size = sizeof(*b);
	
	generic_suspend(b, size, fSig);
}

void
sig_mdi_resume(struct sig_mdi *b, FILE *fSig)
{
	size_t size = sizeof(*b);
	
	generic_resume(b, size, fSig);
}
