/*
 * Copyright (C) 2016 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <stdio.h>

#ifndef __GLUE_GUI_GTK_TEXT_CONTROL_H_INCLUDED
#define __GLUE_GUI_GTK_TEXT_CONTROL_H_INCLUDED

typedef struct {
	GtkVBox parent;

	GtkWidget *title_label; 
	GtkWidget *value_label;
	GtkWidget *entry;
} GuiGtkTextControl;

#define GUI_GTK_TYPE_TEXT_CONTROL	(gui_gtk_text_control_get_type())
#define GUI_GTK_TEXT_CONTROL(obj)	(G_TYPE_CHECK_INSTANCE_CAST((obj), GUI_GTK_TYPE_TEXT_CONTROL, GuiGtkTextControl))

extern GType
gui_gtk_text_control_get_type(void);

extern GtkWidget *
gui_gtk_text_control_new(const char *desc);

extern void
gui_gtk_text_control_set_value(gpointer _text_control, const char *value_string);

extern void
gui_gtk_text_control_destroy(gpointer _text_control);

#endif /* __GLUE_GUI_GTK_TEXT_CONTROL_H_INCLUDED */
