/*
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __GLUE_GUI_GTK_KEYBOARD_H_INCLUDED
#define __GLUE_GUI_GTK_KEYBOARD_H_INCLUDED

typedef struct {
	GtkVBox parent;

	GtkWidget *num_led;
	GtkWidget *caps_led;
	GtkWidget *scroll_led;
	GtkWidget *select;
	GtkWidget *special;
	GtkWidget *special_menu;

	int active;
} GuiGtkKeyboard;

#define GUI_GTK_TYPE_KEYBOARD	(gui_gtk_keyboard_get_type())
#define GUI_GTK_KEYBOARD(obj)	(G_TYPE_CHECK_INSTANCE_CAST((obj), GUI_GTK_TYPE_KEYBOARD, GuiGtkKeyboard))

extern GType
gui_gtk_keyboard_get_type(void);

extern GtkWidget *
gui_gtk_keyboard_new(void);

extern void
gui_gtk_keyboard_type(unsigned int nr, int pressed);

extern void
gui_gtk_keyboard_num_led_set(GuiGtkKeyboard *keyboard, unsigned int on);

extern void
gui_gtk_keyboard_caps_led_set(GuiGtkKeyboard *keyboard, unsigned int on);

extern void
gui_gtk_keyboard_scroll_led_set(GuiGtkKeyboard *keyboard, unsigned int on);

#endif /* __GLUE_GUI_GTK_KEYBOARD_H_INCLUDED */
