/*
 * Derived from MPlayer (libao2 - ao_null).
 *
 * Copyright (c) FAUmachine Team.
 * Copyright (c) Mplayer Team
 * Copyright (c) Tobias Diedrich.
 *
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

/*
 * NULL audio output plugin for FAUmachine
 */

#include "glue-audio_internal.h"

static ao_info_t info = 
{
	"Null audio output",
	"null",
	"Tobias Diedrich",
	""
};

LIBAO_EXTERN(null);

#define BUFFERSIZE 65536

/* open & setup audio device
 * return: 1=success 0=fail
 */
static int
init(void)
{
	return 1;
}

/* close audio device */
static void
uninit(int immed)
{
}

/* return: how many bytes can be played without blocking */
static int
get_space()
{
	return BUFFERSIZE;
}

/* plays 'len' bytes of 'data'
 * return: number of bytes played
 */
static int
play(void* data,int len)
{
	return len;
}

/* return: delay in seconds between first and last sample in null_buffer */
static float
get_delay(void)
{
	return 0.0;
}
