/*
 * Copyright (C) 2015-2016 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifdef STATE

struct {
	int init;
	unsigned long long time;
	unsigned long long period;
	int state;
} NAME;

#endif /*STATE*/

#ifdef BEHAVIOUR


static void
NAME_(step)(void *_cpssp) {
	struct cpssp *cpssp = _cpssp;

	switch (cpssp->NAME.state) {
	case 0:
		cpssp->NAME.state = 1;
		NAME_(5_out_set)(cpssp, SIG_STD_LOGIC_0);
		break;
	case 1:
		cpssp->NAME.state = 2;
		NAME_(5_out_set)(cpssp, SIG_STD_LOGIC_1);
		break;
	case 2:
		cpssp->NAME.state = 3;
		NAME_(5_out_set)(cpssp, SIG_STD_LOGIC_0);
		break;
	default:
		assert(0);
	}

	if (cpssp->NAME.state < 3) {
		time_call_after(cpssp->NAME.period / 3, NAME_(step), cpssp);
	}
}

static void
NAME_(14_in_set)(struct cpssp *cpssp, unsigned int val)
{
	/* Ignore... */
}

static void
NAME_(15_in_set)(struct cpssp *cpssp, unsigned int val)
{
	NAME_(13_out_set)(cpssp, val);

	switch (val) {
	case SIG_STD_LOGIC_L:
	case SIG_STD_LOGIC_0:
		if (! cpssp->NAME.init) {
			cpssp->NAME.time = time_virt();
			cpssp->NAME.init = 1;
		} else {
			cpssp->NAME.period = time_virt() - cpssp->NAME.time;
			cpssp->NAME.time = time_virt();
			cpssp->NAME.state = 0;
			NAME_(step)(cpssp);
		}
		break;
	case SIG_STD_LOGIC_H:
	case SIG_STD_LOGIC_1:
		if (! cpssp->NAME.init) {
			cpssp->NAME.time = time_virt();
			cpssp->NAME.init = 1;
		} else {
			cpssp->NAME.period = time_virt() - cpssp->NAME.time;
			cpssp->NAME.time = time_virt();
			cpssp->NAME.state = 0;
			NAME_(step)(cpssp);
		}
		break;
	default:
		break;
	}
}

static void
NAME_(create)(struct cpssp *cpssp)
{
	cpssp->NAME.init = 0;
}

static void
NAME_(destroy)(struct cpssp *cpssp)
{
}

#endif /*BEHAVIOUR*/
