/*
 * Copyright (C) 2015 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifdef STATE

struct {
    unsigned int states[3];
} NAME;

#endif /*STATE*/

#ifdef BEHAVIOUR


#ifdef DEBUG
#define STR(x)   #x
#define SHOW_DEFINE(x) fprintf(stderr, "%s", STR(x))
#endif /* DEBUG */

static void
NAME_(create)(struct cpssp *cpssp)
{
    cpssp->NAME.states[0] = SIG_STD_LOGIC_Z;
    cpssp->NAME.states[1] = SIG_STD_LOGIC_Z;
    cpssp->NAME.states[2] = SIG_STD_LOGIC_Z;
}

static void
NAME_(destroy)(struct cpssp *cpssp)
{
    return;
}

NAME_reset(void *_cpssp) {
    struct cpssp *cpssp = _cpssp;
    unsigned int res = 2000 < SIG_mV(cpssp->NAME_states[2]) ? SIG_STD_LOGIC_1 : SIG_STD_LOGIC_0;

#ifdef DEBUG
    SHOW_DEFINE(NAME);
    fprintf(stderr, " resets to %i\n", res);
#endif /* DEBUG */

    NAME_OUT_PORT_0_(out_set)(cpssp, res);
}

static void
NAME_solve(void) {
    cpssp->NAME.states[2] = resolve(NAME.states[0], NAME.states[1]);

    unsigned int res = 2000 < SIG_mV(cpssp->NAME_states[2]) ? SIG_STD_LOGIC_1 : SIG_STD_LOGIC_0;

#ifdef DEBUG
    SHOW_DEFINE(NAME);
    fprintf(stderr, " sets to %i\n", res);
#endif /* DEBUG */

    NAME_OUT_PORT_0_(out_set)(cpssp, res);
    /* set back after short delay */
    time_call_after(1, NAME_reset, cpssp);
}

static void
NAME_IN_PORT_0_(in_set)(struct cpssp *cpssp, unsigned int val)
{
    cpssp->NAME.states[0] = val;
    NAME_solve();
}

static void
NAME_IN_PORT_1_(in_set)(struct cpssp *cpssp, unsigned int val)
{
    cpssp->NAME.states[1] = val;
    NAME_solve();
}
#endif /*BEHAVIOUR*/
