/*
 * Copyright (C) 2014 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "glue.h"

#include "led3.h"

struct cpssp {
	struct sig_opt_rgb *port_opt_led;

	unsigned int r, g, b;
};

static void
led3_led_set(struct cpssp *cpssp)
{
	sig_opt_rgb_pixel_set(cpssp->port_opt_led, cpssp,
			0, 0, cpssp->r, cpssp->g, cpssp->b);
}

static void
led3_led_red_set(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	cpssp->r = val ? 0x00 : 0xff;

	led3_led_set(cpssp);
}

static void
led3_led_green_set(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	cpssp->g = val ? 0x00 : 0xff;

	led3_led_set(cpssp);
}

static void
led3_led_blue_set(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	cpssp->b = val ? 0x00 : 0xff;

	led3_led_set(cpssp);
}

void *
led3_create(
	const char *name,
	struct sig_manage *port_manage,
	struct sig_std_logic *port_led_red,
	struct sig_std_logic *port_led_green,
	struct sig_std_logic *port_led_blue,
	struct sig_opt_rgb *port_opt_led
)
{
	static const struct sig_std_logic_funcs led_red_funcs = {
		.boolean_or_set = led3_led_red_set,
	};
	static const struct sig_std_logic_funcs led_green_funcs = {
		.boolean_or_set = led3_led_green_set,
	};
	static const struct sig_std_logic_funcs led_blue_funcs = {
		.boolean_or_set = led3_led_blue_set,
	};
	struct cpssp *cpssp;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	/* Call */
	/* Out */
	cpssp->port_opt_led = port_opt_led;

	/* In */
	sig_std_logic_connect_in(port_led_red, cpssp, &led_red_funcs);
	sig_std_logic_connect_in(port_led_green, cpssp, &led_green_funcs);
	sig_std_logic_connect_in(port_led_blue, cpssp, &led_blue_funcs);

	return cpssp;
}

void
led3_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	shm_free(cpssp);
}

void
led3_suspend(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;

	generic_suspend(cpssp, sizeof(*cpssp), fComp);
}

void
led3_resume(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;

	generic_resume(cpssp, sizeof(*cpssp), fComp);
}
