/*
 * $Id: branch_pci.c,v 1.9 2009-06-03 11:34:02 vrsieh Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "branch_pci.h"

struct cpssp {
	unsigned int generic_idsel;
	struct sig_pci_bus_idsel *port_idsel;
};

static int
branch_pci_c0r(
	void *_f,
	uint32_t addr,
	unsigned int bs,
	uint32_t *valp
)
{
	struct cpssp *f = (struct cpssp *) _f;

	if ((addr >> (11 + f->generic_idsel)) & 1) {
		return sig_pci_bus_idsel_c0r(f->port_idsel, f, addr, bs, valp);
	} else {
		return 1;
	}
}

static int
branch_pci_c0w(
	void *_f,
	uint32_t addr,
	unsigned int bs,
	uint32_t val
)
{
	struct cpssp *f = (struct cpssp *) _f;

	if ((addr >> (11 + f->generic_idsel)) & 1) {
		return sig_pci_bus_idsel_c0w(f->port_idsel, f, addr, bs, val);
	} else {
		return 1;
	}
}

void *
branch_pci_create(
	const char *name,
	const char *generic_idsel,
	struct sig_manage *port_manage,
	struct sig_pci_bus_main *port_pci_bus,
	struct sig_pci_bus_idsel *port_idsel
)
{
	static const struct sig_pci_bus_main_funcs pci_bus_funcs = {
		.c0r = branch_pci_c0r,
		.c0w = branch_pci_c0w,
	};
	struct cpssp *cpssp;

	assert(generic_idsel);

	cpssp = malloc(sizeof(*cpssp));
	assert(cpssp);

	cpssp->generic_idsel = atoi(generic_idsel);

	/* Out */
	/* Call */
	sig_pci_bus_main_connect(port_pci_bus, cpssp, &pci_bus_funcs);

	cpssp->port_idsel = port_idsel;

	/* In */

	return cpssp;
}

void
branch_pci_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	free(cpssp);
}
