/*
 * $Id: sig_vga.c,v 1.18 2009-05-21 16:38:09 vrsieh Exp $
 *  
 *  Implementation of the VGA cable.
 *
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "sig_vga.h"

struct sig_vga *
sig_vga_create(const char *name)
{
	struct sig_vga *b;
	char n[1000];
	int ret;

	b = malloc(sizeof(*b));
	assert(b);

	b->type = SIG_GEN_VGA;

	ret = snprintf(n, sizeof(n), "%s-video", name);
	assert(0 < ret);
	b->video = sig_video_create(n);

	ret = snprintf(n, sizeof(n), "%s-ddc", name);
	assert(0 < ret);
	b->ddc = sig_i2c_bus_create(n);

	return b;
}

void
sig_vga_destroy(struct sig_vga *sig)
{
	assert(sig);
	assert(sig->type == SIG_GEN_VGA);

	sig_video_destroy(sig->video);
	sig_i2c_bus_destroy(sig->ddc);

	free(sig);
}
