/*
 * $Id: sig_eth.h,v 1.7 2009-05-21 16:38:07 vrsieh Exp $
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_ETH_H_INCLUDED
#define __SIG_ETH_H_INCLUDED

#include "sig_gen.h"

struct sig_eth_funcs {
	void (*recv)(void *s, const void *buf, unsigned int buflen);
};

struct sig_eth {
	enum sig_gen_type type;
	struct {
		void *s;
		const struct sig_eth_funcs *f;
	} member[32];
	unsigned int nmembers;
};

extern void
sig_eth_send(struct sig_eth *b, void *s, const void *buf, unsigned int buflen);

extern void
sig_eth_connect(struct sig_eth *b, void *s, const struct sig_eth_funcs *f);

extern struct sig_eth *
sig_eth_create(const char *name);
extern void
sig_eth_destroy(struct sig_eth *sig);

#endif /* __SIG_ETH_H_INCLUDED */
