/*
 *  $Id: vt102_monitor_gui.c,v 1.13 2009-08-25 06:30:04 sand Exp $
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>

#include "config.h"

#include "glue-gui.h"

#include "vt102_monitor_gui.h"

#ifdef HAVE_GTK
#include "vt102_monitor_gui_gtk.h"
#endif

#include "vt102_monitor_gui_null.h"

void *
vt102_monitor_gui_create(
	unsigned int page,
	const char *name,
	struct sig_manage *port_manage,
	struct sig_boolean *port_power_230v,
	struct sig_video *port_video,
	struct sig_opt_rgb *port_opt_video,
	struct sig_boolean *port_screenshot,
	struct sig_boolean *port_rec
)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		return vt102_monitor_gui_gtk_create(page, name,
				port_manage,
				port_power_230v,
				port_video,
				port_opt_video,
				port_screenshot,
				port_rec);
		break;
#endif
	case GUI_NULL:
		return vt102_monitor_gui_null_create(page, name,
				port_manage,
				port_power_230v,
				port_video,
				port_opt_video,
				port_screenshot,
				port_rec);
	default:
		assert(0);
	}
}

void
vt102_monitor_gui_destroy(void *_cpssp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		vt102_monitor_gui_gtk_destroy(_cpssp);
		break;
#endif
	case GUI_NULL:
		vt102_monitor_gui_null_destroy(_cpssp);
		break;
	default:
		assert(0);
	}
}
