/* $Id: glue-gui-gtk-change.c,v 1.9 2009-10-16 09:01:39 vrsieh Exp $ 
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>
#include <string.h>

#include <gtk/gtk.h>

#include "node-pc/system.h"
#include "glue-gui-gtk-change.h"

typedef struct {
	GtkHBoxClass parent_class;

	void (*change_inserted) (GuiGtkChange *change);
	void (*change_removed) (GuiGtkChange *change);
} GuiGtkChangeClass;

enum {
	CHANGE_INSERTED,
	CHANGE_REMOVED,
	GUI_GTK_CHANGE_LAST_SIGNAL
};

static guint gui_gtk_change_signals[GUI_GTK_CHANGE_LAST_SIGNAL] = { 0, 0 };

static void
gui_gtk_change_class_init(GuiGtkChangeClass *class)
{
	gui_gtk_change_signals[CHANGE_INSERTED] =
		g_signal_new("change-inserted",
			G_TYPE_FROM_CLASS(class),
			G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION, /* FIXME */
			G_STRUCT_OFFSET(GuiGtkChangeClass, change_inserted),
			NULL, NULL,
			g_cclosure_marshal_VOID__POINTER, G_TYPE_NONE,
			1, G_TYPE_POINTER);
	gui_gtk_change_signals[CHANGE_REMOVED] =
		g_signal_new("change-removed",
			G_TYPE_FROM_CLASS(class),
			G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION, /* FIXME */
			G_STRUCT_OFFSET(GuiGtkChangeClass, change_removed),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
gui_gtk_change_insert_event(GtkWidget *w, gpointer _change)
{
	GuiGtkChange *change = (GuiGtkChange *) _change;
	const char *type;
	GtkTreeIter iter;
	unsigned int i;

	if (strcasecmp(change->type, "floppy") == 0) {
		type = "floppy";
	} else if (strcasecmp(change->type, "cd") == 0
		|| strcasecmp(change->type, "dvd") == 0) {
		type = "magneto_optical";
	} else {
		assert(0);
	}

	/* Create list of media. */
	for (i = 0; ; i++) {
		if (system_port_lookup(type, SYSTEM_GENDER_FEMALE, i,
				&change->media[i].name,
				&change->media[i].port) < 0) {
			break;
		}

		/* Skip ':'. */
		assert(change->media[i].name[0] == ':');
		change->media[i].name++;
	}
	change->nmedias = i;

	for (i = 0; i < change->nmedias; i++) {

		gtk_list_store_append(change->media_store, &iter);
		gtk_list_store_set(change->media_store, &iter,
				0, change->media[i].name,
				1, i,
				-1);
	}

	gtk_widget_show(change->window);
}

static void
gui_gtk_change_remove_event(GtkWidget *w, gpointer _change)
{
	GuiGtkChange *change = (GuiGtkChange *) _change;

	gtk_widget_show(change->insert);
	gtk_widget_hide(change->remove);

	g_signal_emit(G_OBJECT(change),
			gui_gtk_change_signals[CHANGE_REMOVED], 0);
}

static void
gui_gtk_change_ok_button_event(GtkWidget *w, gpointer _change)
{
	GuiGtkChange *change = (GuiGtkChange *) _change;
	const char *name;
	const char *port;
        GtkTreeIter iter;
        GtkTreeModel *model;
        gint i;

	gtk_widget_hide(change->insert);
	gtk_widget_show(change->remove);
	gtk_widget_hide(change->window);

	/* Get selected media. */
	name = NULL;
	port = NULL;
	if (gtk_tree_selection_get_selected(change->media_select, &model, &iter)) {
		gtk_tree_model_get(model, &iter, 1, &i, -1);
		name = change->media[i].name;
		port = change->media[i].port;
	}

	/* Destroy list list of media. */
	gtk_list_store_clear(change->media_store);
	change->nmedias = 0;

	g_signal_emit(G_OBJECT(change),
			gui_gtk_change_signals[CHANGE_INSERTED], 0, name);
}

static void
gui_gtk_change_cancel_button_event(GtkWidget *w, gpointer _change)
{
	GuiGtkChange *change = (GuiGtkChange *) _change;

	gtk_widget_hide(change->window);

	/* Destroy list of media. */
	gtk_list_store_clear(change->media_store);
	change->nmedias = 0;
}

static gboolean
gui_gtk_change_delete_event(GtkWidget *w, GdkEvent *event, gpointer _change)
{
	GuiGtkChange *change = (GuiGtkChange *) _change;

	gtk_widget_hide(change->window);

	return TRUE;
}

static void
gui_gtk_change_media_selection_changed_event(GtkTreeSelection *selection, gpointer _change)
{
	GuiGtkChange *change = (GuiGtkChange *) _change;
	gboolean sensitive;

	sensitive = (gtk_tree_selection_count_selected_rows(selection) > 0);
	gtk_widget_set_sensitive(change->button_ok, sensitive);
}

static void
gui_gtk_change_init(GuiGtkChange *change)
{
	GtkWidget *frame;
	GtkWidget *list_frame;
	GtkCellRenderer *renderer;
	GtkTreeViewColumn *column;

	/* Insert Button */
	change->insert = gtk_button_new_with_label("Insert");
	GTK_WIDGET_UNSET_FLAGS(change->insert, GTK_CAN_FOCUS);
	g_signal_connect(G_OBJECT(change->insert), "clicked",
			  G_CALLBACK(gui_gtk_change_insert_event), change);
	gtk_widget_show(change->insert);
	gtk_box_pack_start(GTK_BOX(change), change->insert,
			FALSE, FALSE, 1);

	/* Remove Button */
	change->remove = gtk_button_new_with_label("Remove");
	GTK_WIDGET_UNSET_FLAGS(change->remove, GTK_CAN_FOCUS);
	g_signal_connect(G_OBJECT(change->remove), "clicked",
			  G_CALLBACK(gui_gtk_change_remove_event), change);
	gtk_widget_hide(change->remove);
	gtk_box_pack_start(GTK_BOX(change), change->remove,
			FALSE, FALSE, 1);

	/* Media Selection Dialog */
	change->window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_widget_hide(change->window);
	g_signal_connect(change->window,
			"delete-event",
			G_CALLBACK(gui_gtk_change_delete_event), change);

	gtk_container_set_border_width(GTK_CONTAINER(change->window), 10);

	frame = gtk_frame_new("Select medium");
	gtk_container_add(GTK_CONTAINER(change->window), frame);
	gtk_widget_show(frame);

	change->box = gtk_vbox_new(FALSE, 5);
	gtk_container_set_border_width(GTK_CONTAINER(change->box), 5);
	gtk_widget_show(change->box);
	gtk_container_add(GTK_CONTAINER(frame), change->box);

	list_frame = gtk_hbox_new(FALSE, 5);
	gtk_container_add(GTK_CONTAINER(change->box), list_frame);
	gtk_widget_show(list_frame);

	change->media_store = gtk_list_store_new(2, G_TYPE_STRING, G_TYPE_INT);
	change->list_box = gtk_tree_view_new_with_model(GTK_TREE_MODEL(change->media_store));

	renderer = gtk_cell_renderer_text_new();
	column = gtk_tree_view_column_new_with_attributes("Media", renderer, "text", 0, NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(change->list_box), column);
	gtk_widget_show(change->list_box);
	gtk_container_add(GTK_CONTAINER(list_frame), change->list_box);
	change->media_select = gtk_tree_view_get_selection(GTK_TREE_VIEW(change->list_box));
	g_signal_connect(G_OBJECT(change->media_select), "changed",
			G_CALLBACK(gui_gtk_change_media_selection_changed_event), change);

	change->nmedias = 0;

	change->button_box = gtk_hbox_new(FALSE, 5);
	gtk_widget_show(change->button_box);
	gtk_container_add(GTK_CONTAINER(change->box), change->button_box);

	change->button_cancel = gtk_button_new_from_stock(GTK_STOCK_CANCEL);
	gtk_widget_show(change->button_cancel);
	gtk_container_add(GTK_CONTAINER(change->button_box), change->button_cancel);
	g_signal_connect(change->button_cancel,
			"clicked",
			G_CALLBACK(gui_gtk_change_cancel_button_event), change);

	change->button_ok = gtk_button_new_from_stock(GTK_STOCK_OK);
	gtk_widget_show(change->button_ok);
	gtk_container_add(GTK_CONTAINER(change->button_box), change->button_ok);
	gtk_widget_set_sensitive(change->button_ok, 0);
	g_signal_connect(change->button_ok,
			"clicked",
			G_CALLBACK(gui_gtk_change_ok_button_event), change);
}

GType
gui_gtk_change_get_type(void)
{
	static GType ttt_type = 0;

	if (! ttt_type) {
		static const GTypeInfo ttt_info = {
			sizeof(GuiGtkChangeClass),
			NULL,	/* base_init */
			NULL,	/* base_finalize */
			(GClassInitFunc) gui_gtk_change_class_init,
			NULL,	/* class_finalize */
			NULL,	/* class_data */
			sizeof(GuiGtkChange),
			0,	/* n_preallocs */
			(GInstanceInitFunc) gui_gtk_change_init,
		};

		ttt_type = g_type_register_static (GTK_TYPE_HBOX,
				"Change", &ttt_info, 0);
	}

	return ttt_type;
}

#define GUIGTKCHANGE_TYPE	gui_gtk_change_get_type()

GtkWidget *
gui_gtk_change_new(const char *type)
{
	GuiGtkChange *change;
	const char *icon;
	GtkWidget *icon0;
	GtkWidget *icon1;

	change = GUI_GTK_CHANGE(g_object_new(GUIGTKCHANGE_TYPE, NULL));
	GTK_WIDGET_UNSET_FLAGS(GTK_WIDGET(change), GTK_CAN_FOCUS);

	change->type = type;

	if (strcmp(type, "CD") == 0
	 || strcmp(type, "DVD") == 0) {
		icon = "gtk-cdrom";
	} else if (strcmp(type, "Floppy") == 0) {
		icon = "gtk-floppy";
	} else {
		icon = NULL;
	}
	if (icon) {
		icon0 = gtk_image_new_from_stock(icon, GTK_ICON_SIZE_BUTTON);
		icon1 = gtk_image_new_from_stock(icon, GTK_ICON_SIZE_BUTTON);
		gtk_button_set_image(GTK_BUTTON(change->insert), icon0);
		gtk_button_set_image(GTK_BUTTON(change->remove), icon1);
	}

	return GTK_WIDGET(change);
}

void
gui_gtk_change_set(GuiGtkChange *change, const char *string)
{
	if (*string) {
		gtk_widget_hide(change->insert);
		gtk_widget_show(change->remove);
	} else {
		gtk_widget_show(change->insert);
		gtk_widget_hide(change->remove);
	}
}
