/*
 * $Id: conn_usb.c,v 1.9 2009-06-03 11:34:06 vrsieh Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "conn_usb.h"

struct cpssp {
	struct sig_boolean_merge *forward_power;
	struct sig_usb_bus_main_merge *forward_main;
};

void *
conn_usb_create(
	const char *name,
	struct sig_manage *port_manage,

	struct sig_usb_bus *port_usb,

	struct sig_boolean *port_power,
	struct sig_usb_bus_main *port_main
)
{
	struct cpssp *cpssp;

	cpssp = malloc(sizeof(*cpssp));
	assert(cpssp);

	cpssp->forward_main = sig_usb_bus_main_merge(port_usb->bus, port_main);
	cpssp->forward_power = sig_boolean_merge(port_power, port_usb->power);

	return cpssp;
}

void
conn_usb_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	free(cpssp);
}
