/* $Id: main.c,v 1.3 2009-01-28 17:45:10 potyra Exp $ 
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"
#include "glue-log.h"
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <errno.h>

#include "sac_parser.h"

extern FILE *yyin;
extern int yyparse(void);

static void
sigs_and_comps_parse(const char *filename)
{
	int ret;
	assert(filename != NULL);

	yyin = fopen(filename, "r");
	if (yyin == NULL) {
		faum_log(FAUM_LOG_ERROR, "sigs_and_comps", __func__,
		"Failed to open file \"%s\": %s\n",
			filename, strerror(errno));
		return;
	}

	ret = yyparse();
	if (ret != 0) {
		faum_log(FAUM_LOG_ERROR, "sigs_and_comps", __func__,
			"Failed to parse file \"%s\"\n", filename);
		ret = fclose(yyin);
		assert(ret >= 0);
		return;
	}

	ret = fclose(yyin);
	assert(ret >= 0);
}

int
main(int argc, char **argv)
{
	if (argc == 2) {
		sigs_and_comps_parse(argv[1]);
		return 0;
	}
	return 0;
}
