/*
 *  $Id: vt102_monitor_gui_gtk.c,v 1.8 2009-01-28 12:59:22 potyra Exp $
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */


#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include <gtk/gtk.h>

#include "glue-gui-gtk.h"
#include "gui-gtk.h"

#include "vt102_monitor_gui.h"

#define COMP "vt102_monitor"

struct cpssp {
	GtkWidget *gui;
};

static struct cpssp *iface[100];

/*
 * Simulator Callbacks
 */
static void
vt102_monitor_gui_pixel_set(
        void *_cpssp,
        unsigned int x,
        unsigned int y,
        uint8_t r,
        uint8_t g,
        uint8_t b
)
{
        struct cpssp *cpssp = (struct cpssp *) _cpssp;

        gui_gtk_monitor_pixel_set(GUI_GTK_MONITOR(cpssp->gui), x, y, r, g, b);
}

static void
vt102_monitor_gui_size_set(
	void *_cpssp,
	unsigned int width,
	unsigned int height
)
{
        struct cpssp *cpssp = (struct cpssp *) _cpssp;

        gui_gtk_monitor_size_set(GUI_GTK_MONITOR(cpssp->gui), width, height);
}

static void
vt102_monitor_gui_sync(void *_cpssp)
{
        struct cpssp *cpssp = (struct cpssp *) _cpssp;

        gui_gtk_monitor_sync(GUI_GTK_MONITOR(cpssp->gui));
}

static void
vt102_monitor_gui_screenshot_set(void *_cpssp, int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	if (val == 0) return;

	gui_gtk_monitor_screenshot(GUI_GTK_MONITOR(cpssp->gui), val);
}

/*
 * GUI Callbacks
 */

void
vt102_monitor_gui_init(
	unsigned int nr,
	struct sig_boolean *port_power_230v,
	struct sig_video *port_video,
	struct sig_opt_rgb *port_opt_video,
	struct sig_integer *port_screenshot
)
{
	static const struct sig_opt_rgb_funcs opt_video_funcs = {
		.pixel_set = vt102_monitor_gui_pixel_set,
		.size_set = vt102_monitor_gui_size_set,
		.sync = vt102_monitor_gui_sync,
	};
	static const struct sig_integer_funcs screenshot_funcs = {
		.set = vt102_monitor_gui_screenshot_set,
	};
	struct cpssp *cpssp;

	cpssp = iface[nr];
	assert(cpssp);

	/* In */
	sig_opt_rgb_connect(port_opt_video, cpssp, &opt_video_funcs);
	sig_integer_connect_in(port_screenshot, cpssp, &screenshot_funcs);
}

void
vt102_monitor_gui_create(unsigned int page, unsigned int nr, const char *name)
{
	struct cpssp *cpssp;

	cpssp = malloc(sizeof(*cpssp));
	assert(cpssp);

	cpssp->gui = gui_gtk_monitor_new("VT102", 640, 400);

	gtk_widget_show(cpssp->gui);
	gui_comp_add(page, COMP, nr, name, cpssp->gui, TRUE, TRUE, NULL);
	gui_gtk_monitor_grab_focus(GUI_GTK_MONITOR(cpssp->gui));

	iface[nr] = cpssp;
}

void
vt102_monitor_gui_destroy(unsigned int nr)
{
	struct cpssp *cpssp;

	cpssp = iface[nr];
	assert(cpssp);

	free(cpssp);

	iface[nr] = NULL;
}
