/*
 * $Id: vt102_core_gui_gtk.c,v 1.10 2009-01-28 12:59:22 potyra Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>

#include "glue-gui-gtk.h"
#include "gui-gtk.h"

#include "vt102_core_gui.h"

#define COMP "vt102_core"

struct cpssp {
	GtkWidget *widget;

	struct sig_boolean *port_mech_power_switch;
};

static struct cpssp *iface[100];

/*
 * Simulator Callbacks
 */
static void
vt102_core_mech_power_switch_set(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	gui_gtk_switch_set(GUI_GTK_SWITCH(cpssp->widget),
			(gboolean) val);
	gui_gtk_flush();
}

/*
 * GUI Callbacks
 */
static void
vt102_core_mech_power_switched_on_event(GtkWidget *w, gpointer _cpssp)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	sig_boolean_set(cpssp->port_mech_power_switch, cpssp, 1);
}

static void
vt102_core_mech_power_switched_off_event(GtkWidget *w, gpointer _cpssp)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	sig_boolean_set(cpssp->port_mech_power_switch, cpssp, 0);
}

void
vt102_core_gui_init(
	unsigned int nr,
	struct sig_boolean *port_mech_power_switch,
	struct sig_serial *port_serial,
	struct sig_integer *port_keyboard,
	struct sig_video *port_video
)
{
	static const struct sig_boolean_funcs mech_power_switch_funcs = {
		.set = vt102_core_mech_power_switch_set,
	};
	struct cpssp *cpssp;

	cpssp = iface[nr];
	assert(cpssp);

	/* Out */
	cpssp->port_mech_power_switch = port_mech_power_switch;
	sig_boolean_connect_out(port_mech_power_switch, cpssp, 0);

	/* In */
	sig_boolean_connect_in(port_mech_power_switch, cpssp,
			&mech_power_switch_funcs);
}

void
vt102_core_gui_create(unsigned int page, unsigned int nr, const char *name)
{
	struct cpssp *cpssp;
	GtkWidget *vbox;

	cpssp = malloc(sizeof(*cpssp));
	assert(cpssp);

	vbox = gtk_vbox_new(FALSE, 1);

	cpssp->widget = gui_gtk_switch_new();
	g_signal_connect(G_OBJECT(cpssp->widget), "switched-on",
			G_CALLBACK(vt102_core_mech_power_switched_on_event),
			cpssp);
	g_signal_connect(G_OBJECT(cpssp->widget), "switched-off",
			G_CALLBACK(vt102_core_mech_power_switched_off_event),
			cpssp);
	gtk_widget_show(cpssp->widget);
	gtk_box_pack_end(GTK_BOX(vbox), cpssp->widget, FALSE, FALSE, 1);

	gtk_widget_show(vbox);
	gui_comp_add(page, COMP, nr, name, vbox, FALSE, FALSE, NULL);

	iface[nr] = cpssp;
}

void
vt102_core_gui_destroy(unsigned int nr)
{
	struct cpssp *cpssp;

	cpssp = iface[nr];
	assert(cpssp);

	free(cpssp);

	iface[nr] = NULL;
}
