/* $Id: pci_ti_1520.c,v 1.20 2009-01-28 12:59:21 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include "fixme.h"
#include <stdio.h>

#include "glue-shm.h"

#include "chip_ti_1520.h"

#include "pci_ti_1520.h"

#define COMP "pci_ti_1520"

struct cpssp {
	/* Config */

	/* Ports */
	struct sig_pci_bus *port_pci;
	struct sig_cardbus *port_card0;
	struct sig_cardbus *port_card1;

	/* Signals */

	/* State */

	/* Processes */
	unsigned int chip;
};

void
pci_ti_1520_init(
	unsigned int nr,
	struct sig_pci_bus *port_pci,
	struct sig_cardbus *port_card0,
	struct sig_cardbus *port_card1
)
{
	struct cpssp *cpssp;

	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	chip_ti_1520_init(cpssp->chip,
			port_pci->p5V, port_pci->n_reset,
			port_pci->idsel, port_pci->main,
			port_pci->intA, port_pci->intB,
			port_card0->p5V, port_card0->n_reset,
			port_card0->bus, port_card0->irq, port_card0->conn,
			port_card1->p5V, port_card1->n_reset,
			port_card1->bus, port_card1->irq, port_card1->conn);
}

void
pci_ti_1520_create(unsigned int nr, const char *name)
{
	struct cpssp *cpssp;

	shm_create(COMP, nr, sizeof(*cpssp));
	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	cpssp->chip = chip_ti_1520_create();

	shm_unmap(cpssp, sizeof(*cpssp));
}

void
pci_ti_1520_destroy(unsigned int nr)
{
	struct cpssp *cpssp;

	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	chip_ti_1520_destroy(cpssp->chip);

	shm_unmap(cpssp, sizeof(*cpssp));
	shm_destroy(COMP, nr);
}
