/*
 * $Id: memory_gui_gtk.c,v 1.19 2009-01-28 12:59:21 potyra Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>

#include "glue-gui-gtk.h"
#include "gui-gtk.h"

#include "memory_gui.h"

#define COMP "memory"

struct cpssp {
	unsigned long size;

	struct sig_fault *fault_bitflip;
	struct sig_fault *fault_stuck_at_0;
	struct sig_fault *fault_stuck_at_1;
	struct sig_fault *fault_coupling;

	GtkWidget *gui_fi;
};

static struct cpssp *iface[100];

/*
 * Simulator Callbacks
 */

/*
 * GUI Callbacks
 */
static void
memory_gui_bit_flip_event(GtkWidget *w, gpointer _fault, gpointer _cpssp)
{
	struct fault {
		unsigned int state;
		const char *loc0[4];
		const char *loc1[4];
	} *fault = (struct fault *) _fault;
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	sig_fault_set(cpssp->fault_bitflip, cpssp,
			strtoul(fault->loc0[0], NULL, 0) * 8
				+ strtoul(fault->loc0[1], NULL, 0),
			0, fault->state);

	free(fault);
}

static void
memory_gui_stuck_at_0_event(GtkWidget *w, gpointer _fault, gpointer _cpssp)
{
	struct fault {
		unsigned int state;
		const char *loc0[4];
		const char *loc1[4];
	} *fault = (struct fault *) _fault;
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	sig_fault_set(cpssp->fault_stuck_at_0, cpssp,
			strtoul(fault->loc0[0], NULL, 0) * 8
				+ strtoul(fault->loc0[1], NULL, 0),
			0, fault->state);

	free(fault);
}

static void
memory_gui_stuck_at_1_event(GtkWidget *w, gpointer _fault, gpointer _cpssp)
{
	struct fault {
		unsigned int state;
		const char *loc0[4];
		const char *loc1[4];
	} *fault = (struct fault *) _fault;
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	sig_fault_set(cpssp->fault_stuck_at_1, cpssp,
			strtoul(fault->loc0[0], NULL, 0) * 8
				+ strtoul(fault->loc0[1], NULL, 0),
			0, fault->state);

	free(fault);
}

static void
memory_gui_coupling_event(GtkWidget *w, gpointer _fault, gpointer _cpssp)
{
	struct fault {
		unsigned int state;
		const char *loc0[4];
		const char *loc1[4];
	} *fault = (struct fault *) _fault;
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	sig_fault_set(cpssp->fault_coupling, cpssp,
			strtoul(fault->loc0[0], NULL, 0) * 8
				+ strtoul(fault->loc0[1], NULL, 0),
			strtoul(fault->loc1[0], NULL, 0) * 8
				+ strtoul(fault->loc1[1], NULL, 0),
			fault->state);

	free(fault);
}

void
memory_gui_init(
	unsigned int nr,
	struct sig_manage *manage,
	struct sig_mem_bus *port_conn,
	struct sig_fault *fault_bitflip,
	struct sig_fault *fault_stuck_at_0,
	struct sig_fault *fault_stuck_at_1,
	struct sig_fault *fault_coupling
)
{
	struct cpssp *cpssp;

	cpssp = iface[nr];
	assert(cpssp);

	cpssp->fault_bitflip = fault_bitflip;
	cpssp->fault_stuck_at_0 = fault_stuck_at_0;
	cpssp->fault_stuck_at_1 = fault_stuck_at_1;
	cpssp->fault_coupling = fault_coupling;
}

void
memory_gui_create(
	unsigned int page,
	unsigned int nr,
	const char *name,
	const char *size
)
{
	struct cpssp *cpssp;
	GtkWidget *w;

	cpssp = malloc(sizeof(*cpssp));
	assert(cpssp);

	if (size == NULL) {
		cpssp->size = 32 * 1024 * 1024;
	} else {
		cpssp->size = strtoul(size, NULL, 0) * 1024 * 1024;
	}

	cpssp->gui_fi = gtk_vbox_new(FALSE, 1);

	w = gui_gtk_fi_pattern_new(
		"Bit Flip", "Trigger",
		2, "Address", 0ULL, (unsigned long long) cpssp->size - 1, NULL, "Bit", 0ULL, 7ULL, NULL,
		0);
	g_signal_connect(G_OBJECT(w), "fi-change",
			G_CALLBACK(memory_gui_bit_flip_event), cpssp);

	gtk_widget_show(w);
	gtk_box_pack_start(GTK_BOX(cpssp->gui_fi), w, FALSE, FALSE, 1);

	w = gui_gtk_fi_pattern_new(
		"Stuck-At-0", "Boolean",
		2, "Address", 0ULL, (unsigned long long) cpssp->size - 1, NULL, "Bit", 0ULL, 7ULL, NULL,
		0);
	g_signal_connect(G_OBJECT(w), "fi-change",
			G_CALLBACK(memory_gui_stuck_at_0_event), cpssp);

	gtk_widget_show(w);
	gtk_box_pack_start(GTK_BOX(cpssp->gui_fi), w, FALSE, FALSE, 1);

	w = gui_gtk_fi_pattern_new(
		"Stuck-At-1", "Boolean",
		2, "Address", 0ULL, (unsigned long long) cpssp->size - 1, NULL, "Bit", 0ULL, 7ULL, NULL,
		0);
	g_signal_connect(G_OBJECT(w), "fi-change",
			G_CALLBACK(memory_gui_stuck_at_1_event), cpssp);

	gtk_widget_show(w);
	gtk_box_pack_start(GTK_BOX(cpssp->gui_fi), w, FALSE, FALSE, 1);

	w = gui_gtk_fi_pattern_new(
		"Coupling", "Boolean",
		2, "Address", 0ULL, (unsigned long long) cpssp->size - 1, NULL, "Bit", 0ULL, 7ULL, NULL,
		2, "Address", 0ULL, (unsigned long long) cpssp->size - 1, NULL, "Bit", 0ULL, 7ULL, NULL);
	g_signal_connect(G_OBJECT(w), "fi-change",
			G_CALLBACK(memory_gui_coupling_event), cpssp);

	gtk_widget_show(w);
	gtk_box_pack_start(GTK_BOX(cpssp->gui_fi), w, FALSE, FALSE, 1);

	gui_comp_add(page, COMP, nr, name, NULL, FALSE, FALSE, cpssp->gui_fi);

	iface[nr] = cpssp;
}

void
memory_gui_destroy(unsigned int nr)
{
	struct cpssp *cpssp;

	cpssp = iface[nr];
	assert(cpssp);

	free(cpssp);

	iface[nr] = NULL;
}
