/*
 * $Id: keyboard_gui_gtk.c,v 1.11 2009-01-28 12:59:20 potyra Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>

#include "glue-gui-gtk.h"
#include "gui-gtk.h"

#include "keyboard_gui.h"

#define COMP "keyboard"

struct cpssp {
	struct sig_boolean *port_key[128];

	GtkWidget *gui_keyboard;
};

static struct cpssp *iface[100];

/*
 * Simulator Callbacks
 */

static void
gui_keyboard_opt_num_led_set(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	gui_gtk_keyboard_num_led_set(GUI_GTK_KEYBOARD(cpssp->gui_keyboard), val);
	gui_gtk_flush();
}

static void
gui_keyboard_opt_caps_led_set(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	gui_gtk_keyboard_caps_led_set(GUI_GTK_KEYBOARD(cpssp->gui_keyboard), val);
	gui_gtk_flush();
}

static void
gui_keyboard_opt_scroll_led_set(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	gui_gtk_keyboard_scroll_led_set(GUI_GTK_KEYBOARD(cpssp->gui_keyboard), val);
	gui_gtk_flush();
}

/*
 * GUI Callbacks
 */
static void
keyboard_gui_type_event(GtkWidget *w, int val, gpointer _cpssp)
{
	int nr = (val >> 16);
	int pressed = (int16_t) val;
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	assert(cpssp->port_key[nr]);

	sig_boolean_set(cpssp->port_key[nr], cpssp, pressed);
}

void
keyboard_gui_init(
	unsigned int nr,
	struct sig_ps2 *port_ps2,
	struct sig_boolean *port_key0,
	struct sig_boolean *port_key1,
	struct sig_boolean *port_key2,
	struct sig_boolean *port_key3,
	struct sig_boolean *port_key4,
	struct sig_boolean *port_key5,
	struct sig_boolean *port_key6,
	struct sig_boolean *port_key7,
	struct sig_boolean *port_key8,
	struct sig_boolean *port_key9,
	struct sig_boolean *port_key10,
	struct sig_boolean *port_key11,
	struct sig_boolean *port_key12,
	struct sig_boolean *port_key13,
	struct sig_boolean *port_key14,
	struct sig_boolean *port_key15,
	struct sig_boolean *port_key16,
	struct sig_boolean *port_key17,
	struct sig_boolean *port_key18,
	struct sig_boolean *port_key19,
	struct sig_boolean *port_key20,
	struct sig_boolean *port_key21,
	struct sig_boolean *port_key22,
	struct sig_boolean *port_key23,
	struct sig_boolean *port_key24,
	struct sig_boolean *port_key25,
	struct sig_boolean *port_key26,
	struct sig_boolean *port_key27,
	struct sig_boolean *port_key28,
	struct sig_boolean *port_key29,
	struct sig_boolean *port_key30,
	struct sig_boolean *port_key31,
	struct sig_boolean *port_key32,
	struct sig_boolean *port_key33,
	struct sig_boolean *port_key34,
	struct sig_boolean *port_key35,
	struct sig_boolean *port_key36,
	struct sig_boolean *port_key37,
	struct sig_boolean *port_key38,
	struct sig_boolean *port_key39,
	struct sig_boolean *port_key40,
	struct sig_boolean *port_key41,
	struct sig_boolean *port_key42,
	struct sig_boolean *port_key43,
	struct sig_boolean *port_key44,
	struct sig_boolean *port_key45,
	struct sig_boolean *port_key46,
	struct sig_boolean *port_key47,
	struct sig_boolean *port_key48,
	struct sig_boolean *port_key49,
	struct sig_boolean *port_key50,
	struct sig_boolean *port_key51,
	struct sig_boolean *port_key52,
	struct sig_boolean *port_key53,
	struct sig_boolean *port_key54,
	struct sig_boolean *port_key55,
	struct sig_boolean *port_key56,
	struct sig_boolean *port_key57,
	struct sig_boolean *port_key58,
	struct sig_boolean *port_key59,
	struct sig_boolean *port_key60,
	struct sig_boolean *port_key61,
	struct sig_boolean *port_key62,
	struct sig_boolean *port_key63,
	struct sig_boolean *port_key64,
	struct sig_boolean *port_key65,
	struct sig_boolean *port_key66,
	struct sig_boolean *port_key67,
	struct sig_boolean *port_key68,
	struct sig_boolean *port_key69,
	struct sig_boolean *port_key70,
	struct sig_boolean *port_key71,
	struct sig_boolean *port_key72,
	struct sig_boolean *port_key73,
	struct sig_boolean *port_key74,
	struct sig_boolean *port_key75,
	struct sig_boolean *port_key76,
	struct sig_boolean *port_key77,
	struct sig_boolean *port_key78,
	struct sig_boolean *port_key79,
	struct sig_boolean *port_key80,
	struct sig_boolean *port_key81,
	struct sig_boolean *port_key82,
	struct sig_boolean *port_key83,
	struct sig_boolean *port_key84,
	struct sig_boolean *port_key85,
	struct sig_boolean *port_key86,
	struct sig_boolean *port_key87,
	struct sig_boolean *port_key88,
	struct sig_boolean *port_key89,
	struct sig_boolean *port_key90,
	struct sig_boolean *port_key91,
	struct sig_boolean *port_key92,
	struct sig_boolean *port_key93,
	struct sig_boolean *port_key94,
	struct sig_boolean *port_key95,
	struct sig_boolean *port_key96,
	struct sig_boolean *port_key97,
	struct sig_boolean *port_key98,
	struct sig_boolean *port_key99,
	struct sig_boolean *port_key100,
	struct sig_boolean *port_key101,
	struct sig_boolean *port_key102,
	struct sig_boolean *port_key103,
	struct sig_boolean *port_key104,
	struct sig_boolean *port_key105,
	struct sig_boolean *port_key106,
	struct sig_boolean *port_key107,
	struct sig_boolean *port_key108,
	struct sig_boolean *port_key109,
	struct sig_boolean *port_key110,
	struct sig_boolean *port_key111,
	struct sig_boolean *port_key112,
	struct sig_boolean *port_key113,
	struct sig_boolean *port_key114,
	struct sig_boolean *port_key115,
	struct sig_boolean *port_key116,
	struct sig_boolean *port_key117,
	struct sig_boolean *port_key118,
	struct sig_boolean *port_key119,
	struct sig_boolean *port_key120,
	struct sig_boolean *port_key121,
	struct sig_boolean *port_key122,
	struct sig_boolean *port_key123,
	struct sig_boolean *port_key124,
	struct sig_boolean *port_key125,
	struct sig_boolean *port_key126,
	struct sig_boolean *port_key127,
	struct sig_boolean *port_opt_num_led,
	struct sig_boolean *port_opt_caps_led,
	struct sig_boolean *port_opt_scroll_led
)
{
	static const struct sig_boolean_funcs opt_num_led_funcs = {
		.set = gui_keyboard_opt_num_led_set,
	};
	static const struct sig_boolean_funcs opt_caps_led_funcs = {
		.set = gui_keyboard_opt_caps_led_set,
	};
	static const struct sig_boolean_funcs opt_scroll_led_funcs = {
		.set = gui_keyboard_opt_scroll_led_set,
	};
	struct cpssp *cpssp;

	cpssp = iface[nr];
	assert(cpssp);

#define func(nr) \
	cpssp->port_key[nr] = port_key ## nr

	func(0); func(1); func(2); func(3);
	func(4); func(5); func(6); func(7);
	func(8); func(9); func(10); func(11);
	func(12); func(13); func(14); func(15);
	func(16); func(17); func(18); func(19);
	func(20); func(21); func(22); func(23);
	func(24); func(25); func(26); func(27);
	func(28); func(29); func(30); func(31);
	func(32); func(33); func(34); func(35);
	func(36); func(37); func(38); func(39);
	func(40); func(41); func(42); func(43);
	func(44); func(45); func(46); func(47);
	func(48); func(49); func(50); func(51);
	func(52); func(53); func(54); func(55);
	func(56); func(57); func(58); func(59);
	func(60); func(61); func(62); func(63);
	func(64); func(65); func(66); func(67);
	func(68); func(69); func(70); func(71);
	func(72); func(73); func(74); func(75);
	func(76); func(77); func(78); func(79);
	func(80); func(81); func(82); func(83);
	func(84); func(85); func(86); func(87);
	func(88); func(89); func(90); func(91);
	func(92); func(93); func(94); func(95);
	func(96); func(97); func(98); func(99);
	func(100); func(101); func(102); func(103);
	func(104); func(105); func(106); func(107);
	func(108); func(109); func(110); func(111);
	func(112); func(113); func(114); func(115);
	func(116); func(117); func(118); func(119);
	func(120); func(121); func(122); func(123);
	func(124); func(125); func(126); func(127);

#undef func

	/* Out */
#define func(nr) \
	sig_boolean_connect_out(port_key ## nr, cpssp, 0)

	func(0); func(1); func(2); func(3);
	func(4); func(5); func(6); func(7);
	func(8); func(9); func(10); func(11);
	func(12); func(13); func(14); func(15);
	func(16); func(17); func(18); func(19);
	func(20); func(21); func(22); func(23);
	func(24); func(25); func(26); func(27);
	func(28); func(29); func(30); func(31);
	func(32); func(33); func(34); func(35);
	func(36); func(37); func(38); func(39);
	func(40); func(41); func(42); func(43);
	func(44); func(45); func(46); func(47);
	func(48); func(49); func(50); func(51);
	func(52); func(53); func(54); func(55);
	func(56); func(57); func(58); func(59);
	func(60); func(61); func(62); func(63);
	func(64); func(65); func(66); func(67);
	func(68); func(69); func(70); func(71);
	func(72); func(73); func(74); func(75);
	func(76); func(77); func(78); func(79);
	func(80); func(81); func(82); func(83);
	func(84); func(85); func(86); func(87);
	func(88); func(89); func(90); func(91);
	func(92); func(93); func(94); func(95);
	func(96); func(97); func(98); func(99);
	func(100); func(101); func(102); func(103);
	func(104); func(105); func(106); func(107);
	func(108); func(109); func(110); func(111);
	func(112); func(113); func(114); func(115);
	func(116); func(117); func(118); func(119);
	func(120); func(121); func(122); func(123);
	func(124); func(125); func(126); func(127);

#undef func

	/* In */
	sig_boolean_connect_in(port_opt_num_led, cpssp, &opt_num_led_funcs);
	sig_boolean_connect_in(port_opt_caps_led, cpssp, &opt_caps_led_funcs);
	sig_boolean_connect_in(port_opt_scroll_led, cpssp, &opt_scroll_led_funcs);
}

void
keyboard_gui_create(unsigned int page, unsigned int nr, const char *name)
{
	struct cpssp *cpssp;

	cpssp = malloc(sizeof(*cpssp));
	assert(cpssp);

	cpssp->gui_keyboard = gui_gtk_keyboard_new();
	g_signal_connect(G_OBJECT(cpssp->gui_keyboard), "keyboard-type",
			G_CALLBACK(keyboard_gui_type_event), cpssp);

	gtk_widget_show(cpssp->gui_keyboard);
	gui_comp_add(page, COMP, nr, name, cpssp->gui_keyboard,
			FALSE, FALSE, NULL);

	iface[nr] = cpssp;
}

void
keyboard_gui_destroy(unsigned int nr)
{
	struct cpssp *cpssp;

	cpssp = iface[nr];
	assert(cpssp);

	free(cpssp);

	iface[nr] = NULL;
}
