/* $Id: glue-gui-gtk-monitor.h,v 1.11 2009-01-27 17:44:19 potyra Exp $ 
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __GLUE_GUI_GTK_MONITOR_H_INCLUDED
#define __GLUE_GUI_GTK_MONITOR_H_INCLUDED

#include <inttypes.h>

struct gui_gtk_monitor_screen_size {
	unsigned int width;
	unsigned int height;
};

typedef struct {
	GtkHBox parent;

	GtkWidget *screen;
	GtkWidget *eventbox;
	GtkWidget *scrollwindow;
	GtkWidget *screenshot_button;
	GtkWidget *record_button;
	GtkWidget *zoom_in_button;
	GtkWidget *zoom_out_button;

	unsigned int dest_tile_width;
	unsigned int dest_tile_height;
	unsigned int src_tile_width;
	unsigned int src_tile_height;
	unsigned int min_tiles_x;
	unsigned int min_tiles_y;
	unsigned int tiles_row_stride;
	unsigned int monitor_width;
	unsigned int monitor_height;
	unsigned int screen_width;
	unsigned int screen_height;
	unsigned int true_width;
	unsigned int true_height;

	uint8_t *screen_data;

	int *dirty;

	struct gui_gtk_monitor_screen_size *zoom_steps;
	int zoom_step;

	FILE *fp;
} GuiGtkMonitor;

#define GUI_GTK_TYPE_MONITOR	(gui_gtk_monitor_get_type())
#define GUI_GTK_MONITOR(obj)	(G_TYPE_CHECK_INSTANCE_CAST((obj), GUI_GTK_TYPE_MONITOR, GuiGtkMonitor))

extern GType
gui_gtk_monitor_get_type(void);

extern GtkWidget *
gui_gtk_monitor_new(
	const char *type,
	unsigned int monitor_width,
	unsigned int monitor_height
);

extern void
gui_gtk_monitor_grab_focus(GuiGtkMonitor *monitor);

extern void
gui_gtk_monitor_pixel_set(
	GuiGtkMonitor *monitor,
	unsigned int x,
	unsigned int y,
	uint8_t r,
	uint8_t g,
	uint8_t b
);

extern void
gui_gtk_monitor_size_set(
	GuiGtkMonitor *monitor,
	unsigned int width,
	unsigned int height
);

extern void
gui_gtk_monitor_sync(GuiGtkMonitor *monitor);

extern void
gui_gtk_monitor_screenshot(GuiGtkMonitor *monitor, int nr);

#endif /* __GLUE_GUI_GTK_MONITOR_H_INCLUDED */
