--
-- $Id: test_bench.vhdl,v 1.1 2009-02-18 12:35:03 potyra Exp $
--

library expect;
use expect.types.all;
use expect.procedures.all;
library ieee;
use ieee.std_logic_1164.ALL;

entity test_bench is
end test_bench;

architecture structural of test_bench is
	signal ext_eth0 : eth;
	signal ext_usb0 : usb_bus;
	signal ext_usb1 : usb_bus;
	signal ext_par : parallel;
	signal ext_ser0 : serial;
	signal ext_ser1 : serial;

	signal power_switch : boolean;
	signal power_button : boolean;
	signal reset_button : boolean;

	signal floppy : cstring;
	signal cdrom : cstring;

	signal key : boolean_array(0 to 127);

	signal mouse_dx : integer;
	signal mouse_dy : integer;
	signal mouse_dz : integer;
	signal mouse_button1 : boolean;
	signal mouse_button2 : boolean;
	signal mouse_button3 : boolean;
	signal mouse_button4 : boolean;
	signal mouse_button5 : boolean;

	signal screen_shot : integer;

	signal opt_screen : opt_rgb;
	signal phone0 : telephone;
	signal phone1 : telephone;
	signal phone2 : telephone;

begin
	pc : pc_standard
		port map(
			ext_eth0 => ext_eth0,
			ext_usb0 => ext_usb0,
			ext_usb1 => ext_usb1,
			ext_par => ext_par,
			ext_ser0 => ext_ser0,
			ext_ser1 => ext_ser1,
			power_switch => power_switch,
			power_button => power_button,
			reset_button => reset_button,
			floppy => floppy,
			cdrom => cdrom,
			key => key,
			mouse_dx => mouse_dx,
			mouse_dy => mouse_dy,
			mouse_dz => mouse_dz,
			mouse_button1 => mouse_button1,
			mouse_button2 => mouse_button2,
			mouse_button3 => mouse_button3,
			mouse_button4 => mouse_button4,
			mouse_button5 => mouse_button5,
			screen_shot => screen_shot,
			opt_screen => opt_screen
		);
	user : user
		port map(
			power_switch => power_switch,
			power_button => power_button,
			reset_button => reset_button,
			floppy => floppy,
			cdrom => cdrom,
			key => key,
			mouse_dx => mouse_dx,
			mouse_dy => mouse_dy,
			mouse_dz => mouse_dz,
			mouse_button1 => mouse_button1,
			mouse_button2 => mouse_button2,
			mouse_button3 => mouse_button3,
			mouse_button4 => mouse_button4,
			mouse_button5 => mouse_button5,
			screen_shot => screen_shot,
			opt_screen => opt_screen
		);

	modem : serial_modem 
		PORT MAP (
			serial => ext_ser0,
			phone => phone0,
			switch => power_switch
		);
	telephone_provider : telephone_switch
		PORT MAP (
			phone0 => phone0,
			phone1 => phone1,
			phone2 => phone2,
			switch => power_switch
		);
	isp : telephone_isp
		PORT MAP (
			phone => phone1,
			switch => power_switch
		);

end structural;
