/* $Id: OpCode.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * OpCode: base class for all opcodes (intermediate opcode)
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */


#ifndef __OP_CODE_HPP_INCLUDED
#define __OP_CODE_HPP_INCLUDED

#include "intermediate/Node.hpp"

namespace intermediate {

//! base class for all opcodes.
/** OpCode is a generic base class for all opcodes of the intermediate code.
 *
 *  All opcodes descriptions should be annotated with what they do.
 *  read operands: all operands that will get read from.
 *  write operands: all operands, that will get written to.
 *  Operation: effect of the opcode.
 *
 *  Others: /PC/ is the implicit program counter.
 *  
 *  EVERY opcode will implicitely perform a /PC/ = /PC/ + 1
 */
class OpCode : public Node {
public:
};

}; /* namespace intermediate */

#endif /* __OP_CODE_HPP_INCLUDED */
