/* $Id: Types.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Types: base types of VHDL.
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __TYPES_HPP_INCLUDED
#define __TYPES_HPP_INCLUDED

extern "C" {
#include "util/basetypes.h"
};

#include "intermediate/operands/Operand.hpp"

namespace ast {

/** base type enumeration 
 *  @TODO maybe uniform array and record to composite? */
enum BaseType {
	BASE_TYPE_INTEGER, 	/**< (universal) integer based */
	BASE_TYPE_REAL,		/**< (universal) real (float) based */
	BASE_TYPE_ARRAY,	/**< array based */
	BASE_TYPE_RECORD,	/**< record based */
	BASE_TYPE_RANGE_INT,	/**< a (integer) range */
	BASE_TYPE_RANGE_REAL,	/**< a (float) range */
	BASE_TYPE_ENUM,		/**< an enumeration type */
	BASE_TYPE_UNSET,	/**< base type not yet set. */
};

/** resolve two base types.
 *  @param left left operand
 *  @param right right operand.
 *  @return resolved type.
 */
enum BaseType
operator &&(enum BaseType left, enum BaseType right);

/** create an opcode type from a base type.
 *  @param src base type enumeration to transform to an OpType. */
enum intermediate::OpType
toOpType(enum BaseType src);

}; /* namespace ast */

#endif /* __TYPES_HPP_INCLUDED */
