/* $Id: RecordType.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 *  RecordType: one VHDL Record type.
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */


#ifndef __RECORD_TYPE_HPP_INCLUDED
#define __RECORD_TYPE_HPP_INCLUDED

#include <list>
#include "frontend/ast/TypeDeclaration.hpp"
#include "frontend/ast/RecordTypeElement.hpp"

namespace ast {

//! VHDL record type.
/** This class represents one VHDL record type declaration.
 */
class RecordType : public TypeDeclaration {
public:
	//! c'tor
	/** @param id type name of declared type.
          * @param elems elements of record.
          * @param loc location of declaration.
          */
	RecordType(
		std::string *id,
		std::list<RecordTypeElement*> *elems,
		Location loc
	);

	//! Accept a Visitor.
 	/** All leaf AST nodes need to implement this method.
         *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor &visitor) {
		visitor.visit(*this);
	}

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const {
		assert(this->name != NULL);
		stream << "RECORD " << *this->name;
	}


	/** record elements */
	std::list<RecordTypeElement*> *elements;

protected:
	/** Destructor */
	virtual ~RecordType() {
		util::MiscUtil::lterminate(elements);
	}
};

}; /* namespace ast */

#endif /* __RECORD_TYPE_HPP_INCLUDED */
