/* $Id: list.c 4321 2009-01-27 13:02:52Z potyra $
 *
 * Generic list structures.
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "list.h"
#include <assert.h>
#include <stdlib.h>

struct slist *
slist_create(void)
{
	struct slist *ret = malloc(sizeof(struct slist));
	assert(ret != NULL);

	ret->first = NULL;
	ret->tail = NULL;

	return ret;
}

void
slist_destroy(struct slist *l)
{
	struct slist_entry *i = l->first;
	struct slist_entry *tmp;

	while (i != NULL) {
		tmp = i;
		i = i->next;
		free(tmp);
	}

	free(l);
}

void
slist_add(struct slist *l, void *data)
{
	struct slist_entry *entry = malloc(sizeof(struct slist_entry));
	assert(entry != NULL);
	assert(l != NULL);

	entry->data = data;
	entry->next = NULL;

	if (l->tail == NULL) {
		l->first = entry;
		l->tail = entry;
	} else {
		l->tail->next = entry;
		l->tail = entry;
	}
}
