FIND_PATH(LIBSSH2_INCLUDE_DIR NAMES libssh2.h)
MARK_AS_ADVANCED(LIBSSH2_INCLUDE_DIR)

FIND_LIBRARY(LIBSSH2_LIBRARY NAMES ssh2)
MARK_AS_ADVANCED(LIBSSH2_LIBRARY)

IF(LIBSSH2_INCLUDE_DIR AND LIBSSH2_LIBRARY)
  SET(LIBSSH2_FOUND 1)
  SET(LIBSSH2_LIBRARIES ${LIBSSH2_LIBRARY})
  SET(LIBSSH2_INCLUDE_DIRS ${LIBSSH2_INCLUDE_DIR})
ELSE(LIBSSH2_INCLUDE_DIR AND LIBSSH2_LIBRARY)
  SET(LIBSSH2_FOUND 0)
  SET(LIBSSH2_LIBRARIES)
  SET(LIBSSH2_INCLUDE_DIRS)
ENDIF(LIBSSH2_INCLUDE_DIR AND LIBSSH2_LIBRARY)

# Report the results.
IF(NOT LIBSSH2_FOUND)
  SET(LIBSSH2_DIR_MESSAGE
      "LIBSSH2 was not found. Make sure LIBSSH2_LIBRARY and LIBSSH2_INCLUDE_DIR are set.")
  IF(NOT LIBSSH2_FIND_QUIETLY)
    MESSAGE(STATUS "${LIBSSH2_DIR_MESSAGE}")
  ELSE(NOT LIBSSH2_FIND_QUIETLY)
    IF(LIBSSH2_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR "${LIBSSH2_DIR_MESSAGE}")
    ENDIF(LIBSSH2_FIND_REQUIRED)
  ENDIF(NOT LIBSSH2_FIND_QUIETLY)
ENDIF(NOT LIBSSH2_FOUND)


