/*
FatRat download manager
http://fatrat.dolezel.info

Copyright (C) 2006-2008 Lubos Dolezel <lubos a dolezel.info>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2 as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#include <QString>
#include <fatrat/fatrat.h>
#include <QTranslator>
#include <QLocale>
#include <QHttpResponseHeader>
#include "config.h"
#include "CzshareDownload.h"
#include "CzshareUpload.h"
#include <QtDebug>

__attribute__ ((constructor)) void init()
{
	Q_INIT_RESOURCE(czshare);
	qRegisterMetaType<QHttpResponseHeader>("QHttpResponseHeader");
	
	{
		EngineEntry e = { "CzshareDownload", "CZshare.com download", CzshareDownload::globalInit, 0, CzshareDownload::createInstance, CzshareDownload::acceptable, 0 };
		addTransferClass(e, Transfer::Download);
	}
	{
		EngineEntry e = { "CzshareUpload", "CZshare.com upload", 0, 0, CzshareUpload::createInstance, 0, 0 };
		addTransferClass(e, Transfer::Upload);
	}
	
#ifdef WITH_NLS
	static QTranslator translator;
	{
		QString fname = QString("fatrat-czshare_") + QLocale::system().name();
		translator.load(fname, getDataFileDir("/lang", fname));
		QCoreApplication::installTranslator(&translator);
	}
#endif
}

extern "C" __attribute__((visibility("default"))) PluginInfo getInfo()
{
	PluginInfo info;
	
	info.version = "1.1.1";
	info.name = QObject::tr("CZshare.com support");
	info.author = QString::fromUtf8("Luboš Doležel");
	info.website = "http://fatrat.dolezel.info";
	
	return info;
}
