// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file enum_struct.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen.
 */

#ifndef FAST_DDS_GENERATED__ENUM_STRUCT_HPP
#define FAST_DDS_GENERATED__ENUM_STRUCT_HPP

#include <cstdint>
#include <utility>

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(ENUM_STRUCT_SOURCE)
#define ENUM_STRUCT_DllAPI __declspec( dllexport )
#else
#define ENUM_STRUCT_DllAPI __declspec( dllimport )
#endif // ENUM_STRUCT_SOURCE
#else
#define ENUM_STRUCT_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define ENUM_STRUCT_DllAPI
#endif // _WIN32

/*!
 * @brief This class represents the enumeration ColorEnum defined by the user in the IDL file.
 * @ingroup enum_struct
 */
enum class ColorEnum : int32_t
{
    RED,
    GREEN,
    BLUE
};
/*!
 * @brief This class represents the structure EnumStruct defined by the user in the IDL file.
 * @ingroup enum_struct
 */
class EnumStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport EnumStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~EnumStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object EnumStruct that will be copied.
     */
    eProsima_user_DllExport EnumStruct(
            const EnumStruct& x)
    {
                    m_enum_value = x.m_enum_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object EnumStruct that will be copied.
     */
    eProsima_user_DllExport EnumStruct(
            EnumStruct&& x) noexcept
    {
        m_enum_value = x.m_enum_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object EnumStruct that will be copied.
     */
    eProsima_user_DllExport EnumStruct& operator =(
            const EnumStruct& x)
    {

                    m_enum_value = x.m_enum_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object EnumStruct that will be copied.
     */
    eProsima_user_DllExport EnumStruct& operator =(
            EnumStruct&& x) noexcept
    {

        m_enum_value = x.m_enum_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x EnumStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const EnumStruct& x) const
    {
        return (m_enum_value == x.m_enum_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x EnumStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const EnumStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member enum_value
     * @param _enum_value New value for member enum_value
     */
    eProsima_user_DllExport void enum_value(
            ColorEnum _enum_value)
    {
        m_enum_value = _enum_value;
    }

    /*!
     * @brief This function returns the value of member enum_value
     * @return Value of member enum_value
     */
    eProsima_user_DllExport ColorEnum enum_value() const
    {
        return m_enum_value;
    }

    /*!
     * @brief This function returns a reference to member enum_value
     * @return Reference to member enum_value
     */
    eProsima_user_DllExport ColorEnum& enum_value()
    {
        return m_enum_value;
    }



private:

    ColorEnum m_enum_value{ColorEnum::RED};

};

#endif // _FAST_DDS_GENERATED_ENUM_STRUCT_HPP_


